/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect;

import gnu.trove.TIntObjectHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.reflect.ClassInfo;

public class ClassInfoRepository {
    private static final TIntObjectHashMap s_repositories = new TIntObjectHashMap();
    private final Map m_repository = new WeakHashMap();
    private final transient WeakReference m_loaderRef;

    private ClassInfoRepository(ClassLoader loader) {
        this.m_loaderRef = new WeakReference<ClassLoader>(loader);
    }

    public static synchronized ClassInfoRepository getRepository(ClassLoader loader) {
        ClassInfoRepository repository;
        int hash = loader == null ? 0 : loader.hashCode();
        WeakReference repositoryRef = (WeakReference)s_repositories.get(hash);
        ClassInfoRepository classInfoRepository = repository = repositoryRef == null ? null : (ClassInfoRepository)repositoryRef.get();
        if (repository != null) {
            return repository;
        }
        ClassInfoRepository repo = new ClassInfoRepository(loader);
        s_repositories.put(hash, new WeakReference<ClassInfoRepository>(repo));
        return repo;
    }

    public static void removeClassInfoFromAllClassLoaders(String className) {
        throw new UnsupportedOperationException("fix algorithm");
    }

    public ClassInfo getClassInfo(String className) {
        ClassInfo info = (ClassInfo)this.m_repository.get(className);
        if (info == null) {
            return this.checkParentClassRepository(className, (ClassLoader)this.m_loaderRef.get());
        }
        return (ClassInfo)this.m_repository.get(className);
    }

    public void addClassInfo(ClassInfo classInfo) {
        if (this.checkParentClassRepository(classInfo.getName(), (ClassLoader)this.m_loaderRef.get()) == null) {
            this.m_repository.put(new String(classInfo.getName()), classInfo);
        }
    }

    public boolean hasClassInfo(String name) {
        return this.m_repository.containsKey(name);
    }

    public ClassInfo checkParentClassRepository(String className, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        ClassLoader parent = loader.getParent();
        if (parent == null) {
            return null;
        }
        ClassInfo info = ClassInfoRepository.getRepository(parent).getClassInfo(className);
        if (info != null) {
            return info;
        }
        return this.checkParentClassRepository(className, parent);
    }
}

