/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import java.lang.ref.WeakReference;
import java.util.List;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.asm.MemberStruct;

public abstract class AsmMemberInfo
implements MemberInfo {
    protected final MemberStruct m_member;
    protected final WeakReference m_loaderRef;
    protected final String m_declaringTypeName;
    protected ClassInfo m_declaringType;
    protected List m_annotations = null;
    protected final AsmClassInfoRepository m_classInfoRepository;

    AsmMemberInfo(MemberStruct member, String declaringType, ClassLoader loader) {
        if (member == null) {
            throw new IllegalArgumentException("member can not be null");
        }
        if (declaringType == null) {
            throw new IllegalArgumentException("declaring type can not be null");
        }
        this.m_member = member;
        this.m_loaderRef = new WeakReference<ClassLoader>(loader);
        this.m_declaringTypeName = declaringType.replace('/', '.');
        this.m_classInfoRepository = AsmClassInfoRepository.getRepository(loader);
    }

    public String getName() {
        return this.m_member.name;
    }

    public int getModifiers() {
        return this.m_member.modifiers;
    }

    public ClassInfo getDeclaringType() {
        if (this.m_declaringType == null) {
            this.m_declaringType = this.m_classInfoRepository.getClassInfo(this.m_declaringTypeName);
        }
        return this.m_declaringType;
    }
}

