/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.transform.inlining.AspectInfo;

public class AdviceMethodInfo {
    private final AspectInfo m_aspectInfo;
    private final AdviceInfo m_adviceInfo;
    private int m_specialArgumentIndex = -1;
    private int m_joinPointIndex;
    private String m_calleeClassSignature;
    private String m_callerClassSignature;
    private String m_joinPointClassName;
    private String m_calleeMemberDesc;

    public AdviceMethodInfo(AdviceInfo adviceInfo, String aspectFieldName, String aspectClassName, String aspectClassSignature, String callerClassSignature, String calleeClassSignature, String joinPointClassName, String calleeMemberDesc) {
        this.m_adviceInfo = adviceInfo;
        this.m_aspectInfo = new AspectInfo(adviceInfo.getAdviceDefinition().getAspectDefinition(), aspectFieldName, aspectClassName, aspectClassSignature);
        this.m_callerClassSignature = callerClassSignature;
        this.m_calleeClassSignature = calleeClassSignature;
        this.m_joinPointClassName = joinPointClassName;
        this.m_calleeMemberDesc = calleeMemberDesc;
    }

    public AdviceInfo getAdviceInfo() {
        return this.m_adviceInfo;
    }

    public AspectInfo getAspectInfo() {
        return this.m_aspectInfo;
    }

    public int[] getAdviceMethodArgIndexes() {
        return this.m_adviceInfo.getMethodToArgIndexes();
    }

    public String getSpecialArgumentTypeDesc() {
        return this.m_adviceInfo.getSpecialArgumentTypeDesc();
    }

    public String getSpecialArgumentTypeName() {
        return this.m_adviceInfo.getSpecialArgumentTypeName();
    }

    public int getJoinPointIndex() {
        return this.m_joinPointIndex;
    }

    public void setJoinPointIndex(int joinPointIndex) {
        this.m_joinPointIndex = joinPointIndex;
    }

    public int getSpecialArgumentIndex() {
        return this.m_specialArgumentIndex;
    }

    public void setSpecialArgumentIndex(int index) {
        this.m_specialArgumentIndex = index;
    }

    public String getCalleeClassSignature() {
        return this.m_calleeClassSignature;
    }

    public String getCallerClassSignature() {
        return this.m_callerClassSignature;
    }

    public String getJoinPointClassName() {
        return this.m_joinPointClassName;
    }

    public String getCalleeMemberDesc() {
        return this.m_calleeMemberDesc;
    }

    public boolean requiresThisOrTarget() {
        if (this.m_adviceInfo.hasTargetWithRuntimeCheck()) {
            return true;
        }
        for (int i = 0; i < this.m_adviceInfo.getMethodToArgIndexes().length; ++i) {
            int index = this.m_adviceInfo.getMethodToArgIndexes()[i];
            if (index != -3 && index != -4) continue;
            return true;
        }
        return false;
    }

    public boolean requiresJoinPoint() {
        for (int i = 0; i < this.m_adviceInfo.getMethodToArgIndexes().length; ++i) {
            int index = this.m_adviceInfo.getMethodToArgIndexes()[i];
            if (index != -1) continue;
            return true;
        }
        return false;
    }
}

