/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.cflow.CflowCompiler;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.Compiler;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AdviceMethodInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AspectInfo;
import org.codehaus.aspectwerkz.transform.inlining.AspectModelManager;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.RuntimeCheckVisitor;
import org.codehaus.aspectwerkz.transform.inlining.spi.AspectModel;

public abstract class AbstractJoinPointCompiler
implements Compiler,
TransformationConstants {
    protected static final String TARGET_CLASS_FIELD_NAME = "TARGET_CLASS";
    protected static final String THIS_CLASS_FIELD_NAME = "THIS_CLASS";
    public static final boolean DUMP_JIT_CLASSES = false;
    protected static final String DUMP_DIR = "_dump";
    protected final String m_callerClassName;
    protected final String m_calleeClassName;
    protected final String m_callerClassSignature;
    protected final String m_calleeClassSignature;
    protected final String m_joinPointClassName;
    protected final int m_joinPointType;
    protected final int m_joinPointHash;
    protected final String m_callerMethodName;
    protected final String m_callerMethodDesc;
    protected final int m_callerMethodModifiers;
    protected final String m_calleeMemberName;
    protected final String m_calleeMemberDesc;
    protected final int m_calleeMemberModifiers;
    protected ClassWriter m_cw;
    protected AspectInfo[] m_aspectInfos;
    protected AspectModel[] m_aspectModels;
    protected AdviceMethodInfo[] m_aroundAdviceMethodInfos;
    protected AdviceMethodInfo[] m_beforeAdviceMethodInfos;
    protected AdviceMethodInfo[] m_afterFinallyAdviceMethodInfos;
    protected AdviceMethodInfo[] m_afterReturningAdviceMethodInfos;
    protected AdviceMethodInfo[] m_afterThrowingAdviceMethodInfos;
    protected final List m_customProceedMethodStructs = new ArrayList();
    protected boolean m_hasAroundAdvices = false;
    protected boolean m_requiresThisOrTarget = false;
    protected boolean m_requiresJoinPoint = false;
    protected String[] m_fieldNames;
    protected Type[] m_argumentTypes;
    protected Type m_returnType;
    protected boolean m_isThisAdvisable = false;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType;

    public AbstractJoinPointCompiler(CompilationInfo.Model model) {
        this.m_joinPointClassName = model.getJoinPointClassName();
        EmittedJoinPoint emittedJoinPoint = model.getEmittedJoinPoint();
        this.m_joinPointHash = emittedJoinPoint.getJoinPointHash();
        this.m_joinPointType = emittedJoinPoint.getJoinPointType();
        this.m_callerMethodName = emittedJoinPoint.getCallerMethodName();
        this.m_callerMethodDesc = emittedJoinPoint.getCallerMethodDesc();
        this.m_callerMethodModifiers = emittedJoinPoint.getCallerMethodModifiers();
        this.m_calleeMemberName = emittedJoinPoint.getCalleeMemberName();
        this.m_calleeMemberDesc = emittedJoinPoint.getCalleeMemberDesc();
        this.m_calleeMemberModifiers = emittedJoinPoint.getCalleeMemberModifiers();
        this.m_callerClassName = emittedJoinPoint.getCallerClassName().replace('.', '/');
        this.m_calleeClassName = emittedJoinPoint.getCalleeClassName().replace('.', '/');
        this.m_callerClassSignature = "L" + emittedJoinPoint.getCallerClassName().replace('.', '/') + ";";
        this.m_calleeClassSignature = "L" + emittedJoinPoint.getCalleeClassName().replace('.', '/') + ";";
        this.m_argumentTypes = this.getJoinPointArgumentTypes();
        this.m_returnType = this.getJoinPointReturnType();
        this.initialize(model);
    }

    private synchronized void initialize(CompilationInfo.Model model) {
        this.checkIfThisIsAdvisable(model);
        AdviceInfoContainer advices = model.getAdviceInfoContainer();
        this.collectAdviceInfo(advices);
        this.collectCustomProceedMethods(model, advices);
        this.m_hasAroundAdvices = this.m_aroundAdviceMethodInfos.length > 0;
        this.m_requiresThisOrTarget = this.requiresThisOrTarget();
        this.m_requiresJoinPoint = this.requiresJoinPoint();
        this.setupReferencedAspectModels();
        this.m_cw = AsmHelper.newClassWriter(true);
    }

    private void collectAdviceInfo(AdviceInfoContainer advices) {
        ArrayList aspectQualifiedNames = new ArrayList();
        HashSet aspectInfos = new HashSet();
        this.m_beforeAdviceMethodInfos = this.getAdviceMethodInfos(aspectQualifiedNames, aspectInfos, advices.getBeforeAdviceInfos());
        this.m_aroundAdviceMethodInfos = this.getAdviceMethodInfos(aspectQualifiedNames, aspectInfos, advices.getAroundAdviceInfos());
        this.m_afterReturningAdviceMethodInfos = this.getAdviceMethodInfos(aspectQualifiedNames, aspectInfos, advices.getAfterReturningAdviceInfos());
        this.m_afterFinallyAdviceMethodInfos = this.getAdviceMethodInfos(aspectQualifiedNames, aspectInfos, advices.getAfterFinallyAdviceInfos());
        this.m_afterThrowingAdviceMethodInfos = this.getAdviceMethodInfos(aspectQualifiedNames, aspectInfos, advices.getAfterThrowingAdviceInfos());
        this.m_aspectInfos = aspectInfos.toArray(new AspectInfo[aspectInfos.size()]);
    }

    private void collectCustomProceedMethods(CompilationInfo.Model model, AdviceInfoContainer advices) {
        ClassLoader loader = model.getThisClassInfo().getClassLoader();
        AdviceInfo[] beforeAdviceInfos = advices.getBeforeAdviceInfos();
        for (int i = 0; i < beforeAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(beforeAdviceInfos[i], loader);
        }
        AdviceInfo[] aroundAdviceInfos = advices.getAroundAdviceInfos();
        for (int i = 0; i < aroundAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(aroundAdviceInfos[i], loader);
        }
        AdviceInfo[] afterFinallyAdviceInfos = advices.getAfterFinallyAdviceInfos();
        for (int i = 0; i < afterFinallyAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(afterFinallyAdviceInfos[i], loader);
        }
        AdviceInfo[] afterReturningAdviceInfos = advices.getAfterReturningAdviceInfos();
        for (int i = 0; i < afterReturningAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(afterReturningAdviceInfos[i], loader);
        }
        AdviceInfo[] afterThrowingAdviceInfos = advices.getAfterThrowingAdviceInfos();
        for (int i = 0; i < afterThrowingAdviceInfos.length; ++i) {
            this.collectCustomProceedMethods(afterThrowingAdviceInfos[i], loader);
        }
    }

    private void collectCustomProceedMethods(AdviceInfo adviceInfo, ClassLoader loader) {
        ClassInfo classInfo;
        Type firstParam;
        Type[] paramTypes = adviceInfo.getMethodParameterTypes();
        if (paramTypes.length != 0 && (firstParam = paramTypes[0]).getSort() == 10 && !firstParam.getClassName().equals("org.codehaus.aspectwerkz.joinpoint.JoinPoint") && !firstParam.getClassName().equals("org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint") && (ClassInfoHelper.implementsInterface(classInfo = AsmClassInfo.getClassInfo(firstParam.getClassName(), loader), "org.codehaus.aspectwerkz.joinpoint.JoinPoint") || ClassInfoHelper.implementsInterface(classInfo, "org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint"))) {
            MethodInfo[] methods = classInfo.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodInfo method = methods[j];
                if (!method.getName().equals("proceed")) continue;
                this.m_customProceedMethodStructs.add(new CustomProceedMethodStruct(method, adviceInfo.getMethodToArgIndexes()));
            }
        }
    }

    private void checkIfThisIsAdvisable(CompilationInfo.Model model) {
        if (!Modifier.isStatic(this.m_callerMethodModifiers)) {
            ClassInfo[] interfaces = model.getThisClassInfo().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getName().equals("org.codehaus.aspectwerkz.intercept.Advisable")) continue;
                this.m_isThisAdvisable = true;
                break;
            }
        }
    }

    private void setupReferencedAspectModels() {
        HashMap<String, AspectModel> aspectModelMap = new HashMap<String, AspectModel>();
        for (int i = 0; i < this.m_aspectInfos.length; ++i) {
            AspectDefinition aspectDef = this.m_aspectInfos[i].getAspectDefinition();
            if (aspectDef.isAspectWerkzAspect()) continue;
            String type = aspectDef.getAspectModel();
            AspectModel aspectModel = AspectModelManager.getModelFor(type);
            aspectModelMap.put(type, aspectModel);
            if (!aspectModel.requiresReflectiveInfo()) continue;
            this.m_requiresJoinPoint = true;
        }
        this.m_aspectModels = aspectModelMap.values().toArray(new AspectModel[aspectModelMap.size()]);
    }

    private String getJoinPointInterface() {
        String joinPointInterface = this.requiresProceedMethod() || this.m_requiresJoinPoint ? "org/codehaus/aspectwerkz/joinpoint/JoinPoint" : "org/codehaus/aspectwerkz/joinpoint/StaticJoinPoint";
        return joinPointInterface;
    }

    protected AdviceMethodInfo[] getAdviceMethodInfos(List aspectQualifiedNames, Set aspectInfos, AdviceInfo[] adviceInfos) {
        ArrayList<AdviceMethodInfo> adviceMethodInfosSet = new ArrayList<AdviceMethodInfo>();
        for (int i = 0; i < adviceInfos.length; ++i) {
            AdviceInfo adviceInfo = adviceInfos[i];
            DeploymentModel deploymentModel = adviceInfo.getAdviceDefinition().getAspectDefinition().getDeploymentModel();
            if (deploymentModel.equals(DeploymentModel.PER_INSTANCE) && Modifier.isStatic(this.m_callerMethodModifiers)) continue;
            String aspectClassName = adviceInfo.getAspectClassName().replace('.', '/');
            if (!aspectQualifiedNames.contains(adviceInfo.getAspectQualifiedName())) {
                aspectQualifiedNames.add(adviceInfo.getAspectQualifiedName());
            }
            int aspectIndex = aspectQualifiedNames.indexOf(adviceInfo.getAspectQualifiedName());
            AdviceMethodInfo adviceMethodInfo = new AdviceMethodInfo(adviceInfo, "ASPECT_" + aspectIndex, aspectClassName, "L" + aspectClassName + ";", this.m_callerClassSignature, this.m_calleeClassSignature, this.m_joinPointClassName, this.m_calleeMemberDesc);
            adviceMethodInfosSet.add(adviceMethodInfo);
            aspectInfos.add(adviceMethodInfo.getAspectInfo());
        }
        return adviceMethodInfosSet.toArray(new AdviceMethodInfo[adviceMethodInfosSet.size()]);
    }

    protected abstract void createJoinPointSpecificFields();

    protected abstract void createSignature(CodeVisitor var1);

    protected abstract void createInlinedJoinPointInvocation(CodeVisitor var1, boolean var2, int var3, int var4);

    protected abstract void createJoinPointInvocation(CodeVisitor var1);

    protected abstract Type getJoinPointReturnType();

    protected abstract Type[] getJoinPointArgumentTypes();

    protected abstract void createGetRttiMethod();

    protected abstract void createGetSignatureMethod();

    public byte[] compile() {
        try {
            this.createClassHeader();
            this.createMandatoryMethodInAspectModels();
            this.createFieldsCommonToAllJoinPoints();
            this.createJoinPointSpecificFields();
            this.createStaticInitializer();
            this.createClinit();
            this.createInit();
            this.createUtilityMethods();
            this.createCopyMethod();
            this.createGetSignatureMethod();
            this.createInvokeMethod();
            if (this.requiresProceedMethod()) {
                this.createProceedMethod();
            }
            if (this.m_requiresJoinPoint) {
                this.createGetRttiMethod();
            }
            this.createCustomProceedMethods();
            this.m_cw.visitEnd();
            return this.m_cw.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuffer buf = new StringBuffer();
            buf.append("could not compile join point instance for join point with hash [");
            buf.append(this.m_joinPointHash);
            buf.append("] and declaring class [");
            buf.append(this.m_callerClassName);
            buf.append("] due to: ");
            if (e instanceof InvocationTargetException) {
                buf.append(((InvocationTargetException)e).getTargetException().toString());
            } else {
                buf.append(e.toString());
            }
            throw new RuntimeException(buf.toString());
        }
    }

    protected void createFieldsCommonToAllJoinPoints() {
        if (this.m_returnType.getSort() != 0) {
            this.m_cw.visitField(2, "RETURN_VALUE", this.m_returnType.getDescriptor(), null, null);
        }
        this.m_cw.visitField(10, TARGET_CLASS_FIELD_NAME, "Ljava/lang/Class;", null, null);
        this.m_cw.visitField(26, THIS_CLASS_FIELD_NAME, "Ljava/lang/Class;", null, null);
        this.m_cw.visitField(26, "ENCLOSINGSJP", "Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;", null, null);
        this.m_cw.visitField(10, "META_DATA", "Ljava/util/Map;", null, null);
        this.m_cw.visitField(10, "OPTIMIZED_JOIN_POINT", "L" + this.m_joinPointClassName + ";", null, null);
        this.m_cw.visitField(2, "CALLEE", this.m_calleeClassSignature, null, null);
        this.m_cw.visitField(2, "CALLER", this.m_callerClassSignature, null, null);
        this.m_cw.visitField(2, "STACK_FRAME_COUNTER", "I", null, null);
        if (this.m_isThisAdvisable) {
            this.m_cw.visitField(2, "INTERCEPTOR_INDEX", "I", null, null);
            this.m_cw.visitField(2, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AROUND_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_BEFORE_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AFTER_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I", null, null);
            this.m_cw.visitField(2, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;", null, null);
            this.m_cw.visitField(2, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I", null, null);
        }
    }

    protected void createClinit() {
        CodeVisitor cv = this.m_cw.visitMethod(8, "<clinit>", "()V", null, null);
        cv.visitMethodInsn(184, this.m_joinPointClassName, "aw$staticinitialization", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    protected void createInit() {
        CodeVisitor cv = this.m_cw.visitMethod(2, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        boolean hasAroundClosureBaseClass = false;
        AspectModel aspectModel = null;
        for (int i = 0; i < this.m_aspectModels.length; ++i) {
            aspectModel = this.m_aspectModels[i];
            if (aspectModel.getAroundClosureClassInfo().getSuperClassName() == null) continue;
            hasAroundClosureBaseClass = true;
            break;
        }
        if (hasAroundClosureBaseClass) {
            aspectModel.createInvocationOfAroundClosureSuperClass(cv);
        } else {
            cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        }
        this.resetStackFrameCounter(cv);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void createClassHeader() {
        HashSet<String> interfaces = new HashSet<String>();
        String baseClass = "java/lang/Object";
        for (int i = 0; i < this.m_aspectModels.length; ++i) {
            AspectModel aspectModel = this.m_aspectModels[i];
            AspectModel.AroundClosureClassInfo closureClassInfo = aspectModel.getAroundClosureClassInfo();
            String superClassName = closureClassInfo.getSuperClassName();
            String[] interfaceNames = closureClassInfo.getInterfaceNames();
            if (superClassName != null) {
                if (!baseClass.equals("java/lang/Object")) {
                    throw new RuntimeException("compiled join point can only subclass one around closure base class but more than registered aspect model requires a closure base class");
                }
                baseClass = superClassName;
            }
            if (interfaceNames.length == 0) continue;
            for (int j = 0; j < interfaceNames.length; ++j) {
                interfaces.add(interfaceNames[j]);
            }
        }
        Iterator it = this.m_customProceedMethodStructs.iterator();
        while (it.hasNext()) {
            MethodInfo methodInfo = ((CustomProceedMethodStruct)it.next()).customProceed;
            interfaces.add(methodInfo.getDeclaringType().getName().replace('.', '/'));
        }
        int i = 1;
        String[] interfaceArr = new String[interfaces.size() + 1];
        interfaceArr[0] = this.getJoinPointInterface();
        Iterator it2 = interfaces.iterator();
        while (it2.hasNext()) {
            interfaceArr[i] = (String)it2.next();
            ++i;
        }
        this.m_cw.visit(AsmHelper.JAVA_VERSION, 33, this.m_joinPointClassName, baseClass, interfaceArr, null);
    }

    private void createMandatoryMethodInAspectModels() {
        for (int i = 0; i < this.m_aspectModels.length; ++i) {
            this.m_aspectModels[i].createMandatoryMethods(this.m_cw, this.m_joinPointClassName);
        }
    }

    private void createCustomProceedMethods() {
        HashSet<String> addedMethodSignatures = new HashSet<String>();
        Iterator it = this.m_customProceedMethodStructs.iterator();
        while (it.hasNext()) {
            CustomProceedMethodStruct customProceedStruct = (CustomProceedMethodStruct)it.next();
            MethodInfo methodInfo = customProceedStruct.customProceed;
            String desc = methodInfo.getSignature();
            if (addedMethodSignatures.contains(desc)) continue;
            addedMethodSignatures.add(desc);
            CodeVisitor cv = this.m_cw.visitMethod(17, "proceed", desc, new String[]{"java/lang/Throwable"}, null);
            int argStackIndex = 1;
            for (int i = 1; i < customProceedStruct.adviceToTargetArgs.length; ++i) {
                int targetArg = customProceedStruct.adviceToTargetArgs[i];
                if (targetArg >= 0) {
                    String fieldName = this.m_fieldNames[targetArg];
                    cv.visitVarInsn(25, 0);
                    Type type = this.m_argumentTypes[targetArg];
                    argStackIndex = AsmHelper.loadType(cv, argStackIndex, type);
                    cv.visitFieldInsn(181, this.m_joinPointClassName, fieldName, type.getDescriptor());
                    continue;
                }
                if (targetArg == -3) {
                    cv.visitVarInsn(25, 0);
                    argStackIndex = AsmHelper.loadType(cv, argStackIndex, Type.getType(this.m_calleeClassSignature));
                    cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
                    continue;
                }
                if (targetArg != -4) continue;
                cv.visitVarInsn(25, 0);
                argStackIndex = AsmHelper.loadType(cv, argStackIndex, Type.getType(this.m_callerClassSignature));
                cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
            }
            Type returnType = Type.getType(customProceedStruct.customProceed.getReturnType().getSignature());
            if (AsmHelper.isPrimitive(returnType)) {
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(183, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
                AsmHelper.unwrapType(cv, returnType);
            } else {
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(183, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
                if (!returnType.getClassName().equals("Ljava/lang/Object;")) {
                    cv.visitTypeInsn(192, returnType.getInternalName());
                }
            }
            AsmHelper.addReturnStatement(cv, returnType);
            cv.visitMaxs(0, 0);
        }
    }

    protected void createStaticInitializer() {
        CodeVisitor cv = this.m_cw.visitMethod(9, "aw$staticinitialization", "()V", null, null);
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        cv.visitLdcInsn(this.m_calleeClassName.replace('/', '.'));
        cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        cv.visitFieldInsn(179, this.m_joinPointClassName, TARGET_CLASS_FIELD_NAME, "Ljava/lang/Class;");
        cv.visitLdcInsn(this.m_callerClassName.replace('/', '.'));
        cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        cv.visitFieldInsn(179, this.m_joinPointClassName, THIS_CLASS_FIELD_NAME, "Ljava/lang/Class;");
        Label finallyLabel = new Label();
        cv.visitLabel(finallyLabel);
        Label gotoFinallyLabel = new Label();
        cv.visitJumpInsn(167, gotoFinallyLabel);
        Label catchLabel = new Label();
        cv.visitLabel(catchLabel);
        cv.visitVarInsn(58, 0);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, "java/lang/Throwable", "printStackTrace", "()V");
        cv.visitTypeInsn(187, "java/lang/RuntimeException");
        cv.visitInsn(89);
        cv.visitLdcInsn("could not load target class using Class.forName() in generated join point base class " + this.m_joinPointClassName);
        cv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V");
        cv.visitInsn(191);
        cv.visitLabel(gotoFinallyLabel);
        this.createEnclosingStaticJoinPoint(cv);
        cv.visitTypeInsn(187, "java/util/HashMap");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "META_DATA", "Ljava/util/Map;");
        this.createSignature(cv);
        cv.visitTypeInsn(187, this.m_joinPointClassName);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, this.m_joinPointClassName, "<init>", "()V");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "OPTIMIZED_JOIN_POINT", "L" + this.m_joinPointClassName + ";");
        for (int i = 0; i < this.m_aspectInfos.length; ++i) {
            this.createAndInitializeAspectField(this.m_aspectInfos[i], cv);
        }
        cv.visitInsn(177);
        cv.visitTryCatchBlock(tryLabel, finallyLabel, catchLabel, "java/lang/ClassNotFoundException");
        cv.visitMaxs(0, 0);
    }

    protected void createEnclosingStaticJoinPoint(CodeVisitor cv) {
        cv.visitFieldInsn(178, this.m_joinPointClassName, THIS_CLASS_FIELD_NAME, "Ljava/lang/Class;");
        cv.visitLdcInsn(this.m_callerMethodName);
        cv.visitLdcInsn(this.m_callerMethodDesc);
        cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/joinpoint/management/SignatureFactory", "newEnclosingStaticJoinPoint", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;");
        cv.visitFieldInsn(179, this.m_joinPointClassName, "ENCLOSINGSJP", "Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;");
    }

    protected boolean createAndInitializeAspectField(AspectInfo aspectInfo, CodeVisitor cv) {
        if (aspectInfo.getAspectDefinition().isAspectWerkzAspect()) {
            AbstractJoinPointCompiler.createAspectReferenceField(this.m_cw, aspectInfo);
            AbstractJoinPointCompiler.createAspectInstantiation(cv, aspectInfo, this.m_joinPointClassName);
        } else {
            String type = aspectInfo.getAspectDefinition().getAspectModel();
            AspectModel aspectModel = AspectModelManager.getModelFor(type);
            aspectModel.createAspectReferenceField(this.m_cw, aspectInfo, this.m_joinPointClassName);
            aspectModel.createAspectInstantiation(cv, aspectInfo, this.m_joinPointClassName);
        }
        return false;
    }

    public static void createAspectReferenceField(ClassWriter cw, AspectInfo aspectInfo) {
        String aspectClassSignature = aspectInfo.getAspectClassSignature();
        DeploymentModel deploymentModel = aspectInfo.getDeploymentModel();
        if (deploymentModel.equals(DeploymentModel.PER_JVM) || deploymentModel.equals(DeploymentModel.PER_CLASS)) {
            cw.visitField(10, aspectInfo.getAspectFieldName(), aspectClassSignature, null, null);
        } else if (deploymentModel.equals(DeploymentModel.PER_INSTANCE)) {
            cw.visitField(2, aspectInfo.getAspectFieldName(), aspectClassSignature, null, null);
        } else {
            throw new UnsupportedOperationException("unsupported deployment model - " + aspectInfo.getAspectClassName() + " " + deploymentModel);
        }
    }

    public static void createAspectInstantiation(CodeVisitor cv, AspectInfo aspectInfo, String joinPointClassName) {
        String aspectClassSignature = aspectInfo.getAspectClassSignature();
        String aspectClassName = aspectInfo.getAspectClassName();
        DeploymentModel deploymentModel = aspectInfo.getDeploymentModel();
        if (CflowCompiler.isCflowClass(aspectClassName)) {
            cv.visitMethodInsn(184, aspectClassName, "aspectOf", "()" + aspectClassSignature);
            cv.visitFieldInsn(179, joinPointClassName, aspectInfo.getAspectFieldName(), aspectClassSignature);
        } else if (deploymentModel.equals(DeploymentModel.PER_JVM)) {
            cv.visitFieldInsn(178, joinPointClassName, THIS_CLASS_FIELD_NAME, "Ljava/lang/Class;");
            cv.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;");
            cv.visitLdcInsn(aspectInfo.getAspectQualifiedName());
            cv.visitLdcInsn(aspectInfo.getAspectDefinition().getContainerClassName());
            cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Aspects", "aspect$Of", "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
            cv.visitTypeInsn(192, aspectClassName);
            cv.visitFieldInsn(179, joinPointClassName, aspectInfo.getAspectFieldName(), aspectClassSignature);
        } else if (deploymentModel.equals(DeploymentModel.PER_CLASS)) {
            cv.visitLdcInsn(aspectInfo.getAspectQualifiedName());
            cv.visitLdcInsn(aspectInfo.getAspectDefinition().getContainerClassName());
            cv.visitFieldInsn(178, joinPointClassName, THIS_CLASS_FIELD_NAME, "Ljava/lang/Class;");
            cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Aspects", "aspect$Of", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;");
            cv.visitTypeInsn(192, aspectClassName);
            cv.visitFieldInsn(179, joinPointClassName, aspectInfo.getAspectFieldName(), aspectClassSignature);
        } else if (!deploymentModel.equals(DeploymentModel.PER_INSTANCE)) {
            throw new UnsupportedOperationException("unsupported deployment model - " + aspectInfo.getAspectClassName() + " " + deploymentModel);
        }
    }

    protected void createInvokeMethod() {
        String invokeDesc = this.buildInvokeMethodSignature();
        CodeVisitor cv = this.m_cw.visitMethod(25, "invoke", invokeDesc, new String[]{"java/lang/Throwable"}, null);
        int calleeIndex = -1;
        int argStartIndex = 0;
        if (!Modifier.isStatic(this.m_calleeMemberModifiers) && this.m_joinPointType != 4 && this.m_joinPointType != 7) {
            calleeIndex = 0;
            ++argStartIndex;
        } else {
            calleeIndex = -1;
        }
        int callerIndex = argStartIndex + AsmHelper.getRegisterDepth(this.m_argumentTypes);
        if (this.m_joinPointType == 7) {
            calleeIndex = 0;
            callerIndex = 2;
            argStartIndex = 1;
        }
        boolean isOptimizedJoinPoint = !this.m_requiresJoinPoint && !this.requiresProceedMethod();
        int joinPointIndex = -1;
        if (!isOptimizedJoinPoint) {
            joinPointIndex = callerIndex + 1;
            this.createInvocationLocalJoinPointInstance(cv, argStartIndex, joinPointIndex, callerIndex, calleeIndex);
        }
        this.initializeInstanceLevelAspects(cv, isOptimizedJoinPoint, joinPointIndex, callerIndex, calleeIndex);
        this.createBeforeAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointIndex, callerIndex, calleeIndex);
        if (this.m_afterFinallyAdviceMethodInfos.length == 0 && this.m_afterThrowingAdviceMethodInfos.length == 0 && !this.m_isThisAdvisable) {
            this.createPartOfInvokeMethodWithoutAfterFinallyAndAfterThrowingAdviceTypes(cv, isOptimizedJoinPoint, joinPointIndex, argStartIndex, callerIndex, calleeIndex);
        } else if (this.m_afterThrowingAdviceMethodInfos.length == 0 && !this.m_isThisAdvisable) {
            this.createPartOfInvokeMethodWithoutAfterThrowingAdviceTypes(cv, isOptimizedJoinPoint, joinPointIndex, argStartIndex, callerIndex, calleeIndex);
        } else {
            this.createPartOfInvokeMethodWithAllAdviceTypes(cv, true, joinPointIndex, argStartIndex, callerIndex, calleeIndex);
        }
        cv.visitMaxs(0, 0);
    }

    protected void initializeInstanceLevelAspects(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointIndex, int callerIndex, int calleeIndex) {
        for (int i = 0; i < this.m_aspectInfos.length; ++i) {
            AspectInfo aspectInfo = this.m_aspectInfos[i];
            if (aspectInfo.getDeploymentModel() != DeploymentModel.PER_INSTANCE) continue;
            this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointIndex);
            if (callerIndex >= 0) {
                cv.visitVarInsn(25, callerIndex);
            }
            cv.visitLdcInsn(aspectInfo.getAspectClassName().replace('/', '.'));
            cv.visitLdcInsn(aspectInfo.getAspectQualifiedName());
            cv.visitLdcInsn(aspectInfo.getAspectDefinition().getContainerClassName());
            cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/aspect/management/HasInstanceLevelAspect", "aw$getAspect", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
            cv.visitTypeInsn(192, aspectInfo.getAspectClassName());
            cv.visitFieldInsn(181, this.m_joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        }
    }

    protected void createPartOfInvokeMethodWithAllAdviceTypes(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointInstanceIndex, int argStartIndex, int callerIndex, int calleeIndex) {
        int returnValueIndex = joinPointInstanceIndex != -1 ? joinPointInstanceIndex + 1 : callerIndex + 1;
        int exceptionIndex1 = returnValueIndex + 1;
        int exceptionIndex2 = returnValueIndex + 2;
        cv.visitInsn(1);
        cv.visitVarInsn(58, returnValueIndex);
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        if (!this.requiresProceedMethod()) {
            this.createInlinedJoinPointInvocation(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex);
            int stackIndex = returnValueIndex;
            AsmHelper.storeType(cv, stackIndex, this.m_returnType);
            this.addReturnedValueToJoinPoint(cv, returnValueIndex, joinPointInstanceIndex, false);
        } else {
            this.createInvocationToProceedMethod(cv, joinPointInstanceIndex, returnValueIndex);
        }
        this.createAfterReturningAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        Label finallyLabel1 = new Label();
        cv.visitLabel(finallyLabel1);
        if (this.m_isThisAdvisable) {
            int registerDepth = callerIndex + 2;
            this.createAfterInterceptorInvocations(cv, joinPointInstanceIndex, registerDepth);
        }
        this.createAfterFinallyAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        Label gotoFinallyLabel = new Label();
        cv.visitJumpInsn(167, gotoFinallyLabel);
        Label catchLabel = new Label();
        cv.visitLabel(catchLabel);
        cv.visitVarInsn(58, exceptionIndex1);
        if (this.m_isThisAdvisable) {
            this.createAfterThrowingInterceptorInvocations(cv, joinPointInstanceIndex, exceptionIndex1);
        }
        for (int i = this.m_afterThrowingAdviceMethodInfos.length - 1; i >= 0; --i) {
            AdviceMethodInfo advice = this.m_afterThrowingAdviceMethodInfos[i];
            advice.setSpecialArgumentIndex(exceptionIndex1);
            cv.visitVarInsn(25, exceptionIndex1);
            String specialArgTypeName = advice.getSpecialArgumentTypeName();
            if (specialArgTypeName != null) {
                cv.visitTypeInsn(193, specialArgTypeName);
                Label ifInstanceOfLabel = new Label();
                cv.visitJumpInsn(153, ifInstanceOfLabel);
                this.createAfterAdviceInvocation(cv, isOptimizedJoinPoint, advice, joinPointInstanceIndex, argStartIndex, callerIndex, calleeIndex, exceptionIndex1);
                cv.visitLabel(ifInstanceOfLabel);
                continue;
            }
            this.createAfterAdviceInvocation(cv, isOptimizedJoinPoint, advice, joinPointInstanceIndex, argStartIndex, callerIndex, calleeIndex, -1);
        }
        cv.visitVarInsn(25, exceptionIndex1);
        cv.visitInsn(191);
        Label exceptionLabel = new Label();
        cv.visitLabel(exceptionLabel);
        cv.visitVarInsn(58, exceptionIndex2);
        Label finallyLabel2 = new Label();
        cv.visitLabel(finallyLabel2);
        if (this.m_isThisAdvisable) {
            int registerDepth = callerIndex + 2;
            this.createAfterInterceptorInvocations(cv, joinPointInstanceIndex, registerDepth);
        }
        this.createAfterFinallyAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        cv.visitVarInsn(25, exceptionIndex2);
        cv.visitInsn(191);
        cv.visitLabel(gotoFinallyLabel);
        if (this.m_returnType.getSort() != 0) {
            if (this.requiresProceedMethod()) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
        }
        AsmHelper.addReturnStatement(cv, this.m_returnType);
        cv.visitTryCatchBlock(tryLabel, finallyLabel1, catchLabel, "java/lang/Throwable");
        cv.visitTryCatchBlock(tryLabel, finallyLabel1, exceptionLabel, null);
        cv.visitTryCatchBlock(catchLabel, finallyLabel2, exceptionLabel, null);
    }

    protected void createPartOfInvokeMethodWithoutAfterThrowingAdviceTypes(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointInstanceIndex, int argStartIndex, int callerIndex, int calleeIndex) {
        int returnValueIndex = joinPointInstanceIndex != -1 ? joinPointInstanceIndex + 1 : callerIndex + 1;
        int exceptionIndex = returnValueIndex + 1;
        cv.visitInsn(1);
        cv.visitVarInsn(58, returnValueIndex);
        Label tryLabel = new Label();
        cv.visitLabel(tryLabel);
        if (!this.requiresProceedMethod()) {
            this.createInlinedJoinPointInvocation(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex);
            int stackIndex = returnValueIndex;
            AsmHelper.storeType(cv, stackIndex, this.m_returnType);
            this.addReturnedValueToJoinPoint(cv, returnValueIndex, joinPointInstanceIndex, false);
        } else {
            this.createInvocationToProceedMethod(cv, joinPointInstanceIndex, returnValueIndex);
        }
        this.createAfterReturningAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        Label finallyLabel1 = new Label();
        cv.visitLabel(finallyLabel1);
        this.createAfterFinallyAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        Label gotoFinallyLabel = new Label();
        cv.visitJumpInsn(167, gotoFinallyLabel);
        Label exceptionLabel = new Label();
        cv.visitLabel(exceptionLabel);
        cv.visitVarInsn(58, exceptionIndex);
        Label finallyLabel2 = new Label();
        cv.visitLabel(finallyLabel2);
        this.createAfterFinallyAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        cv.visitVarInsn(25, exceptionIndex);
        cv.visitInsn(191);
        cv.visitLabel(gotoFinallyLabel);
        if (this.m_returnType.getSort() != 0) {
            if (this.requiresProceedMethod()) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
        }
        AsmHelper.addReturnStatement(cv, this.m_returnType);
        cv.visitTryCatchBlock(tryLabel, finallyLabel1, exceptionLabel, null);
        cv.visitTryCatchBlock(exceptionLabel, finallyLabel2, exceptionLabel, null);
    }

    protected void createPartOfInvokeMethodWithoutAfterFinallyAndAfterThrowingAdviceTypes(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointInstanceIndex, int argStartIndex, int callerIndex, int calleeIndex) {
        int returnValueIndex;
        int n = returnValueIndex = joinPointInstanceIndex != -1 ? joinPointInstanceIndex + 1 : callerIndex + 1;
        if (!this.requiresProceedMethod()) {
            this.createInlinedJoinPointInvocation(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex);
            int stackIndex = returnValueIndex;
            AsmHelper.storeType(cv, stackIndex, this.m_returnType);
            this.addReturnedValueToJoinPoint(cv, returnValueIndex, joinPointInstanceIndex, false);
        } else {
            this.createInvocationToProceedMethod(cv, joinPointInstanceIndex, returnValueIndex);
        }
        this.createAfterReturningAdviceInvocations(cv, isOptimizedJoinPoint, argStartIndex, joinPointInstanceIndex, callerIndex, calleeIndex);
        if (this.m_returnType.getSort() != 0) {
            if (this.requiresProceedMethod()) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
        }
        AsmHelper.addReturnStatement(cv, this.m_returnType);
    }

    protected void createInvocationToProceedMethod(CodeVisitor cv, int joinPointInstanceIndex, int returnValueIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitMethodInsn(182, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
        cv.visitVarInsn(58, returnValueIndex);
    }

    protected void createInvocationLocalJoinPointInstance(CodeVisitor cv, int argStartIndex, int joinPointInstanceIndex, int callerIndex, int calleeIndex) {
        cv.visitTypeInsn(187, this.m_joinPointClassName);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, this.m_joinPointClassName, "<init>", "()V");
        cv.visitVarInsn(58, joinPointInstanceIndex);
        int argStackIndex = argStartIndex;
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            String fieldName = this.m_fieldNames[i];
            cv.visitVarInsn(25, joinPointInstanceIndex);
            Type type = this.m_argumentTypes[i];
            argStackIndex = AsmHelper.loadType(cv, argStackIndex, type);
            cv.visitFieldInsn(181, this.m_joinPointClassName, fieldName, type.getDescriptor());
        }
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, callerIndex);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        if (calleeIndex != -1) {
            cv.visitVarInsn(25, 0);
        } else {
            cv.visitInsn(1);
        }
        cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        if (this.m_isThisAdvisable) {
            this.createInitializationForAdvisableManagement(cv, joinPointInstanceIndex, callerIndex);
        }
    }

    protected void createProceedMethod() {
        int i;
        CodeVisitor cv = this.m_cw.visitMethod(17, "proceed", "()Ljava/lang/Object;", new String[]{"java/lang/Throwable"}, null);
        if (this.m_isThisAdvisable) {
            this.createAroundInterceptorInvocations(cv);
        }
        this.incrementStackFrameCounter(cv);
        Label tryLabel = new Label();
        Label defaultCaseLabel = new Label();
        Label gotoLabel = new Label();
        Label handlerLabel = new Label();
        Label endLabel = new Label();
        int nrOfCases = this.m_aroundAdviceMethodInfos.length;
        if (this.m_isThisAdvisable) {
            ++nrOfCases;
        }
        Label[] caseLabels = new Label[nrOfCases];
        Label[] returnLabels = new Label[nrOfCases];
        int[] caseNumbers = new int[nrOfCases];
        for (i = 0; i < caseLabels.length; ++i) {
            caseLabels[i] = new Label();
            caseNumbers[i] = i;
        }
        for (i = 0; i < returnLabels.length; ++i) {
            returnLabels[i] = new Label();
        }
        cv.visitLabel(tryLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
        cv.visitLookupSwitchInsn(defaultCaseLabel, caseNumbers, caseLabels);
        for (i = 0; i < this.m_aroundAdviceMethodInfos.length; ++i) {
            cv.visitLabel(caseLabels[i]);
            AdviceMethodInfo adviceInfo = this.m_aroundAdviceMethodInfos[i];
            Label endInstanceOflabel = this.beginRuntimeCheck(cv, false, 0, adviceInfo.getAdviceInfo(), -1);
            this.loadAspect(cv, false, 0, adviceInfo.getAspectInfo());
            int[] argIndexes = adviceInfo.getAdviceMethodArgIndexes();
            for (int j = 0; j < argIndexes.length; ++j) {
                int argIndex = argIndexes[j];
                if (argIndex >= 0) {
                    Type argumentType = this.m_argumentTypes[argIndex];
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, this.m_joinPointClassName, "ARGUMENT_" + argIndex, argumentType.getDescriptor());
                    continue;
                }
                if (argIndex == -1 || argIndex == -2 || argIndex == -5 || argIndex == -7) {
                    cv.visitVarInsn(25, 0);
                    continue;
                }
                if (argIndex == -3) {
                    this.loadCallee(cv, false, 0, -1);
                    if (!adviceInfo.getAdviceInfo().hasTargetWithRuntimeCheck()) continue;
                    cv.visitTypeInsn(192, adviceInfo.getAdviceInfo().getMethodParameterTypes()[j].getInternalName());
                    continue;
                }
                if (argIndex == -4) {
                    this.loadCaller(cv, false, 0, -1);
                    continue;
                }
                throw new Error("advice method argument index type is not supported: " + argIndex);
            }
            cv.visitMethodInsn(182, adviceInfo.getAspectInfo().getAspectClassName(), adviceInfo.getAdviceInfo().getMethodName(), adviceInfo.getAdviceInfo().getMethodSignature());
            cv.visitVarInsn(58, 1);
            if (endInstanceOflabel != null) {
                Label elseInstanceOfLabel = new Label();
                cv.visitJumpInsn(167, elseInstanceOfLabel);
                this.endRuntimeCheck(cv, adviceInfo.getAdviceInfo(), endInstanceOflabel);
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(183, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
                cv.visitVarInsn(58, 1);
                cv.visitLabel(elseInstanceOfLabel);
            }
            cv.visitLabel(returnLabels[i]);
            cv.visitVarInsn(25, 1);
            cv.visitInsn(176);
        }
        if (this.m_isThisAdvisable) {
            int delegationCaseIndex = caseLabels.length - 1;
            cv.visitLabel(caseLabels[delegationCaseIndex]);
            cv.visitVarInsn(25, 0);
            cv.visitInsn(3);
            cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
            cv.visitVarInsn(25, 0);
            cv.visitMethodInsn(182, this.m_joinPointClassName, "proceed", "()Ljava/lang/Object;");
            cv.visitLabel(returnLabels[delegationCaseIndex]);
            cv.visitInsn(176);
        }
        cv.visitLabel(defaultCaseLabel);
        AsmHelper.prepareWrappingOfPrimitiveType(cv, Type.getReturnType(this.m_calleeMemberDesc));
        this.createJoinPointInvocation(cv);
        Type m_returnType = null;
        m_returnType = this.m_joinPointType != 4 ? Type.getReturnType(this.m_calleeMemberDesc) : Type.getType(this.m_calleeClassSignature);
        AsmHelper.wrapPrimitiveType(cv, m_returnType);
        cv.visitVarInsn(58, 1);
        this.addReturnedValueToJoinPoint(cv, 1, 0, true);
        if (this.m_joinPointType == 4) {
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        }
        cv.visitLabel(gotoLabel);
        cv.visitVarInsn(25, 1);
        cv.visitInsn(176);
        cv.visitLabel(handlerLabel);
        cv.visitVarInsn(58, 2);
        cv.visitLabel(endLabel);
        cv.visitVarInsn(25, 2);
        cv.visitInsn(191);
        cv.visitTryCatchBlock(tryLabel, returnLabels[0], handlerLabel, null);
        for (int i2 = 1; i2 < caseLabels.length; ++i2) {
            Label caseLabel = caseLabels[i2];
            Label returnLabel = returnLabels[i2];
            cv.visitTryCatchBlock(caseLabel, returnLabel, handlerLabel, null);
        }
        cv.visitTryCatchBlock(defaultCaseLabel, gotoLabel, handlerLabel, null);
        cv.visitTryCatchBlock(handlerLabel, endLabel, handlerLabel, null);
        cv.visitMaxs(0, 0);
    }

    protected void createBeforeAdviceInvocations(CodeVisitor cv, boolean isOptimizedJoinPoint, int argStartIndex, int joinPointInstanceIndex, int callerIndex, int calleeIndex) {
        for (int i = 0; i < this.m_beforeAdviceMethodInfos.length; ++i) {
            AdviceMethodInfo adviceMethodInfo = this.m_beforeAdviceMethodInfos[i];
            Label endInstanceOflabel = this.beginRuntimeCheck(cv, isOptimizedJoinPoint, joinPointInstanceIndex, adviceMethodInfo.getAdviceInfo(), calleeIndex);
            this.loadAspect(cv, isOptimizedJoinPoint, joinPointInstanceIndex, adviceMethodInfo.getAspectInfo());
            AspectDefinition aspectDef = adviceMethodInfo.getAdviceInfo().getAdviceDefinition().getAspectDefinition();
            if (aspectDef.isAspectWerkzAspect()) {
                int[] argIndexes = adviceMethodInfo.getAdviceMethodArgIndexes();
                for (int j = 0; j < argIndexes.length; ++j) {
                    int argIndex = argIndexes[j];
                    if (argIndex >= 0) {
                        Type argumentType = this.m_argumentTypes[argIndex];
                        int argStackIndex = AsmHelper.getRegisterIndexOf(this.m_argumentTypes, argIndex) + argStartIndex;
                        AsmHelper.loadType(cv, argStackIndex, argumentType);
                        continue;
                    }
                    if (argIndex == -1 || argIndex == -2) {
                        this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointInstanceIndex);
                        continue;
                    }
                    if (argIndex == -3) {
                        this.loadCallee(cv, isOptimizedJoinPoint, joinPointInstanceIndex, calleeIndex);
                        if (!adviceMethodInfo.getAdviceInfo().hasTargetWithRuntimeCheck()) continue;
                        cv.visitTypeInsn(192, adviceMethodInfo.getAdviceInfo().getMethodParameterTypes()[j].getInternalName());
                        continue;
                    }
                    if (argIndex == -4) {
                        this.loadCaller(cv, isOptimizedJoinPoint, joinPointInstanceIndex, callerIndex);
                        continue;
                    }
                    throw new Error("special argument index is not supported: " + argIndex);
                }
            } else {
                adviceMethodInfo.setJoinPointIndex(joinPointInstanceIndex);
                for (int j = 0; j < this.m_aspectModels.length; ++j) {
                    AspectModel aspectModel = this.m_aspectModels[j];
                    if (!aspectDef.getAspectModel().equals(aspectModel.getAspectModelType())) continue;
                    aspectModel.createBeforeAdviceArgumentHandling(cv, adviceMethodInfo);
                }
            }
            cv.visitMethodInsn(182, adviceMethodInfo.getAspectInfo().getAspectClassName(), adviceMethodInfo.getAdviceInfo().getMethodName(), adviceMethodInfo.getAdviceInfo().getMethodSignature());
            this.endRuntimeCheck(cv, adviceMethodInfo.getAdviceInfo(), endInstanceOflabel);
        }
        if (this.m_isThisAdvisable) {
            this.createBeforeInterceptorInvocations(cv, joinPointInstanceIndex, callerIndex + 1);
        }
    }

    protected void createAfterFinallyAdviceInvocations(CodeVisitor cv, boolean isOptimizedJoinPoint, int argStartIndex, int joinPointInstanceIndex, int callerIndex, int calleeIndex) {
        for (int i = this.m_afterFinallyAdviceMethodInfos.length - 1; i >= 0; --i) {
            AdviceMethodInfo advice = this.m_afterFinallyAdviceMethodInfos[i];
            this.createAfterAdviceInvocation(cv, isOptimizedJoinPoint, advice, joinPointInstanceIndex, argStartIndex, callerIndex, calleeIndex, -1);
        }
    }

    protected void createAfterReturningAdviceInvocations(CodeVisitor cv, boolean isOptimizedJoinPoint, int argStartIndex, int joinPointInstanceIndex, int callerIndex, int calleeIndex) {
        int returnValueIndex;
        int n = returnValueIndex = joinPointInstanceIndex != -1 ? joinPointInstanceIndex + 1 : callerIndex + 1;
        if (this.m_isThisAdvisable) {
            this.createAfterReturningInterceptorInvocations(cv, joinPointInstanceIndex, returnValueIndex);
        }
        boolean hasPoppedReturnValueFromStack = false;
        for (int i = this.m_afterReturningAdviceMethodInfos.length - 1; i >= 0; --i) {
            AdviceMethodInfo advice = this.m_afterReturningAdviceMethodInfos[i];
            advice.setSpecialArgumentIndex(returnValueIndex);
            String specialArgDesc = advice.getSpecialArgumentTypeDesc();
            if (specialArgDesc == null) {
                this.createAfterAdviceInvocation(cv, isOptimizedJoinPoint, advice, joinPointInstanceIndex, argStartIndex, callerIndex, calleeIndex, -1);
                continue;
            }
            if (AsmHelper.isPrimitive(this.m_returnType)) {
                if (!this.m_returnType.getDescriptor().equals(specialArgDesc)) continue;
                this.createAfterAdviceInvocation(cv, isOptimizedJoinPoint, advice, joinPointInstanceIndex, argStartIndex, callerIndex, calleeIndex, returnValueIndex);
                continue;
            }
            cv.visitVarInsn(25, returnValueIndex);
            cv.visitTypeInsn(193, advice.getSpecialArgumentTypeName());
            Label label = new Label();
            cv.visitJumpInsn(153, label);
            this.createAfterAdviceInvocation(cv, isOptimizedJoinPoint, advice, joinPointInstanceIndex, argStartIndex, callerIndex, calleeIndex, returnValueIndex);
            cv.visitLabel(label);
        }
        if (!this.requiresProceedMethod() && hasPoppedReturnValueFromStack) {
            cv.visitVarInsn(25, returnValueIndex);
        }
    }

    protected void createAfterAdviceInvocation(CodeVisitor cv, boolean isOptimizedJoinPoint, AdviceMethodInfo adviceMethodInfo, int joinPointInstanceIndex, int argStartIndex, int callerIndex, int calleeIndex, int specialArgIndex) {
        Label endInstanceOflabel = this.beginRuntimeCheck(cv, isOptimizedJoinPoint, joinPointInstanceIndex, adviceMethodInfo.getAdviceInfo(), calleeIndex);
        this.loadAspect(cv, isOptimizedJoinPoint, joinPointInstanceIndex, adviceMethodInfo.getAspectInfo());
        AspectDefinition aspectDef = adviceMethodInfo.getAdviceInfo().getAdviceDefinition().getAspectDefinition();
        if (aspectDef.isAspectWerkzAspect()) {
            int[] argIndexes = adviceMethodInfo.getAdviceMethodArgIndexes();
            for (int j = 0; j < argIndexes.length; ++j) {
                Type argumentType;
                int argIndex = argIndexes[j];
                if (argIndex >= 0) {
                    argumentType = this.m_argumentTypes[argIndex];
                    int argStackIndex = AsmHelper.getRegisterIndexOf(this.m_argumentTypes, argIndex) + argStartIndex;
                    AsmHelper.loadType(cv, argStackIndex, argumentType);
                    continue;
                }
                if (argIndex == -1 || argIndex == -2) {
                    this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointInstanceIndex);
                    continue;
                }
                if (argIndex == -3) {
                    this.loadCallee(cv, isOptimizedJoinPoint, joinPointInstanceIndex, calleeIndex);
                    if (!adviceMethodInfo.getAdviceInfo().hasTargetWithRuntimeCheck()) continue;
                    cv.visitTypeInsn(192, adviceMethodInfo.getAdviceInfo().getMethodParameterTypes()[j].getInternalName());
                    continue;
                }
                if (argIndex == -4) {
                    this.loadCaller(cv, isOptimizedJoinPoint, joinPointInstanceIndex, callerIndex);
                    continue;
                }
                if (argIndex == -6 && specialArgIndex != -1) {
                    argumentType = adviceMethodInfo.getAdviceInfo().getMethodParameterTypes()[j];
                    AsmHelper.loadType(cv, specialArgIndex, argumentType);
                    if (!adviceMethodInfo.getAdviceInfo().getAdviceDefinition().getType().equals(AdviceType.AFTER_THROWING)) continue;
                    cv.visitTypeInsn(192, argumentType.getInternalName());
                    continue;
                }
                throw new Error("magic index is not supported: " + argIndex);
            }
        } else {
            adviceMethodInfo.setJoinPointIndex(joinPointInstanceIndex);
            for (int i = 0; i < this.m_aspectModels.length; ++i) {
                AspectModel aspectModel = this.m_aspectModels[i];
                if (!aspectDef.getAspectModel().equals(aspectModel.getAspectModelType())) continue;
                aspectModel.createAfterAdviceArgumentHandling(cv, adviceMethodInfo);
            }
        }
        cv.visitMethodInsn(182, adviceMethodInfo.getAspectInfo().getAspectClassName(), adviceMethodInfo.getAdviceInfo().getMethodName(), adviceMethodInfo.getAdviceInfo().getMethodSignature());
        this.endRuntimeCheck(cv, adviceMethodInfo.getAdviceInfo(), endInstanceOflabel);
    }

    protected void addReturnedValueToJoinPoint(CodeVisitor cv, int returnValueIndex, int joinPointInstanceIndex, boolean unwrap) {
        if (this.m_requiresJoinPoint && this.m_returnType.getSort() != 0 && (this.m_joinPointType == 1 || this.m_joinPointType == 2 || this.m_joinPointType == 4)) {
            this.loadJoinPointInstance(cv, false, joinPointInstanceIndex);
            if (unwrap && AsmHelper.isPrimitive(this.m_returnType)) {
                cv.visitVarInsn(25, returnValueIndex);
                AsmHelper.unwrapType(cv, this.m_returnType);
            } else {
                AsmHelper.loadType(cv, returnValueIndex, this.m_returnType);
            }
            cv.visitFieldInsn(181, this.m_joinPointClassName, "RETURN_VALUE", this.m_returnType.getDescriptor());
        }
    }

    protected void loadJoinPointInstance(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointInstanceIndex) {
        if (isOptimizedJoinPoint) {
            cv.visitFieldInsn(178, this.m_joinPointClassName, "OPTIMIZED_JOIN_POINT", "L" + this.m_joinPointClassName + ";");
        } else {
            cv.visitVarInsn(25, joinPointInstanceIndex);
        }
    }

    protected void loadArgumentMemberFields(CodeVisitor cv, int argStartIndex) {
        int argStackIndex = argStartIndex;
        for (int index = 0; index < this.m_argumentTypes.length; ++index) {
            Type argumentType = this.m_argumentTypes[index];
            argStackIndex = AsmHelper.loadType(cv, argStackIndex, argumentType);
        }
    }

    protected void loadArguments(CodeVisitor cv) {
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            String fieldName = this.m_fieldNames[i];
            Type argumentType = this.m_argumentTypes[i];
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, fieldName, argumentType.getDescriptor());
        }
    }

    protected void resetStackFrameCounter(CodeVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitInsn(2);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
    }

    protected void incrementStackFrameCounter(CodeVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitInsn(89);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
        cv.visitInsn(4);
        cv.visitInsn(96);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
    }

    protected final void createArgumentArrayAt(CodeVisitor cv, int stackFreeIndex) {
        AsmHelper.loadIntegerConstant(cv, this.m_fieldNames.length);
        cv.visitTypeInsn(189, "java/lang/Object");
        cv.visitVarInsn(58, stackFreeIndex);
        for (int i = 0; i < this.m_argumentTypes.length; ++i) {
            cv.visitVarInsn(25, stackFreeIndex);
            AsmHelper.loadIntegerConstant(cv, i);
            AsmHelper.prepareWrappingOfPrimitiveType(cv, this.m_argumentTypes[i]);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "ARGUMENT_" + i, this.m_argumentTypes[i].getDescriptor());
            AsmHelper.wrapPrimitiveType(cv, this.m_argumentTypes[i]);
            cv.visitInsn(83);
        }
    }

    protected void createUtilityMethods() {
        CodeVisitor cv = this.m_cw.visitMethod(1, "addMetaData", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "META_DATA", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(87);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getMetaData", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "META_DATA", "Ljava/util/Map;");
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCallee", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCaller", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getTarget", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getThis", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCallerClass", "()Ljava/lang/Class;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, THIS_CLASS_FIELD_NAME, "Ljava/lang/Class;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getCalleeClass", "()Ljava/lang/Class;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, TARGET_CLASS_FIELD_NAME, "Ljava/lang/Class;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getTargetClass", "()Ljava/lang/Class;", null, null);
        cv.visitFieldInsn(178, this.m_joinPointClassName, TARGET_CLASS_FIELD_NAME, "Ljava/lang/Class;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getType", "()Lorg/codehaus/aspectwerkz/joinpoint/management/JoinPointType;", null, null);
        AsmHelper.loadIntegerConstant(cv, this.m_joinPointType);
        cv.visitMethodInsn(184, Type.getType(class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType == null ? (class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType = AbstractJoinPointCompiler.class$("org.codehaus.aspectwerkz.joinpoint.management.JoinPointType")) : class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType).getInternalName(), "fromInt", "(I)" + Type.getType(class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType == null ? (class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType = AbstractJoinPointCompiler.class$("org.codehaus.aspectwerkz.joinpoint.management.JoinPointType")) : class$org$codehaus$aspectwerkz$joinpoint$management$JoinPointType).getDescriptor());
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
        cv = this.m_cw.visitMethod(1, "getEnclosingStaticJoinPoint", "()Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(178, this.m_joinPointClassName, "ENCLOSINGSJP", "Lorg/codehaus/aspectwerkz/joinpoint/EnclosingStaticJoinPoint;");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    protected void createCopyMethod() {
        CodeVisitor cv = this.m_cw.visitMethod(1, "copy", "()Lorg/codehaus/aspectwerkz/joinpoint/StaticJoinPoint;", null, null);
        cv.visitTypeInsn(187, this.m_joinPointClassName);
        cv.visitInsn(89);
        int joinPointCloneIndex = 1;
        cv.visitMethodInsn(183, this.m_joinPointClassName, "<init>", "()V");
        cv.visitVarInsn(58, joinPointCloneIndex);
        cv.visitVarInsn(25, joinPointCloneIndex);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "STACK_FRAME_COUNTER", "I");
        if (this.m_isThisAdvisable) {
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_BEFORE_INTERCEPTORS", "I");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_BEFORE_INTERCEPTORS", "I");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AROUND_INTERCEPTORS", "I");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AROUND_INTERCEPTORS", "I");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_INTERCEPTORS", "I");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_INTERCEPTORS", "I");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
            cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        }
        cv.visitVarInsn(25, joinPointCloneIndex);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        cv.visitVarInsn(25, joinPointCloneIndex);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            String fieldName = this.m_fieldNames[i];
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, fieldName, this.m_argumentTypes[i].getDescriptor());
            cv.visitFieldInsn(181, this.m_joinPointClassName, fieldName, this.m_argumentTypes[i].getDescriptor());
        }
        if (this.m_returnType.getSort() != 0) {
            cv.visitVarInsn(25, joinPointCloneIndex);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "RETURN_VALUE", this.m_returnType.getDescriptor());
            cv.visitFieldInsn(181, this.m_joinPointClassName, "RETURN_VALUE", this.m_returnType.getDescriptor());
        }
        cv.visitVarInsn(25, joinPointCloneIndex);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    protected String buildInvokeMethodSignature() {
        StringBuffer invokeDescBuf = new StringBuffer();
        invokeDescBuf.append('(');
        if (this.m_joinPointType != 4 && !Modifier.isStatic(this.m_calleeMemberModifiers)) {
            invokeDescBuf.append(this.m_calleeClassSignature);
        }
        for (int i = 0; i < this.m_argumentTypes.length; ++i) {
            Type type = this.m_argumentTypes[i];
            invokeDescBuf.append(type.getDescriptor());
        }
        invokeDescBuf.append(this.m_callerClassSignature);
        invokeDescBuf.append(')');
        invokeDescBuf.append(this.m_returnType.getDescriptor());
        return invokeDescBuf.toString();
    }

    protected final boolean hasArguments() {
        return this.m_argumentTypes.length > 0;
    }

    protected boolean requiresThisOrTarget() {
        return this.m_isThisAdvisable || this.requiresThisOrTarget(this.m_aroundAdviceMethodInfos) || this.requiresThisOrTarget(this.m_beforeAdviceMethodInfos) || this.requiresThisOrTarget(this.m_afterFinallyAdviceMethodInfos) || this.requiresThisOrTarget(this.m_afterReturningAdviceMethodInfos) || this.requiresThisOrTarget(this.m_afterThrowingAdviceMethodInfos);
    }

    protected boolean requiresJoinPoint() {
        return this.m_isThisAdvisable || this.requiresJoinPoint(this.m_aroundAdviceMethodInfos) || this.requiresJoinPoint(this.m_beforeAdviceMethodInfos) || this.requiresJoinPoint(this.m_afterFinallyAdviceMethodInfos) || this.requiresJoinPoint(this.m_afterReturningAdviceMethodInfos) || this.requiresJoinPoint(this.m_afterThrowingAdviceMethodInfos);
    }

    protected boolean requiresThisOrTarget(AdviceMethodInfo[] adviceMethodInfos) {
        for (int i = 0; i < adviceMethodInfos.length; ++i) {
            if (!adviceMethodInfos[i].requiresThisOrTarget()) continue;
            return true;
        }
        return false;
    }

    protected boolean requiresJoinPoint(AdviceMethodInfo[] adviceMethodInfos) {
        for (int i = 0; i < adviceMethodInfos.length; ++i) {
            if (!adviceMethodInfos[i].requiresJoinPoint()) continue;
            return true;
        }
        return false;
    }

    protected Label beginRuntimeCheck(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointInstanceIndex, AdviceInfo adviceInfo, int calleeIndex) {
        Label endRuntimeCheckLabel = null;
        if (adviceInfo.hasTargetWithRuntimeCheck() || adviceInfo.getAdviceDefinition().hasCflowOrCflowBelow()) {
            endRuntimeCheckLabel = new Label();
            RuntimeCheckVisitor runtimeCheckVisitor = new RuntimeCheckVisitor(this, cv, adviceInfo.getExpressionInfo(), isOptimizedJoinPoint, joinPointInstanceIndex, calleeIndex);
            runtimeCheckVisitor.pushCheckOnStack(adviceInfo.getExpressionContext());
            cv.visitJumpInsn(153, endRuntimeCheckLabel);
        }
        return endRuntimeCheckLabel;
    }

    protected void endRuntimeCheck(CodeVisitor cv, AdviceInfo adviceInfo, Label label) {
        if (adviceInfo.hasTargetWithRuntimeCheck() || adviceInfo.getAdviceDefinition().hasCflowOrCflowBelow()) {
            cv.visitLabel(label);
        }
    }

    public void loadCallee(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointIndex, int calleeIndex) {
        if (isOptimizedJoinPoint) {
            cv.visitVarInsn(25, calleeIndex);
        } else {
            this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointIndex);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLEE", this.m_calleeClassSignature);
        }
    }

    protected void loadCaller(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointIndex, int callerIndex) {
        if (isOptimizedJoinPoint) {
            cv.visitVarInsn(25, callerIndex);
        } else {
            this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointIndex);
            cv.visitFieldInsn(180, this.m_joinPointClassName, "CALLER", this.m_callerClassSignature);
        }
    }

    protected void loadAspect(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointIndex, AspectInfo aspectInfo) {
        DeploymentModel deploymentModel = aspectInfo.getDeploymentModel();
        if (deploymentModel.equals(DeploymentModel.PER_JVM) || deploymentModel.equals(DeploymentModel.PER_CLASS)) {
            cv.visitFieldInsn(178, this.m_joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        } else if (deploymentModel.equals(DeploymentModel.PER_INSTANCE)) {
            this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointIndex);
            cv.visitFieldInsn(180, this.m_joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        } else {
            throw new DefinitionException("deployment model [" + deploymentModel + "] is not supported");
        }
    }

    public void createInvocationToAspectOf(CodeVisitor cv, boolean isOptimizedJoinPoint, int joinPointIndex, int callerIndex, int calleeIndex, AspectInfo aspectInfo) {
        if (aspectInfo.getDeploymentModel() == DeploymentModel.PER_INSTANCE) {
            this.loadJoinPointInstance(cv, isOptimizedJoinPoint, joinPointIndex);
            cv.visitLdcInsn(aspectInfo.getAspectQualifiedName());
            if (calleeIndex >= 0) {
                cv.visitVarInsn(25, calleeIndex);
                cv.visitLdcInsn(aspectInfo.getAspectDefinition().getContainerClassName());
                cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Aspects", "aspect$Of", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
            } else {
                cv.visitFieldInsn(178, this.m_joinPointClassName, TARGET_CLASS_FIELD_NAME, "Ljava/lang/Class;");
                cv.visitLdcInsn(aspectInfo.getAspectDefinition().getContainerClassName());
                cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/aspect/management/Aspects", "aspect$Of", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;");
            }
            cv.visitTypeInsn(192, aspectInfo.getAspectClassName());
            cv.visitFieldInsn(181, this.m_joinPointClassName, aspectInfo.getAspectFieldName(), aspectInfo.getAspectClassSignature());
        }
    }

    private void createInitializationForAdvisableManagement(CodeVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitInsn(2);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        this.initializeAroundInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeBeforeInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeAfterInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeAfterReturningInterceptors(cv, joinPointInstanceIndex, advisableIndex);
        this.initializeAfterThrowingInterceptors(cv, joinPointInstanceIndex, advisableIndex);
    }

    private void initializeAroundInterceptors(CodeVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAroundAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AROUND_INTERCEPTORS", "I");
    }

    private void initializeBeforeInterceptors(CodeVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getBeforeAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_BEFORE_INTERCEPTORS", "I");
    }

    private void initializeAfterInterceptors(CodeVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAfterAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_INTERCEPTORS", "I");
    }

    private void initializeAfterReturningInterceptors(CodeVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAfterReturningAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I");
    }

    private void initializeAfterThrowingInterceptors(CodeVisitor cv, int joinPointInstanceIndex, int advisableIndex) {
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, advisableIndex);
        cv.visitTypeInsn(192, "org/codehaus/aspectwerkz/intercept/Advisable");
        cv.visitLdcInsn(new Integer(this.m_joinPointClassName.hashCode()));
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/Advisable", "aw$getAfterThrowingAdvice", "(I)[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitFieldInsn(181, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitInsn(190);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I");
    }

    private void createAroundInterceptorInvocations(CodeVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitInsn(2);
        Label ifStatementLabel = new Label();
        cv.visitJumpInsn(159, ifStatementLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AROUND_INTERCEPTORS", "I");
        cv.visitJumpInsn(162, ifStatementLabel);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AROUND_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AroundAdvice;");
        cv.visitVarInsn(25, 0);
        cv.visitInsn(89);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitInsn(90);
        cv.visitInsn(4);
        cv.visitInsn(96);
        cv.visitFieldInsn(181, this.m_joinPointClassName, "INTERCEPTOR_INDEX", "I");
        cv.visitInsn(50);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AroundAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;)Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitLabel(ifStatementLabel);
    }

    private void createBeforeInterceptorInvocations(CodeVisitor cv, int joinPointInstanceIndex, int registerDepth) {
        int loopIndex = registerDepth + 1;
        cv.visitInsn(3);
        cv.visitVarInsn(54, loopIndex);
        Label loopStartLabel = new Label();
        cv.visitLabel(loopStartLabel);
        cv.visitVarInsn(21, loopIndex);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_BEFORE_INTERCEPTORS", "I");
        Label loopCheckCondLabel = new Label();
        cv.visitJumpInsn(162, loopCheckCondLabel);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "BEFORE_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/BeforeAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/BeforeAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;)V");
        cv.visitIincInsn(loopIndex, 1);
        cv.visitJumpInsn(167, loopStartLabel);
        cv.visitLabel(loopCheckCondLabel);
    }

    private void createAfterInterceptorInvocations(CodeVisitor cv, int joinPointInstanceIndex, int registerDepth) {
        int loopIndex = registerDepth + 1;
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_INTERCEPTORS", "I");
        cv.visitInsn(4);
        cv.visitInsn(100);
        cv.visitVarInsn(54, loopIndex);
        Label loopLabel1 = new Label();
        cv.visitLabel(loopLabel1);
        cv.visitVarInsn(21, loopIndex);
        Label loopLabel2 = new Label();
        cv.visitJumpInsn(155, loopLabel2);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AfterAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;)V");
        cv.visitIincInsn(loopIndex, -1);
        cv.visitJumpInsn(167, loopLabel1);
        cv.visitLabel(loopLabel2);
    }

    private void createAfterReturningInterceptorInvocations(CodeVisitor cv, int joinPointInstanceIndex, int returnValueInstanceIndex) {
        int loopIndex = returnValueInstanceIndex + 1;
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_RETURNING_INTERCEPTORS", "I");
        cv.visitInsn(4);
        cv.visitInsn(100);
        cv.visitVarInsn(54, loopIndex);
        Label loopLabel1 = new Label();
        cv.visitLabel(loopLabel1);
        cv.visitVarInsn(21, loopIndex);
        Label loopLabel2 = new Label();
        cv.visitJumpInsn(155, loopLabel2);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_RETURNING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterReturningAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, returnValueInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AfterReturningAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;Ljava/lang/Object;)V");
        cv.visitIincInsn(loopIndex, -1);
        cv.visitJumpInsn(167, loopLabel1);
        cv.visitLabel(loopLabel2);
    }

    private void createAfterThrowingInterceptorInvocations(CodeVisitor cv, int joinPointInstanceIndex, int exceptionInstanceIndex) {
        int loopIndex = exceptionInstanceIndex + 1;
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "NR_OF_AFTER_THROWING_INTERCEPTORS", "I");
        cv.visitInsn(4);
        cv.visitInsn(100);
        cv.visitVarInsn(54, loopIndex);
        Label loopLabel1 = new Label();
        cv.visitLabel(loopLabel1);
        cv.visitVarInsn(21, loopIndex);
        Label loopLabel2 = new Label();
        cv.visitJumpInsn(155, loopLabel2);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitFieldInsn(180, this.m_joinPointClassName, "AFTER_THROWING_INTERCEPTORS", "[Lorg/codehaus/aspectwerkz/intercept/AfterThrowingAdvice;");
        cv.visitVarInsn(21, loopIndex);
        cv.visitInsn(50);
        cv.visitVarInsn(25, joinPointInstanceIndex);
        cv.visitVarInsn(25, exceptionInstanceIndex);
        cv.visitMethodInsn(185, "org/codehaus/aspectwerkz/intercept/AfterThrowingAdvice", "invoke", "(Lorg/codehaus/aspectwerkz/joinpoint/JoinPoint;Ljava/lang/Throwable;)V");
        cv.visitIincInsn(loopIndex, -1);
        cv.visitJumpInsn(167, loopLabel1);
        cv.visitLabel(loopLabel2);
    }

    protected boolean requiresProceedMethod() {
        return this.m_hasAroundAdvices || this.m_isThisAdvisable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomProceedMethodStruct {
        MethodInfo customProceed;
        int[] adviceToTargetArgs;

        public CustomProceedMethodStruct(MethodInfo customProceed, int[] adviceToTargetArgs) {
            this.customProceed = customProceed;
            this.adviceToTargetArgs = adviceToTargetArgs;
        }
    }
}

