/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.Iterator;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;

public class JoinPointInitVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private boolean m_hasClinitMethod = false;
    private boolean m_hasInitJoinPointsMethod = false;
    private boolean m_hasClassField = false;
    private boolean m_hasEmittedJoinPointsField = false;

    public JoinPointInitVisitor(ClassVisitor cv, Context ctx) {
        super(cv);
        this.m_ctx = (ContextImpl)ctx;
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if ("<clinit>".equals(name)) {
            this.m_hasClinitMethod = true;
            InsertBeforeClinitCodeAdapter ca = new InsertBeforeClinitCodeAdapter(this.cv.visitMethod(access, name, desc, exceptions, attrs));
            ca.visitMaxs(0, 0);
            return ca;
        }
        if ("aw$initJoinPoints".equals(name)) {
            this.m_hasInitJoinPointsMethod = true;
            InsertBeforeInitJoinPointsCodeAdapter ca = new InsertBeforeInitJoinPointsCodeAdapter(this.cv.visitMethod(access, name, desc, exceptions, attrs));
            ca.visitMaxs(0, 0);
            return ca;
        }
        return super.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        if ("aw$clazz".equals(name)) {
            this.m_hasClassField = true;
        } else if ("aw$emittedJoinPoints".equals(name)) {
            this.m_hasEmittedJoinPointsField = true;
        }
        super.visitField(access, name, desc, value, attrs);
    }

    public void visitEnd() {
        if (!this.m_ctx.isAdvised()) {
            super.visitEnd();
            return;
        }
        if (!this.m_hasClassField) {
            this.cv.visitField(4122, "aw$clazz", "Ljava/lang/Class;", null, null);
        }
        if (!this.m_hasEmittedJoinPointsField && this.m_ctx.isMadeAdvisable()) {
            this.cv.visitField(4122, "aw$emittedJoinPoints", "Lgnu/trove/TIntObjectHashMap;", null, null);
        }
        if (!this.m_hasClinitMethod) {
            InsertBeforeClinitCodeAdapter ca = new InsertBeforeClinitCodeAdapter(this.cv.visitMethod(8, "<clinit>", "()V", null, null));
            ca.visitInsn(177);
            ca.visitMaxs(0, 0);
        }
        if (!this.m_hasInitJoinPointsMethod) {
            InsertBeforeInitJoinPointsCodeAdapter mv = new InsertBeforeInitJoinPointsCodeAdapter(this.cv.visitMethod(4122, "aw$initJoinPoints", "()V", null, null));
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
        this.cv.visitEnd();
    }

    public class InsertBeforeInitJoinPointsCodeAdapter
    extends CodeAdapter {
        public InsertBeforeInitJoinPointsCodeAdapter(CodeVisitor ca) {
            super(ca);
            Iterator iterator = JoinPointInitVisitor.this.m_ctx.getEmittedJoinPoints().iterator();
            while (iterator.hasNext()) {
                EmittedJoinPoint jp = (EmittedJoinPoint)iterator.next();
                this.cv.visitLdcInsn(new Integer(jp.getJoinPointType()));
                this.cv.visitFieldInsn(178, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$clazz", "Ljava/lang/Class;");
                this.cv.visitLdcInsn(jp.getCallerMethodName());
                this.cv.visitLdcInsn(jp.getCallerMethodDesc());
                this.cv.visitLdcInsn(new Integer(jp.getCallerMethodModifiers()));
                this.cv.visitLdcInsn(jp.getCalleeClassName());
                this.cv.visitLdcInsn(jp.getCalleeMemberName());
                this.cv.visitLdcInsn(jp.getCalleeMemberDesc());
                this.cv.visitLdcInsn(new Integer(jp.getCalleeMemberModifiers()));
                this.cv.visitLdcInsn(new Integer(jp.getJoinPointHash()));
                this.cv.visitLdcInsn(jp.getJoinPointClassName());
                this.cv.visitMethodInsn(184, "org/codehaus/aspectwerkz/joinpoint/management/JoinPointManager", "loadJoinPoint", "(ILjava/lang/Class;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;)V");
                if (!JoinPointInitVisitor.this.m_ctx.isMadeAdvisable()) continue;
                this.cv.visitFieldInsn(178, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$emittedJoinPoints", "Lgnu/trove/TIntObjectHashMap;");
                this.cv.visitLdcInsn(new Integer(jp.getJoinPointClassName().hashCode()));
                this.cv.visitTypeInsn(187, "org/codehaus/aspectwerkz/transform/inlining/EmittedJoinPoint");
                this.cv.visitInsn(89);
                this.cv.visitLdcInsn(new Integer(jp.getJoinPointType()));
                this.cv.visitLdcInsn(JoinPointInitVisitor.this.m_ctx.getClassName());
                this.cv.visitLdcInsn(jp.getCallerMethodName());
                this.cv.visitLdcInsn(jp.getCallerMethodDesc());
                this.cv.visitLdcInsn(new Integer(jp.getCallerMethodModifiers()));
                this.cv.visitLdcInsn(jp.getCalleeClassName());
                this.cv.visitLdcInsn(jp.getCalleeMemberName());
                this.cv.visitLdcInsn(jp.getCalleeMemberDesc());
                this.cv.visitLdcInsn(new Integer(jp.getCalleeMemberModifiers()));
                this.cv.visitLdcInsn(new Integer(jp.getJoinPointHash()));
                this.cv.visitLdcInsn(jp.getJoinPointClassName());
                this.cv.visitMethodInsn(183, "org/codehaus/aspectwerkz/transform/inlining/EmittedJoinPoint", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;)V");
                this.cv.visitMethodInsn(182, "gnu/trove/TIntObjectHashMap", "put", "(ILjava/lang/Object;)Ljava/lang/Object;");
            }
        }
    }

    public class InsertBeforeClinitCodeAdapter
    extends CodeAdapter {
        public InsertBeforeClinitCodeAdapter(CodeVisitor ca) {
            super(ca);
            if (!JoinPointInitVisitor.this.m_hasClassField) {
                this.cv.visitLdcInsn(JoinPointInitVisitor.this.m_ctx.getClassName().replace('/', '.'));
                this.cv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                this.cv.visitFieldInsn(179, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$clazz", "Ljava/lang/Class;");
            }
            if (!JoinPointInitVisitor.this.m_hasEmittedJoinPointsField && JoinPointInitVisitor.this.m_ctx.isMadeAdvisable()) {
                this.cv.visitTypeInsn(187, "gnu/trove/TIntObjectHashMap");
                this.cv.visitInsn(89);
                this.cv.visitMethodInsn(183, "gnu/trove/TIntObjectHashMap", "<init>", "()V");
                this.cv.visitFieldInsn(179, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$emittedJoinPoints", "Lgnu/trove/TIntObjectHashMap;");
            }
            if (!JoinPointInitVisitor.this.m_hasClassField) {
                this.cv.visitMethodInsn(184, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$initJoinPoints", "()V");
            }
        }
    }
}

