/*
 * Decompiled with CFR 0.152.
 */
package examples.logging;

import org.codehaus.aspectwerkz.CrossCuttingInfo;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.CustomAttribute;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MemberSignature;

public abstract class AbstractLoggingAspect {
    private int m_level = 0;
    private CrossCuttingInfo m_info;

    public AbstractLoggingAspect(CrossCuttingInfo info) {
        this.m_info = info;
    }

    @CustomAttribute(value="rO0ABXNyADJvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5Bbm5vdGF0aW9uSW5m\nb/N4IWD/KezhAgACTAAMbV9hbm5vdGF0aW9udAAwTG9yZy9jb2RlaGF1cy9hc3BlY3R3ZXJrei9h\nbm5vdGF0aW9uL0Fubm90YXRpb247TAAGbV9uYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7eHBzcgA5\nb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQXJvdW5kQW5ub3RhdGlvblByb3h5\nSfEF/M3ZYVwCAAB4cgA9b3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQWR2aWNl\nQW5ub3RhdGlvblByb3h5QmFzZRgSgW+aLDl6AgADTAAQbV9hcmdzVHlwZUJ5TmFtZXQAD0xqYXZh\nL3V0aWwvTWFwO0wACm1fcG9pbnRjdXRxAH4AAkwABm1fdHlwZXQALExvcmcvY29kZWhhdXMvYXNw\nZWN0d2Vya3ovYXNwZWN0L0FkdmljZVR5cGU7eHIAOm9yZy5jb2RlaGF1cy5hc3BlY3R3ZXJrei5h\nbm5vdGF0aW9uLlVudHlwZWRBbm5vdGF0aW9uUHJveHnGu77b8UeFlQIAAkwABm1fbmFtZXEAfgAC\nTAAHbV92YWx1ZXEAfgACeHB0AAZBcm91bmR0AABzcgAub3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6\nLnV0aWwuU2VxdWVuY2VkSGFzaE1hcC7qIpOpIiYSDAAAeHB3BAAAAAF0AAlqb2luUG9pbnR0ACxv\ncmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouam9pbnBvaW50LkpvaW5Qb2ludHh0AAxtZXRob2RzVG9M\nb2dzcgAqb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFzcGVjdC5BZHZpY2VUeXBlH2EhAnJ89D4C\nAAFMAAZtX25hbWVxAH4AAnhwdAAGQVJPVU5EcQB+AAo=")
    public Object logMethod(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        this.indent();
        System.out.println("--> " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
        ++this.m_level;
        Object result = joinPoint.proceed();
        --this.m_level;
        this.indent();
        System.out.println("<-- " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
        return result;
    }

    @CustomAttribute(value="rO0ABXNyADJvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5Bbm5vdGF0aW9uSW5m\nb/N4IWD/KezhAgACTAAMbV9hbm5vdGF0aW9udAAwTG9yZy9jb2RlaGF1cy9hc3BlY3R3ZXJrei9h\nbm5vdGF0aW9uL0Fubm90YXRpb247TAAGbV9uYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7eHBzcgA5\nb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQmVmb3JlQW5ub3RhdGlvblByb3h5\nG3Gn0drtAW0CAAB4cgA9b3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQWR2aWNl\nQW5ub3RhdGlvblByb3h5QmFzZRgSgW+aLDl6AgADTAAQbV9hcmdzVHlwZUJ5TmFtZXQAD0xqYXZh\nL3V0aWwvTWFwO0wACm1fcG9pbnRjdXRxAH4AAkwABm1fdHlwZXQALExvcmcvY29kZWhhdXMvYXNw\nZWN0d2Vya3ovYXNwZWN0L0FkdmljZVR5cGU7eHIAOm9yZy5jb2RlaGF1cy5hc3BlY3R3ZXJrei5h\nbm5vdGF0aW9uLlVudHlwZWRBbm5vdGF0aW9uUHJveHnGu77b8UeFlQIAAkwABm1fbmFtZXEAfgAC\nTAAHbV92YWx1ZXEAfgACeHB0AAZCZWZvcmV0AABzcgAub3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6\nLnV0aWwuU2VxdWVuY2VkSGFzaE1hcC7qIpOpIiYSDAAAeHB3BAAAAAF0AAlqb2luUG9pbnR0ACxv\ncmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouam9pbnBvaW50LkpvaW5Qb2ludHh0AAxtZXRob2RzVG9M\nb2dzcgAqb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFzcGVjdC5BZHZpY2VUeXBlH2EhAnJ89D4C\nAAFMAAZtX25hbWVxAH4AAnhwdAAGQkVGT1JFcQB+AAo=")
    public void logBefore(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("BEFORE: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    @CustomAttribute(value="rO0ABXNyADJvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5Bbm5vdGF0aW9uSW5m\nb/N4IWD/KezhAgACTAAMbV9hbm5vdGF0aW9udAAwTG9yZy9jb2RlaGF1cy9hc3BlY3R3ZXJrei9h\nbm5vdGF0aW9uL0Fubm90YXRpb247TAAGbV9uYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7eHBzcgA4\nb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQWZ0ZXJBbm5vdGF0aW9uUHJveHkp\naAd17uyeNQIAAUwAFW1fc3BlY2lhbEFyZ3VtZW50VHlwZXEAfgACeHIAPW9yZy5jb2RlaGF1cy5h\nc3BlY3R3ZXJrei5hbm5vdGF0aW9uLkFkdmljZUFubm90YXRpb25Qcm94eUJhc2UYEoFvmiw5egIA\nA0wAEG1fYXJnc1R5cGVCeU5hbWV0AA9MamF2YS91dGlsL01hcDtMAAptX3BvaW50Y3V0cQB+AAJM\nAAZtX3R5cGV0ACxMb3JnL2NvZGVoYXVzL2FzcGVjdHdlcmt6L2FzcGVjdC9BZHZpY2VUeXBlO3hy\nADpvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5VbnR5cGVkQW5ub3RhdGlvblBy\nb3h5xru+2/FHhZUCAAJMAAZtX25hbWVxAH4AAkwAB21fdmFsdWVxAH4AAnhwdAAFQWZ0ZXJ0AABz\ncgAub3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LnV0aWwuU2VxdWVuY2VkSGFzaE1hcC7qIpOpIiYS\nDAAAeHB3BAAAAAF0AAlqb2luUG9pbnR0ACxvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouam9pbnBv\naW50LkpvaW5Qb2ludHh0AAxtZXRob2RzVG9Mb2dzcgAqb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6\nLmFzcGVjdC5BZHZpY2VUeXBlH2EhAnJ89D4CAAFMAAZtX25hbWVxAH4AAnhwdAAPQUZURVJfUkVU\nVVJOSU5HdAAQamF2YS5sYW5nLlN0cmluZ3EAfgAK")
    public void logAfterReturning(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("AFTER RETURNING: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    @CustomAttribute(value="rO0ABXNyADJvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5Bbm5vdGF0aW9uSW5m\nb/N4IWD/KezhAgACTAAMbV9hbm5vdGF0aW9udAAwTG9yZy9jb2RlaGF1cy9hc3BlY3R3ZXJrei9h\nbm5vdGF0aW9uL0Fubm90YXRpb247TAAGbV9uYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7eHBzcgA4\nb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQWZ0ZXJBbm5vdGF0aW9uUHJveHkp\naAd17uyeNQIAAUwAFW1fc3BlY2lhbEFyZ3VtZW50VHlwZXEAfgACeHIAPW9yZy5jb2RlaGF1cy5h\nc3BlY3R3ZXJrei5hbm5vdGF0aW9uLkFkdmljZUFubm90YXRpb25Qcm94eUJhc2UYEoFvmiw5egIA\nA0wAEG1fYXJnc1R5cGVCeU5hbWV0AA9MamF2YS91dGlsL01hcDtMAAptX3BvaW50Y3V0cQB+AAJM\nAAZtX3R5cGV0ACxMb3JnL2NvZGVoYXVzL2FzcGVjdHdlcmt6L2FzcGVjdC9BZHZpY2VUeXBlO3hy\nADpvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5VbnR5cGVkQW5ub3RhdGlvblBy\nb3h5xru+2/FHhZUCAAJMAAZtX25hbWVxAH4AAkwAB21fdmFsdWVxAH4AAnhwdAAFQWZ0ZXJ0AABz\ncgAub3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LnV0aWwuU2VxdWVuY2VkSGFzaE1hcC7qIpOpIiYS\nDAAAeHB3BAAAAAF0AAlqb2luUG9pbnR0ACxvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouam9pbnBv\naW50LkpvaW5Qb2ludHh0AAxtZXRob2RzVG9Mb2dzcgAqb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6\nLmFzcGVjdC5BZHZpY2VUeXBlH2EhAnJ89D4CAAFMAAZtX25hbWVxAH4AAnhwdAAOQUZURVJfVEhS\nT1dJTkd0ABpqYXZhLmxhbmcuUnVudGltZUV4Y2VwdGlvbnEAfgAK")
    public void logAfterThrowing(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("AFTER THROWING: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    @CustomAttribute(value="rO0ABXNyADJvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5Bbm5vdGF0aW9uSW5m\nb/N4IWD/KezhAgACTAAMbV9hbm5vdGF0aW9udAAwTG9yZy9jb2RlaGF1cy9hc3BlY3R3ZXJrei9h\nbm5vdGF0aW9uL0Fubm90YXRpb247TAAGbV9uYW1ldAASTGphdmEvbGFuZy9TdHJpbmc7eHBzcgA4\nb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LmFubm90YXRpb24uQWZ0ZXJBbm5vdGF0aW9uUHJveHkp\naAd17uyeNQIAAUwAFW1fc3BlY2lhbEFyZ3VtZW50VHlwZXEAfgACeHIAPW9yZy5jb2RlaGF1cy5h\nc3BlY3R3ZXJrei5hbm5vdGF0aW9uLkFkdmljZUFubm90YXRpb25Qcm94eUJhc2UYEoFvmiw5egIA\nA0wAEG1fYXJnc1R5cGVCeU5hbWV0AA9MamF2YS91dGlsL01hcDtMAAptX3BvaW50Y3V0cQB+AAJM\nAAZtX3R5cGV0ACxMb3JnL2NvZGVoYXVzL2FzcGVjdHdlcmt6L2FzcGVjdC9BZHZpY2VUeXBlO3hy\nADpvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouYW5ub3RhdGlvbi5VbnR5cGVkQW5ub3RhdGlvblBy\nb3h5xru+2/FHhZUCAAJMAAZtX25hbWVxAH4AAkwAB21fdmFsdWVxAH4AAnhwdAAFQWZ0ZXJ0AABz\ncgAub3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6LnV0aWwuU2VxdWVuY2VkSGFzaE1hcC7qIpOpIiYS\nDAAAeHB3BAAAAAF0AAlqb2luUG9pbnR0ACxvcmcuY29kZWhhdXMuYXNwZWN0d2Vya3ouam9pbnBv\naW50LkpvaW5Qb2ludHh0AAxtZXRob2RzVG9Mb2dzcgAqb3JnLmNvZGVoYXVzLmFzcGVjdHdlcmt6\nLmFzcGVjdC5BZHZpY2VUeXBlH2EhAnJ89D4CAAFMAAZtX25hbWVxAH4AAnhwdAANQUZURVJfRklO\nQUxMWXBxAH4ACg==")
    public void logAfterFinally(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("AFTER FINALLY: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    private void indent() {
        for (int i = 0; i < this.m_level; ++i) {
            System.out.print("  ");
        }
    }
}

