/*
 * Decompiled with CFR 0.152.
 */
package examples.logging;

import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.definition.StartupManager;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MemberSignature;

public class JavaLoggingAspect {
    private int m_level = 0;
    static /* synthetic */ Class class$examples$logging$HotSwapTarget;

    public Object logMethod(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        this.indent();
        System.out.println(joinPoint.getType() + "--> " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
        ++this.m_level;
        Object result = joinPoint.proceed();
        --this.m_level;
        this.indent();
        System.out.println(joinPoint.getType() + "<-- " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
        return result;
    }

    public void logEntry(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("ENTER: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    public void logExit(JoinPoint joinPoint) throws Throwable {
        MemberSignature signature = (MemberSignature)joinPoint.getSignature();
        System.out.println("EXIT: " + joinPoint.getTargetClass().getName() + "::" + signature.getName());
    }

    private void indent() {
        for (int i = 0; i < this.m_level; ++i) {
            System.out.print("  ");
        }
    }

    public static void addPointcutForLoggingAdvice(String pointcut, String pointcutName) {
        String aspectName = "examples.logging.JavaLoggingAspect";
        SystemDefinition sysDef = DefinitionLoader.getDefinition((ClassLoader)(class$examples$logging$HotSwapTarget == null ? (class$examples$logging$HotSwapTarget = JavaLoggingAspect.class$("examples.logging.HotSwapTarget")) : class$examples$logging$HotSwapTarget).getClassLoader(), (String)"hotdeployed");
        AspectDefinition aspectDef = sysDef.getAspectDefinition("examples.logging.JavaLoggingAspect");
        ExpressionNamespace namespace = ExpressionNamespace.getNamespace((String)aspectDef.getFullQualifiedName());
        ExpressionInfo expressionInfo = new ExpressionInfo(pointcut, aspectDef.getFullQualifiedName());
        namespace.addExpressionInfo(pointcutName, expressionInfo);
        AdviceDefinition newDef = null;
        Iterator arounds = aspectDef.getAroundAdvices().iterator();
        while (arounds.hasNext()) {
            AdviceDefinition around = (AdviceDefinition)arounds.next();
            if (!around.getName().equals("examples.logging.JavaLoggingAspect.logMethod")) continue;
            newDef = around.copyAt(expressionInfo);
            break;
        }
        aspectDef.addAroundAdvice(newDef);
        StartupManager.reinitializeSystem((ClassLoader)(class$examples$logging$HotSwapTarget == null ? (class$examples$logging$HotSwapTarget = JavaLoggingAspect.class$("examples.logging.HotSwapTarget")) : class$examples$logging$HotSwapTarget).getClassLoader(), (SystemDefinition)sysDef);
        System.out.println("sysDef = " + sysDef.getClass().getClassLoader());
    }

    public static void removePointcutForLoggingAdvice(String pointcut, String pointcutName) {
        String aspectName = "examples.logging.JavaLoggingAspect";
        SystemDefinition sysDef = DefinitionLoader.getDefinition((ClassLoader)(class$examples$logging$HotSwapTarget == null ? (class$examples$logging$HotSwapTarget = JavaLoggingAspect.class$("examples.logging.HotSwapTarget")) : class$examples$logging$HotSwapTarget).getClassLoader(), (String)"hotdeployed");
        AspectDefinition aspectDef = sysDef.getAspectDefinition("examples.logging.JavaLoggingAspect");
        ArrayList<AdviceDefinition> removedAdviceDefs = new ArrayList<AdviceDefinition>();
        Iterator arounds = aspectDef.getAroundAdvices().iterator();
        while (arounds.hasNext()) {
            AdviceDefinition around = (AdviceDefinition)arounds.next();
            if (!pointcutName.equals(around.getExpressionInfo().getExpressionAsString())) continue;
            System.out.println("<removing> " + around.getName() + " at " + pointcutName);
            removedAdviceDefs.add(around);
        }
        arounds = removedAdviceDefs.iterator();
        while (arounds.hasNext()) {
            aspectDef.removeAroundAdvice((AdviceDefinition)arounds.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

