/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.io.Serializable;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.logging.data.CategoriesDirective;

public abstract class DeploymentProfile
implements Serializable {
    public static final int DEFAULT = -1;
    public static final int ENABLED = 1;
    public static final int DISABLED = 0;
    private static final CategoriesDirective EMPTY_CATEGORIES = new CategoriesDirective();
    private String m_name;
    private final int m_activation;
    private final Mode m_mode;
    private final CategoriesDirective m_categories;

    public DeploymentProfile(String name, int activation, Mode mode, CategoriesDirective categories) {
        this.m_activation = activation;
        this.m_categories = categories;
        this.m_mode = mode == null ? Mode.IMPLICIT : mode;
        this.m_name = name == null ? "untitled" : name;
    }

    public String getName() {
        return this.m_name;
    }

    public CategoriesDirective getCategories() {
        if (this.m_categories == null) {
            return EMPTY_CATEGORIES;
        }
        return this.m_categories;
    }

    public int getActivationDirective() {
        return this.m_activation;
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

