/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.builder;

import java.util.ArrayList;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ConstructorDirective;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.EntryDirective;
import org.apache.avalon.composition.data.ImportDirective;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.Parameter;
import org.apache.avalon.composition.data.SelectionDirective;
import org.apache.avalon.composition.data.StageDirective;
import org.apache.avalon.composition.data.builder.XMLProfileCreator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;

public class XMLDeploymentProfileCreator
extends XMLProfileCreator {
    public DeploymentProfile createDeploymentProfile(Configuration config) throws Exception {
        String classname = config.getAttribute("class", null);
        return this.createDeploymentProfile(null, classname, config);
    }

    public DeploymentProfile createDeploymentProfile(String base, String classname, Configuration config) throws Exception {
        String name = this.getName(base, config, "untitled");
        return this.createDeploymentProfile(classname, config, name);
    }

    public DeploymentProfile createDeploymentProfile(String classname, Configuration config, String name) throws Exception {
        boolean activation = this.getActivationPolicy(config, true);
        CategoriesDirective categories = this.getCategoriesDirective(config.getChild("categories", false), name);
        ContextDirective context = this.getContextDirective(config.getChild("context", false));
        DependencyDirective[] dependencies = this.getDependencyDirectives(config.getChild("dependencies"));
        StageDirective[] stages = this.getStageDirectives(config.getChild("stages"));
        Parameters params = this.getParameters(config.getChild("parameters", false));
        Configuration configuration = config.getChild("configuration", true);
        return new DeploymentProfile(name, activation, classname, categories, context, dependencies, stages, params, configuration, Mode.EXPLICIT);
    }

    protected DependencyDirective[] getDependencyDirectives(Configuration config) throws ConfigurationException {
        if (config != null) {
            ArrayList<DependencyDirective> list = new ArrayList<DependencyDirective>();
            Configuration[] deps = config.getChildren("dependency");
            for (int i = 0; i < deps.length; ++i) {
                list.add(this.getDependencyDirective(deps[i]));
            }
            return list.toArray(new DependencyDirective[0]);
        }
        return new DependencyDirective[0];
    }

    protected DependencyDirective getDependencyDirective(Configuration config) throws ConfigurationException {
        String key = config.getAttribute("key");
        String source = config.getAttribute("source", null);
        if (source != null) {
            return new DependencyDirective(key, source);
        }
        Configuration[] children = config.getChildren("select");
        ArrayList<SelectionDirective> list = new ArrayList<SelectionDirective>();
        for (int i = 0; i < children.length; ++i) {
            list.add(this.getSelectionDirective(children[i]));
        }
        SelectionDirective[] features = list.toArray(new SelectionDirective[0]);
        return new DependencyDirective(key, features);
    }

    protected StageDirective[] getStageDirectives(Configuration config) throws ConfigurationException {
        if (config != null) {
            ArrayList<StageDirective> list = new ArrayList<StageDirective>();
            Configuration[] deps = config.getChildren("stage");
            for (int i = 0; i < deps.length; ++i) {
                list.add(this.getStageDirective(deps[i]));
            }
            return list.toArray(new StageDirective[0]);
        }
        return new StageDirective[0];
    }

    protected StageDirective getStageDirective(Configuration config) throws ConfigurationException {
        String key = config.getAttribute("key");
        String source = config.getAttribute("source", null);
        if (source != null) {
            return new StageDirective(key, source);
        }
        Configuration[] children = config.getChildren("select");
        ArrayList<SelectionDirective> list = new ArrayList<SelectionDirective>();
        for (int i = 0; i < children.length; ++i) {
            list.add(this.getSelectionDirective(children[i]));
        }
        SelectionDirective[] features = list.toArray(new SelectionDirective[0]);
        return new StageDirective(key, features);
    }

    protected SelectionDirective getSelectionDirective(Configuration config) throws ConfigurationException {
        String feature = config.getAttribute("feature");
        String value = config.getAttribute("value");
        String match = config.getAttribute("match", "required");
        boolean optional = config.getAttributeAsBoolean("optional", false);
        return new SelectionDirective(feature, value, match, optional);
    }

    protected Parameters getParameters(Configuration config) throws ConfigurationException {
        if (config != null) {
            return Parameters.fromConfiguration((Configuration)config);
        }
        return null;
    }

    public ContextDirective getContextDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        if (config.getChildren("import").length > 0) {
            String error = "The 'context' tag format has changed. Please check Merlin home for details http://avalon.apache.org/sandbox/merlin/resources";
            throw new ConfigurationException("The 'context' tag format has changed. Please check Merlin home for details http://avalon.apache.org/sandbox/merlin/resources");
        }
        String classname = config.getAttribute("class", null);
        String source = config.getAttribute("source", null);
        EntryDirective[] entries = this.getEntries(config.getChildren("entry"));
        return new ContextDirective(classname, entries, source);
    }

    protected EntryDirective[] getEntries(Configuration[] configs) throws ConfigurationException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < configs.length; ++i) {
            Configuration conf = configs[i];
            String key = conf.getAttribute("key");
            Configuration[] children = conf.getChildren();
            if (children.length != 1) {
                String error = "Entry '" + key + "' does not contain one child element.";
                throw new ConfigurationException(error);
            }
            Configuration child = children[0];
            String name = child.getName();
            if (name.equals("import")) {
                String importKey = child.getAttribute("key");
                list.add(new ImportDirective(key, importKey));
                continue;
            }
            if (name.equals("constructor")) {
                String classname = child.getAttribute("class", "java.lang.String");
                Configuration[] paramsConf = child.getChildren("param");
                if (paramsConf.length > 0) {
                    Parameter[] params = this.getParameters(paramsConf);
                    ConstructorDirective constructor = new ConstructorDirective(key, classname, params);
                    list.add(constructor);
                    continue;
                }
                ConstructorDirective constructor = new ConstructorDirective(key, classname, child.getValue(null));
                list.add(constructor);
                continue;
            }
            String error = "Entry child unrecognized: " + name;
            throw new ConfigurationException(error);
        }
        return list.toArray(new EntryDirective[0]);
    }

    protected Parameter[] getParameters(Configuration[] configs) throws ConfigurationException {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (int i = 0; i < configs.length; ++i) {
            Parameter parameter = this.getParameter(configs[i]);
            list.add(parameter);
        }
        return list.toArray(new Parameter[0]);
    }

    protected Parameter getParameter(Configuration config) throws ConfigurationException {
        String classname = config.getAttribute("class", "java.lang.String");
        Configuration[] params = config.getChildren("param");
        if (params.length == 0) {
            String value = config.getValue(null);
            return new Parameter(classname, value);
        }
        Parameter[] parameters = this.getParameters(params);
        return new Parameter(classname, parameters);
    }
}

