/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.model.Model;
import org.apache.avalon.composition.model.ModelSelector;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

class DefaultModelSelector
implements ModelSelector {
    DefaultModelSelector() {
    }

    public Model select(Model[] models, DependencyDescriptor dependency) {
        Model[] candidates = this.filterCandidateProviders(models, dependency);
        return this.select(candidates);
    }

    public Model select(Model[] models, StageDescriptor stage) {
        Model[] candidates = this.filterCandidateProviders(models, stage);
        return this.select(candidates);
    }

    private Model[] filterCandidateProviders(Model[] models, DependencyDescriptor dependency) {
        ArrayList<Model> list = new ArrayList<Model>();
        for (int i = 0; i < models.length; ++i) {
            Model model = models[i];
            if (!model.isaCandidate(dependency)) continue;
            list.add(model);
        }
        return list.toArray(new Model[0]);
    }

    private Model[] filterCandidateProviders(Model[] models, StageDescriptor stage) {
        ArrayList<Model> list = new ArrayList<Model>();
        for (int i = 0; i < models.length; ++i) {
            Model model = models[i];
            if (!model.isaCandidate(stage)) continue;
            list.add(model);
        }
        return list.toArray(new Model[0]);
    }

    private Model select(Model[] models) {
        int i;
        if (models.length == 0) {
            return null;
        }
        for (i = 0; i < models.length; ++i) {
            if (!models[i].getMode().equals((Object)Mode.EXPLICIT)) continue;
            return models[i];
        }
        for (i = 0; i < models.length; ++i) {
            if (!models[i].getMode().equals((Object)Mode.PACKAGED)) continue;
            return models[i];
        }
        for (i = 0; i < models.length; ++i) {
            if (!models[i].getMode().equals((Object)Mode.IMPLICIT)) continue;
            return models[i];
        }
        return null;
    }
}

