/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.Profile;
import org.apache.avalon.composition.data.ProfilePackage;
import org.apache.avalon.composition.data.builder.ProfilePackageBuilder;
import org.apache.avalon.composition.model.TypeRepository;
import org.apache.avalon.composition.model.TypeUnknownException;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;

class DefaultTypeRepository
implements TypeRepository {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel = DefaultTypeRepository.class$("org.apache.avalon.composition.model.impl.DefaultClassLoaderModel")) : class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel));
    private static final ProfilePackageBuilder PACKAGE_BUILDER = new ProfilePackageBuilder();
    private final Logger m_logger;
    private final ClassLoader m_classloader;
    private final TypeRepository m_parent;
    private final Hashtable m_types = new Hashtable();
    private final Hashtable m_profiles = new Hashtable();
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultClassLoaderModel;

    public DefaultTypeRepository(Logger logger, ClassLoader classloader, List types) throws Exception {
        this(logger, classloader, null, types);
    }

    public DefaultTypeRepository(Logger logger, ClassLoader classloader, TypeRepository parent, List types) throws Exception {
        if (types == null) {
            throw new NullPointerException("types");
        }
        this.m_parent = parent;
        this.m_classloader = classloader;
        this.m_logger = logger;
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("type.repository.count", (Object)new Integer(types.size()));
            this.getLogger().debug(message);
        }
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            String name = type.getInfo().getName();
            String classname = type.getInfo().getClassname();
            Class<?> clazz = this.m_classloader.loadClass(classname);
            ProfilePackage pack = PACKAGE_BUILDER.createProfilePackage(name, clazz);
            this.m_profiles.put(classname, pack);
            int n = pack.getDeploymentProfiles().length;
            this.m_types.put(classname, type);
            if (!this.getLogger().isDebugEnabled()) continue;
            String message = REZ.getString("type.repository.addition", (Object)classname, (Object)new Integer(n).toString());
            this.getLogger().debug(message);
        }
    }

    public Type[] getTypes() {
        return this.getTypes(true);
    }

    public Type[] getTypes(boolean policy) {
        if (policy && this.m_parent != null) {
            ArrayList list = new ArrayList(this.m_types.values());
            Type[] types = this.m_parent.getTypes();
            for (int i = 0; i < types.length; ++i) {
                list.add(types[i]);
            }
            return list.toArray(new Type[0]);
        }
        return this.m_types.values().toArray(new Type[0]);
    }

    public Type getType(Class clazz) throws TypeUnknownException {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return this.getType(clazz.getName());
    }

    public Type getType(String classname) throws TypeUnknownException {
        Type type;
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        if (this.m_parent != null) {
            try {
                return this.m_parent.getType(classname);
            }
            catch (TypeUnknownException tue) {
                // empty catch block
            }
        }
        if ((type = (Type)this.m_types.get(classname)) == null) {
            String error = REZ.getString("type.repository.unknown-type", (Object)classname);
            throw new TypeUnknownException(error);
        }
        return type;
    }

    public Type[] getTypes(DependencyDescriptor dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        ArrayList<Type> list = new ArrayList<Type>();
        ReferenceDescriptor reference = dependency.getReference();
        Type[] types = this.getTypes(false);
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (type.getService(reference) == null) continue;
            list.add(type);
        }
        return list.toArray(new Type[0]);
    }

    public Type[] getTypes(StageDescriptor stage) {
        if (stage == null) {
            throw new NullPointerException("stage");
        }
        ArrayList<Type> list = new ArrayList<Type>();
        Type[] types = this.getTypes(false);
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (type.getExtension(stage) == null) continue;
            list.add(type);
        }
        return list.toArray(new Type[0]);
    }

    public DeploymentProfile[] getProfiles(Type type) throws TypeUnknownException {
        String classname = type.getInfo().getClassname();
        ProfilePackage profiles = (ProfilePackage)this.m_profiles.get(classname);
        if (profiles != null) {
            return profiles.getDeploymentProfiles();
        }
        if (this.m_parent != null) {
            return this.m_parent.getProfiles(type);
        }
        String error = REZ.getString("type.repository.unknown-type", (Object)classname);
        throw new TypeUnknownException(error);
    }

    private Profile[] getProfiles() {
        return this.m_profiles.values().toArray(new Profile[0]);
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

