/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.avalon.composition.model.ServiceRepository;
import org.apache.avalon.composition.model.ServiceUnknownException;
import org.apache.avalon.framework.Version;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.Service;

public class DefaultServiceRepository
implements ServiceRepository {
    private final Logger m_logger;
    private final ServiceRepository m_parent;
    private final List m_services;

    DefaultServiceRepository(Logger logger, List services) throws NullPointerException {
        this(logger, null, services);
    }

    DefaultServiceRepository(Logger logger, ServiceRepository parent, List services) throws NullPointerException {
        if (services == null) {
            throw new NullPointerException("services");
        }
        this.m_parent = parent;
        this.m_services = services;
        this.m_logger = logger;
    }

    public Service getService(String classname, Version version) throws ServiceUnknownException {
        return this.getService(new ReferenceDescriptor(classname, version));
    }

    public Service getService(ReferenceDescriptor reference) throws ServiceUnknownException {
        Service service = this.getLocalService(reference);
        if (service == null) {
            if (this.m_parent != null) {
                return this.m_parent.getService(reference);
            }
            String error = "Unknown service defintion: " + reference;
            throw new ServiceUnknownException(error);
        }
        return service;
    }

    private Service getLocalService(ReferenceDescriptor reference) {
        Iterator iterator = this.m_services.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (!service.equals((Object)reference)) continue;
            return service;
        }
        return null;
    }

    protected Logger getLogger() {
        return this.m_logger;
    }
}

