/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.net.URL;
import org.apache.avalon.composition.data.CategoryDirective;
import org.apache.avalon.composition.logging.LoggingDescriptor;
import org.apache.avalon.composition.logging.LoggingManager;
import org.apache.avalon.composition.logging.TargetDescriptor;
import org.apache.avalon.composition.logging.impl.DefaultLoggingManager;
import org.apache.avalon.composition.model.ModelFactory;
import org.apache.avalon.composition.model.SystemContext;
import org.apache.avalon.composition.model.impl.DefaultModelFactory;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.impl.DefaultFileRepository;

public class DefaultSystemContext
extends DefaultContext
implements SystemContext {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultSystemContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultSystemContext = DefaultSystemContext.class$("org.apache.avalon.composition.model.impl.DefaultSystemContext")) : class$org$apache$avalon$composition$model$impl$DefaultSystemContext));
    private final File m_base;
    private final File m_home;
    private final File m_temp;
    private final Repository m_repository;
    private final ClassLoader m_system;
    private final ClassLoader m_common;
    private final LoggingManager m_logging;
    private final Logger m_logger;
    private ModelFactory m_factory;
    private boolean m_trace;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultSystemContext;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$SystemContext;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;

    public static SystemContext createSystemContext(File base, File root, int priority) throws Exception {
        LoggingManager logging = DefaultSystemContext.createLoggingManager(base, priority);
        Logger logger = logging.getLoggerForCategory("");
        Repository repository = DefaultSystemContext.createRepository(root);
        File working = new File(System.getProperty("user.dir"), "working");
        File home = new File(working, "home");
        File temp = new File(working, "temp");
        return new DefaultSystemContext(logging, base, home, temp, repository, "system", false);
    }

    private static Repository createRepository(File root) throws Exception {
        URL ibiblio = new URL("http://www.ibiblio.org/maven");
        return new DefaultFileRepository(root, new URL[]{ibiblio});
    }

    private static LoggingManager createLoggingManager(File base, int priority) throws Exception {
        String level = DefaultSystemContext.getStringPriority(priority);
        LoggingDescriptor logging = new LoggingDescriptor("", level, null, new CategoryDirective[0], new TargetDescriptor[0]);
        DefaultLoggingManager manager = new DefaultLoggingManager(base, logging);
        return manager;
    }

    private static String getStringPriority(int priority) {
        if (priority == 5) {
            return "NONE";
        }
        if (priority == 0) {
            return "DEBUG";
        }
        if (priority == 1) {
            return "INFO";
        }
        if (priority == 2) {
            return "WARN";
        }
        if (priority == 3) {
            return "ERROR";
        }
        if (priority == 4) {
            return "FATAL";
        }
        String error = "Unrecognized logging priority: " + priority;
        throw new IllegalArgumentException(error);
    }

    public DefaultSystemContext(LoggingManager logging, File base, File home, File temp, Repository repository, String category, boolean trace) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        if (logging == null) {
            throw new NullPointerException("logger");
        }
        if (!base.isDirectory()) {
            String error = REZ.getString("system.context.base.not-a-directory.error", (Object)base);
            throw new IllegalArgumentException(error);
        }
        this.m_base = base;
        this.m_home = home;
        this.m_temp = temp;
        this.m_trace = trace;
        this.m_repository = repository;
        this.m_logging = logging;
        this.m_logger = this.m_logging.getLoggerForCategory(category);
        this.m_system = (class$org$apache$avalon$composition$model$SystemContext == null ? (class$org$apache$avalon$composition$model$SystemContext = DefaultSystemContext.class$("org.apache.avalon.composition.model.SystemContext")) : class$org$apache$avalon$composition$model$SystemContext).getClassLoader();
        this.m_common = (class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = DefaultSystemContext.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger).getClassLoader();
        this.m_factory = new DefaultModelFactory(this);
    }

    public ModelFactory getFactory() {
        return this.m_factory;
    }

    public File getBaseDirectory() {
        return this.m_base;
    }

    public File getHomeDirectory() {
        return this.m_home;
    }

    public File getTempDirectory() {
        return this.m_temp;
    }

    public Repository getRepository() {
        return this.m_repository;
    }

    public ClassLoader getCommonClassLoader() {
        return this.m_common;
    }

    public ClassLoader getSystemClassLoader() {
        return this.m_system;
    }

    public boolean isTraceEnabled() {
        return this.m_trace;
    }

    public void setTraceEnabled(boolean trace) {
        this.m_trace = trace;
    }

    public LoggingManager getLoggingManager() {
        return this.m_logging;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

