/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.avalon.composition.data.BlockCompositionDirective;
import org.apache.avalon.composition.data.BlockIncludeDirective;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.NamedDeploymentProfile;
import org.apache.avalon.composition.data.Profile;
import org.apache.avalon.composition.data.ResourceDirective;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.composition.data.TargetDirective;
import org.apache.avalon.composition.data.builder.ContainmentProfileBuilder;
import org.apache.avalon.composition.data.builder.XMLContainmentProfileCreator;
import org.apache.avalon.composition.data.builder.XMLTargetsCreator;
import org.apache.avalon.composition.event.CompositionEvent;
import org.apache.avalon.composition.event.CompositionEventListener;
import org.apache.avalon.composition.logging.LoggingManager;
import org.apache.avalon.composition.model.ClassLoaderContext;
import org.apache.avalon.composition.model.ClassLoaderModel;
import org.apache.avalon.composition.model.ContainmentContext;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.Model;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.model.TypeRepository;
import org.apache.avalon.composition.model.impl.DefaultClassLoaderModel;
import org.apache.avalon.composition.model.impl.DefaultContainmentContext;
import org.apache.avalon.composition.model.impl.DefaultDeploymentContext;
import org.apache.avalon.composition.model.impl.DefaultDeploymentModel;
import org.apache.avalon.composition.model.impl.DefaultModel;
import org.apache.avalon.composition.model.impl.DefaultModelSelector;
import org.apache.avalon.composition.model.impl.DefaultProfileSelector;
import org.apache.avalon.composition.util.StringHelper;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.util.exception.ExceptionHelper;

public class DefaultContainmentModel
extends DefaultModel
implements ContainmentModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContainmentModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultContainmentModel = DefaultContainmentModel.class$("org.apache.avalon.composition.model.impl.DefaultContainmentModel")) : class$org$apache$avalon$composition$model$impl$DefaultContainmentModel));
    private static final ContainmentProfileBuilder BUILDER = new ContainmentProfileBuilder();
    private static final XMLContainmentProfileCreator CREATOR = new XMLContainmentProfileCreator();
    private static final XMLTargetsCreator TARGETS = new XMLTargetsCreator();
    private ContainmentContext m_context;
    private String m_partition;
    private final Map m_models = new Hashtable();
    private CategoriesDirective m_categories;
    private final LinkedList m_compositionListeners = new LinkedList();
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContainmentModel;

    private static String getPath(ContainmentContext context) {
        if (context.getPartitionName() == null) {
            return "/";
        }
        return context.getPartitionName();
    }

    public DefaultContainmentModel(ContainmentContext context) throws ModelException {
        super(context.getLogger(), DefaultContainmentModel.getPath(context), context.getName(), context.getContainmentProfile().getMode());
        this.m_context = context;
        this.m_partition = context.getPartitionName() == null ? "/" : this.getPath() + this.getName() + "/";
        Profile[] profiles = context.getContainmentProfile().getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            this.addModel(profiles[i]);
        }
    }

    public ClassLoaderModel getClassLoaderModel() {
        return this.m_context.getClassLoaderModel();
    }

    public ServiceDescriptor[] getServices() {
        return this.getExportDirectives();
    }

    public boolean isaCandidate(DependencyDescriptor dependency) {
        ServiceDescriptor[] services = this.getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (!service.getReference().matches(dependency.getReference())) continue;
            return true;
        }
        return false;
    }

    public boolean isaCandidate(StageDescriptor stage) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompositionListener(CompositionEventListener listener) {
        LinkedList linkedList = this.m_compositionListeners;
        synchronized (linkedList) {
            this.m_compositionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompositionListener(CompositionEventListener listener) {
        LinkedList linkedList = this.m_compositionListeners;
        synchronized (linkedList) {
            this.m_compositionListeners.remove(listener);
        }
    }

    public CategoriesDirective getCategories() {
        if (this.m_categories == null) {
            return this.m_context.getContainmentProfile().getCategories();
        }
        return this.m_categories;
    }

    public void setCategories(CategoriesDirective categories) {
        this.m_categories = categories;
    }

    public Model addModel(URL url) throws ModelException {
        return this.addContainmentModel(url, null);
    }

    public ContainmentModel addContainmentModel(URL block, URL config) throws ModelException {
        ContainmentModel model = this.createContainmentModel(null, block);
        this.addModel(model.getName(), (Model)model);
        this.applyTargets(config);
        return model;
    }

    public Model addModel(Profile profile) throws ModelException {
        if (null == profile) {
            throw new NullPointerException("profile");
        }
        ContainmentModel model = null;
        String name = profile.getName();
        if (profile instanceof ContainmentProfile) {
            ContainmentProfile containment = (ContainmentProfile)profile;
            model = this.createContainmentModel(containment);
        } else if (profile instanceof DeploymentProfile) {
            DeploymentProfile deployment = (DeploymentProfile)profile;
            model = this.createDeploymentModel(deployment);
        } else if (profile instanceof NamedDeploymentProfile) {
            DeploymentProfile deployment = this.createDeploymentProfile((NamedDeploymentProfile)profile);
            model = this.createDeploymentModel(deployment);
        } else if (profile instanceof BlockIncludeDirective) {
            BlockIncludeDirective directive = (BlockIncludeDirective)profile;
            model = this.createContainmentModel(directive);
        } else if (profile instanceof BlockCompositionDirective) {
            BlockCompositionDirective directive = (BlockCompositionDirective)profile;
            model = this.createContainmentModel(directive);
        } else {
            String error = REZ.getString("containment.unknown-profile-class.error", (Object)this.getPath(), (Object)profile.getClass().getName());
            throw new ModelException(error);
        }
        return this.addModel(name, (Model)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model addModel(String name, Model model) throws ModelException {
        Map map = this.m_models;
        synchronized (map) {
            this.m_models.put(name, model);
            CompositionEvent event = new CompositionEvent((ContainmentModel)this, model);
            this.fireModelAddedEvent(event);
            return model;
        }
    }

    private void fireModelAddedEvent(CompositionEvent event) {
        Iterator iterator = this.m_compositionListeners.iterator();
        while (iterator.hasNext()) {
            CompositionEventListener listener = (CompositionEventListener)iterator.next();
            try {
                listener.modelAdded(event);
            }
            catch (Throwable e) {
                String message = "A composition listener raised an exception";
                String error = ExceptionHelper.packException((String)"A composition listener raised an exception", (Throwable)e, (boolean)true);
                this.getLogger().warn(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModel(String name) throws IllegalArgumentException {
        Map map = this.m_models;
        synchronized (map) {
            Model model = (Model)this.m_models.get(name);
            if (null == name) {
                String error = "No model named [" + name + "] is referenced with the model [" + this + "].";
                throw new IllegalArgumentException(error);
            }
            this.m_models.remove(name);
            CompositionEvent event = new CompositionEvent((ContainmentModel)this, model);
            this.fireModelRemovedEvent(event);
        }
    }

    private void fireModelRemovedEvent(CompositionEvent event) {
        Iterator iterator = this.m_compositionListeners.iterator();
        while (iterator.hasNext()) {
            CompositionEventListener listener = (CompositionEventListener)iterator.next();
            try {
                listener.modelRemoved(event);
            }
            catch (Throwable e) {
                String message = "A composition listener raised an exception";
                String error = ExceptionHelper.packException((String)"A composition listener raised an exception", (Throwable)e, (boolean)true);
                this.getLogger().warn(error);
            }
        }
    }

    private DeploymentModel createDeploymentModel(DeploymentProfile profile) throws ModelException {
        if (null == profile) {
            throw new NullPointerException("profile");
        }
        String name = profile.getName();
        String partition = this.getPartition();
        Logger logger = this.getLogger().getChildLogger(name);
        if (this.getLogger().isDebugEnabled()) {
            String message = StringHelper.toString(REZ.getString("containment.add", (Object)name));
            this.getLogger().debug(message);
        }
        try {
            ClassLoader classLoader = this.m_context.getClassLoader();
            Class<?> base = classLoader.loadClass(profile.getClassname());
            Type type = this.m_context.getClassLoaderModel().getTypeRepository().getType(base);
            File home = new File(this.m_context.getHomeDirectory(), name);
            File temp = new File(this.m_context.getTempDirectory(), name);
            DefaultDeploymentContext context = new DefaultDeploymentContext(logger, name, this.m_context, profile, type, base, home, temp, partition);
            return new DefaultDeploymentModel(context);
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.deployment.create.error", (Object)this.getPath(), (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    private ContainmentModel createContainmentModel(ContainmentProfile profile) throws ModelException {
        String name = profile.getName();
        return this.createContainmentModel(name, profile);
    }

    private ContainmentModel createContainmentModel(String name, ContainmentProfile profile) throws ModelException {
        return this.createContainmentModel(name, profile, new URL[0]);
    }

    private ContainmentModel createContainmentModel(String name, ContainmentProfile profile, URL[] implicit) throws ModelException {
        String partition = this.getPartition();
        if (this.getLogger().isDebugEnabled()) {
            String message = StringHelper.toString(REZ.getString("containment.add", (Object)name));
            this.getLogger().debug(message);
        }
        LoggingManager logging = this.m_context.getSystemContext().getLoggingManager();
        String base = partition + name;
        logging.addCategories(base, profile.getCategories());
        Logger log = logging.getLoggerForCategory(base);
        try {
            ClassLoaderContext cntx = this.m_context.getClassLoaderModel().createChildContext(log, profile, implicit);
            ClassLoaderModel classLoaderModel = DefaultClassLoaderModel.createClassLoaderModel(cntx);
            File home = new File(this.m_context.getHomeDirectory(), name);
            File temp = new File(this.m_context.getTempDirectory(), name);
            Logger logger = this.getLogger().getChildLogger(name);
            DefaultContainmentContext context = new DefaultContainmentContext(logger, this.m_context.getSystemContext(), classLoaderModel, home, temp, profile, partition, name);
            return new DefaultContainmentModel(context);
        }
        catch (ModelException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.container.create.error", (Object)this.getPath(), (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    private ContainmentModel createContainmentModel(BlockCompositionDirective directive) throws ModelException {
        String name = directive.getName();
        ResourceDirective resource = directive.getResource();
        String id = resource.getId();
        String group = resource.getGroup();
        String resourceName = resource.getName();
        String version = resource.getVersion();
        String type = resource.getType();
        ContainmentModel model = null;
        try {
            Repository repository = this.m_context.getSystemContext().getRepository();
            Artifact artifact = Artifact.createArtifact((String)group, (String)resourceName, (String)version, (String)type);
            URL url = repository.getResource(artifact);
            model = this.createContainmentModel(name, url);
        }
        catch (RepositoryException e) {
            String error = "Unable to include block [" + name + "] into the containmment model [" + this.getQualifiedName() + "] because of a repository related error.";
            throw new ModelException(error, (Throwable)e);
        }
        TargetDirective[] targets = directive.getTargetDirectives();
        for (int i = 0; i < targets.length; ++i) {
            TargetDirective target = targets[i];
            Model child = model.getModel(target.getPath());
            if (child != null) {
                if (target.getConfiguration() != null) {
                    if (child instanceof DeploymentModel) {
                        ((DeploymentModel)child).setConfiguration(target.getConfiguration());
                    } else if (child instanceof ContainmentModel) {
                        String warn = "Ignoring target configuration as the path [" + target.getPath() + "] does not refer to a deployment model";
                    }
                }
                if (target.getCategoriesDirective() == null) continue;
                if (child instanceof DeploymentModel) {
                    ((DeploymentModel)child).setCategories(target.getCategoriesDirective());
                    continue;
                }
                if (!(child instanceof ContainmentModel)) continue;
                ((ContainmentModel)child).setCategories(target.getCategoriesDirective());
                continue;
            }
            String warning = "Unrecognized target path: " + target.getPath();
            this.getLogger().warn(warning);
        }
        return model;
    }

    private ContainmentModel createContainmentModel(BlockIncludeDirective directive) throws ModelException {
        String name = directive.getName();
        String path = directive.getPath();
        try {
            if (path.indexOf(":") < 0) {
                URL anchor = this.m_context.getSystemContext().getBaseDirectory().toURL();
                URL url = new URL(anchor, path);
                return this.createContainmentModel(name, url);
            }
            URL url = new URL(path);
            return this.createContainmentModel(name, url);
        }
        catch (MalformedURLException e) {
            String error = "Unable to include block [" + name + "] into the containmment model [" + this.getQualifiedName() + "] because of a url related error.";
            throw new ModelException(error, (Throwable)e);
        }
    }

    private ContainmentModel createContainmentModel(String name, URL url) throws ModelException {
        String path = url.toString();
        try {
            if (path.endsWith(".jar")) {
                URL jarURL = this.convertToJarURL(url);
                URL blockURL = new URL(jarURL, "/BLOCK-INF/block.xml");
                InputStream stream = blockURL.openStream();
                try {
                    ContainmentProfile profile = BUILDER.createContainmentProfile(stream);
                    String message = "including composite block: " + blockURL.toString();
                    this.getLogger().debug(message);
                    return this.createContainmentModel(this.getName(name, (Profile)profile), profile, new URL[]{url});
                }
                catch (Throwable e) {
                    String error = "Unable to create block from embedded descriptor [" + blockURL.toString() + "] in the containmment model [" + this.getQualifiedName() + "] due to a build related error.";
                    throw new ModelException(error, e);
                }
            }
            if (path.endsWith(".xml") || path.endsWith(".block")) {
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration config = builder.build(path);
                ContainmentProfile profile = CREATOR.createContainmentProfile(config);
                String message = "including composite block: " + path;
                this.getLogger().debug(message);
                return this.createContainmentModel(this.getName(name, (Profile)profile), profile);
            }
            if (path.endsWith("/")) {
                this.verifyPath(path);
                URL blockURL = new URL(url.toString() + "BLOCK-INF/block.xml");
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration config = builder.build(blockURL.toString());
                ContainmentProfile profile = CREATOR.createContainmentProfile(config);
                String message = "including composite block: " + blockURL.toString();
                this.getLogger().debug(message);
                return this.createContainmentModel(this.getName(name, (Profile)profile), profile, new URL[]{url});
            }
            if (path.endsWith(".bar")) {
                String error = "Cannot execute a block archive: " + path;
                throw new ModelException(error);
            }
            this.verifyPath(path);
            return this.createContainmentModel(name, new URL(path + "/"));
        }
        catch (ModelException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            String error = "Unable to include block [" + path + "] into the containmment model [" + this.getQualifiedName() + "] because of a url related error.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (IOException e) {
            String error = "Unable to include block [" + path + "] into the containmment model [" + this.getQualifiedName() + "] because of a io related error.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = "Unable to include block [" + path + "] into the containmment model [" + this.getQualifiedName() + "] because of an unexpected error.";
            throw new ModelException(error, e);
        }
    }

    private void verifyPath(String path) throws ModelException {
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            connection.connect();
        }
        catch (FileNotFoundException e) {
            String error = "File not found: " + path;
            throw new ModelException(error);
        }
        catch (Throwable e) {
            String error = "Invalid path: " + path;
            throw new ModelException(error, e);
        }
    }

    private String getName(String name, Profile profile) {
        if (name != null) {
            return name;
        }
        return profile.getName();
    }

    public String getPartition() {
        return this.m_partition;
    }

    public Model[] getModels() {
        return this.m_models.values().toArray(new Model[0]);
    }

    public Model getModel(String path) {
        if (path.startsWith("/")) {
            return this.getModel(path.substring(1, path.length()));
        }
        int j = path.indexOf("/");
        if (j > -1) {
            String key = path.substring(0, j);
            if (key.equals("")) {
                return this;
            }
            String remainder = path.substring(j + 1);
            Model model = this.getModel(key);
            if (model == null) {
                return null;
            }
            if (model instanceof ContainmentModel) {
                return ((ContainmentModel)model).getModel(remainder);
            }
            String error = "Bad path element: " + key + " in path: " + path;
            throw new IllegalArgumentException(error);
        }
        if (path.equals("")) {
            return this;
        }
        return (Model)this.m_models.get(path);
    }

    public Model getModel(DependencyDescriptor dependency) throws ModelRuntimeException {
        DefaultModelSelector modelSelector = new DefaultModelSelector();
        Model[] models = this.getModels();
        Model model = modelSelector.select(models, dependency);
        if (model != null) {
            return model;
        }
        TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
        ArrayList<DeploymentProfile> list = new ArrayList<DeploymentProfile>();
        try {
            Type[] types = repository.getTypes(dependency);
            for (int i = 0; i < types.length; ++i) {
                DeploymentProfile[] profiles = repository.getProfiles(types[i]);
                for (int j = 0; j < profiles.length; ++j) {
                    list.add(profiles[j]);
                }
            }
            DefaultProfileSelector selector = new DefaultProfileSelector();
            Profile[] collection = list.toArray(new Profile[0]);
            Profile profile = selector.select(collection, dependency);
            if (profile != null) {
                return this.addModel(profile);
            }
            return null;
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.model.create.error", (Object)this.getPath(), (Object)dependency.toString());
            throw new ModelRuntimeException(error, e);
        }
    }

    public Model getModel(StageDescriptor stage) throws ModelRuntimeException {
        DefaultModelSelector modelSelector = new DefaultModelSelector();
        Model[] models = this.getModels();
        Model model = modelSelector.select(models, stage);
        if (model != null) {
            return model;
        }
        TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
        ArrayList<DeploymentProfile> list = new ArrayList<DeploymentProfile>();
        try {
            Type[] types = repository.getTypes(stage);
            for (int i = 0; i < types.length; ++i) {
                DeploymentProfile[] profiles = repository.getProfiles(types[i]);
                for (int j = 0; j < profiles.length; ++j) {
                    list.add(profiles[j]);
                }
            }
            DefaultProfileSelector selector = new DefaultProfileSelector();
            Profile[] collection = list.toArray(new Profile[0]);
            Profile profile = selector.select(collection, stage);
            if (profile != null) {
                return this.addModel(profile);
            }
            return null;
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.model.create.error", (Object)this.getPath(), (Object)stage.toString());
            throw new ModelRuntimeException(error, e);
        }
    }

    public ServiceDirective[] getExportDirectives() {
        return this.m_context.getContainmentProfile().getExportDirectives();
    }

    public ServiceDirective getExportDirective(Class clazz) {
        return this.m_context.getContainmentProfile().getExportDirective(clazz);
    }

    private URL convertToJarURL(URL url) throws MalformedURLException {
        if (url.getProtocol().equals("jar")) {
            return url;
        }
        return new URL("jar:" + url.toString() + "!/");
    }

    public String toString() {
        return "[containment model: " + this.getQualifiedName() + "]";
    }

    private DeploymentProfile createDeploymentProfile(NamedDeploymentProfile profile) throws ModelException {
        try {
            NamedDeploymentProfile holder = profile;
            String classname = holder.getClassname();
            String key = holder.getKey();
            TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
            Type type = repository.getType(classname);
            DeploymentProfile template = repository.getProfile(type, key);
            return new DeploymentProfile(profile.getName(), template);
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.model.create.deployment.error", (Object)profile.getKey(), (Object)this.getPath(), (Object)profile.getClassname());
            throw new ModelException(error, e);
        }
    }

    public void applyTargets(URL config) throws ModelException {
        if (config != null) {
            TargetDirective[] targets = this.getTargets(config);
            this.applyTargets(targets);
        }
    }

    public void applyTargets(TargetDirective[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            TargetDirective target = targets[i];
            String path = target.getPath();
            Model model = this.getModel(path);
            if (model != null) {
                if (model instanceof DeploymentModel) {
                    DeploymentModel deployment = (DeploymentModel)model;
                    if (target.getConfiguration() != null) {
                        deployment.setConfiguration(target.getConfiguration());
                    }
                    if (target.getCategoriesDirective() == null) continue;
                    deployment.setCategories(target.getCategoriesDirective());
                    continue;
                }
                if (!(model instanceof ContainmentModel)) continue;
                ContainmentModel containment = (ContainmentModel)model;
                if (target.getCategoriesDirective() == null) continue;
                containment.setCategories(target.getCategoriesDirective());
                continue;
            }
            String warning = "Ignoring target directive as the path does not refer to a known component: " + path;
            this.getLogger().warn(warning);
        }
    }

    private TargetDirective[] getTargets(URL url) throws ModelException {
        try {
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            Configuration config = builder.build(url.toString());
            return TARGETS.createTargets(config).getTargets();
        }
        catch (Throwable e) {
            String error = "Could not load the targets directive: " + url;
            throw new ModelException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

