/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.builder.ContainmentProfileBuilder;
import org.apache.avalon.composition.data.builder.XMLContainmentProfileCreator;
import org.apache.avalon.composition.model.ContainmentContext;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentContext;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelFactory;
import org.apache.avalon.composition.model.SystemContext;
import org.apache.avalon.composition.model.impl.DefaultClassLoaderContext;
import org.apache.avalon.composition.model.impl.DefaultClassLoaderModel;
import org.apache.avalon.composition.model.impl.DefaultContainmentContext;
import org.apache.avalon.composition.model.impl.DefaultContainmentModel;
import org.apache.avalon.composition.model.impl.DefaultDeploymentModel;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.repository.Repository;

public class DefaultModelFactory
extends AbstractLogEnabled
implements ModelFactory {
    private static final XMLContainmentProfileCreator CREATOR = new XMLContainmentProfileCreator();
    private static final ContainmentProfileBuilder BUILDER = new ContainmentProfileBuilder();
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultModelFactory == null ? (class$org$apache$avalon$composition$model$impl$DefaultModelFactory = DefaultModelFactory.class$("org.apache.avalon.composition.model.impl.DefaultModelFactory")) : class$org$apache$avalon$composition$model$impl$DefaultModelFactory));
    final SystemContext m_system;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultModelFactory;

    public DefaultModelFactory(SystemContext system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.m_system = system;
        this.enableLogging(system.getLogger());
    }

    public ContainmentModel createContainmentModel(URL url) throws ModelException {
        if (url.toString().endsWith(".xml")) {
            try {
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration config = builder.build(url.toString());
                ContainmentProfile profile = CREATOR.createContainmentProfile(config);
                return this.createContainmentModel(profile);
            }
            catch (ModelException e) {
                throw e;
            }
            catch (Throwable e) {
                String error = "Could not create model due to a build related error.";
                throw new ModelException("Could not create model due to a build related error.", e);
            }
        }
        try {
            URLConnection connection = url.openConnection();
            InputStream stream = connection.getInputStream();
            ContainmentProfile profile = BUILDER.createContainmentProfile(stream);
            return this.createContainmentModel(profile);
        }
        catch (Throwable e) {
            String error = REZ.getString("factory.containment.create-url.error", (Object)url.toString());
            throw new ModelException(error, e);
        }
    }

    public ContainmentModel createContainmentModel(ContainmentProfile profile) throws ModelException {
        try {
            ContainmentContext context = this.createContainmentContext(profile);
            return this.createContainmentModel(context);
        }
        catch (Throwable e) {
            String error = REZ.getString("factory.containment.create.error", (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    public ContainmentContext createContainmentContext(ContainmentProfile profile) throws ModelException {
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        this.m_system.getLoggingManager().addCategories(profile.getCategories());
        Logger logger = this.m_system.getLoggingManager().getLoggerForCategory("");
        try {
            Repository repository = this.m_system.getRepository();
            File base = this.m_system.getBaseDirectory();
            ClassLoader root = this.m_system.getCommonClassLoader();
            ClassLoaderDirective classLoaderDirective = profile.getClassLoaderDirective();
            DefaultClassLoaderContext classLoaderContext = new DefaultClassLoaderContext(logger, repository, base, root, classLoaderDirective);
            DefaultClassLoaderModel classLoaderModel = new DefaultClassLoaderModel(classLoaderContext);
            return new DefaultContainmentContext(logger, this.m_system, classLoaderModel, profile);
        }
        catch (Throwable e) {
            String error = REZ.getString("factory.containment.create.error", (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    public ContainmentModel createContainmentModel(ContainmentContext context) throws ModelException {
        return new DefaultContainmentModel(context);
    }

    public DeploymentModel createDeploymentModel(DeploymentContext context) throws ModelException {
        return new DefaultDeploymentModel(context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

