/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.logging.impl;

import org.apache.avalon.framework.ExceptionUtil;
import org.apache.log.LogEvent;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class StandardFormatter
extends ExtendedPatternFormatter {
    private static final int TYPE_CLASS = 9;
    private static final String TYPE_CLASS_STR = "class";
    private static final String TYPE_CLASS_SHORT_STR = "short";
    public static final int DEFAULT_STACK_DEPTH = 8;
    public static final boolean DEFAULT_PRINT_CASCADING = true;
    private final int m_stackDepth;
    private final boolean m_printCascading;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;

    public StandardFormatter(String pattern) {
        this(pattern, 8, true);
    }

    public StandardFormatter(String pattern, int stackDepth, boolean printCascading) {
        super(pattern);
        this.m_stackDepth = stackDepth;
        this.m_printCascading = printCascading;
    }

    protected String getStackTrace(Throwable throwable, String format) {
        if (null == throwable) {
            return "";
        }
        return ExceptionUtil.printStackTrace((Throwable)throwable, (int)this.m_stackDepth, (boolean)this.m_printCascading);
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getClass(run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getClass(String format) {
        int pos;
        Class clazz = StackIntrospector.getCallerClass((Class)(class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = StandardFormatter.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger));
        if (null == clazz) {
            return "Unknown-class";
        }
        String className = clazz.getName();
        if (TYPE_CLASS_SHORT_STR.equalsIgnoreCase(format) && (pos = className.lastIndexOf(46)) >= 0) {
            className = className.substring(pos + 1);
        }
        return className;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

