/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.StageDirective;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentContext;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.composition.model.impl.DefaultContextModel;
import org.apache.avalon.composition.model.impl.DefaultDependencyModel;
import org.apache.avalon.composition.model.impl.DefaultModel;
import org.apache.avalon.composition.model.impl.DefaultStageModel;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.excalibur.configuration.CascadingConfiguration;

public class DefaultDeploymentModel
extends DefaultModel
implements DeploymentModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel = DefaultDeploymentModel.class$("org.apache.avalon.composition.model.impl.DefaultDeploymentModel")) : class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel));
    private static final String CONTEXTUALIZABLE = "org.apache.avalon.framework.context.Contextualizable";
    private static final Configuration EMPTY_CONFIGURATION = new DefaultConfiguration("configuration", (class$org$apache$avalon$composition$model$DeploymentModel == null ? (class$org$apache$avalon$composition$model$DeploymentModel = DefaultDeploymentModel.class$("org.apache.avalon.composition.model.DeploymentModel")) : class$org$apache$avalon$composition$model$DeploymentModel).getName());
    private final DeploymentContext m_context;
    private final ContextModel m_contextModel;
    private final boolean m_contextDependent;
    private final DependencyModel[] m_dependencies;
    private final StageModel[] m_stages;
    private CategoriesDirective m_categories;
    private Configuration m_config;
    private Parameters m_parameters;
    private boolean m_activation;
    private int m_collection;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$DeploymentModel;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configurable;

    public DefaultDeploymentModel(DeploymentContext context) throws ModelException {
        super(context.getLogger(), context.getPartitionName(), context.getProfile().getName(), context.getProfile().getMode());
        this.m_context = context;
        this.m_activation = this.m_context.getProfile().getActivationPolicy();
        this.m_categories = this.m_context.getProfile().getCategories();
        this.setCollectionPolicy(this.m_context.getProfile().getCollectionPolicy());
        ClassLoader classLoader = this.m_context.getClassLoader();
        if (this.isConfigurable()) {
            Configuration defaults = this.m_context.getType().getConfiguration();
            Configuration explicit = this.m_context.getProfile().getConfiguration();
            Configuration consolidated = this.consolidateConfigurations(explicit, defaults);
            this.m_config = consolidated != null ? consolidated : EMPTY_CONFIGURATION;
        }
        if (this.isParameterizable()) {
            Parameters parameters = this.m_context.getProfile().getParameters();
            this.m_parameters = parameters != null ? parameters : Parameters.EMPTY_PARAMETERS;
        }
        this.m_contextDependent = this.getContextDependentState();
        if (this.m_contextDependent) {
            ContextDescriptor contextDescriptor = this.m_context.getType().getContext();
            ContextDirective contextDirective = this.m_context.getProfile().getContext();
            Logger log = this.getLogger().getChildLogger("context");
            this.m_contextModel = new DefaultContextModel(log, contextDescriptor, contextDirective, context);
        } else {
            this.m_contextModel = null;
        }
        DependencyDescriptor[] dependencies = this.m_context.getType().getDependencies();
        this.m_dependencies = new DefaultDependencyModel[dependencies.length];
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyDescriptor descriptor = dependencies[i];
            DependencyDirective directive = context.getProfile().getDependencyDirective(descriptor.getKey());
            this.m_dependencies[i] = new DefaultDependencyModel(context.getLogger().getChildLogger("deps"), context.getPartitionName(), context.getProfile().getName(), descriptor, directive);
        }
        StageDescriptor[] stages = this.m_context.getType().getStages();
        this.m_stages = new DefaultStageModel[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            StageDescriptor descriptor = stages[i];
            StageDirective directive = context.getProfile().getStageDirective(descriptor.getKey());
            this.m_stages[i] = new DefaultStageModel(context.getLogger().getChildLogger("stages"), context.getPartitionName(), descriptor, directive);
        }
    }

    public ServiceDescriptor[] getServices() {
        return this.m_context.getType().getServices();
    }

    public boolean isaCandidate(DependencyDescriptor dependency) {
        return this.m_context.getType().getService(dependency.getReference()) != null;
    }

    public boolean isaCandidate(StageDescriptor stage) {
        return this.m_context.getType().getExtension(stage) != null;
    }

    public CategoriesDirective getCategories() {
        return this.m_categories;
    }

    public int getCollectionPolicy() {
        if (this.m_collection == -1) {
            return this.getTypeCollectionPolicy();
        }
        return this.m_collection;
    }

    public void setCollectionPolicy(int policy) {
        if (policy == -1) {
            this.m_collection = -1;
        } else {
            int minimum = this.getTypeCollectionPolicy();
            if (policy >= minimum) {
                this.m_collection = policy;
            } else {
                String warning = "Ignoring collection policy override [" + policy + "] because the value is higher that type threshhold [" + minimum + "].";
                this.getLogger().warn(warning);
            }
        }
    }

    private int getTypeCollectionPolicy() {
        return this.m_context.getType().getInfo().getCollectionPolicy();
    }

    public void setCategories(CategoriesDirective categories) {
        this.m_categories = categories;
    }

    public boolean getActivationPolicy() {
        return this.m_activation;
    }

    public void setActivationPolicy(boolean policy) {
        this.m_activation = policy;
    }

    public void revertActivationPolicy() {
        this.m_activation = this.m_context.getProfile().getMode() == Mode.EXPLICIT;
    }

    public Type getType() {
        return this.m_context.getType();
    }

    public Class getDeploymentClass() {
        return this.m_context.getDeploymentClass();
    }

    public boolean isParameterizable() {
        return (class$org$apache$avalon$framework$parameters$Parameterizable == null ? (class$org$apache$avalon$framework$parameters$Parameterizable = DefaultDeploymentModel.class$("org.apache.avalon.framework.parameters.Parameterizable")) : class$org$apache$avalon$framework$parameters$Parameterizable).isAssignableFrom(this.getDeploymentClass());
    }

    public void setParameters(Parameters parameters) {
        this.setParameters(parameters, true);
    }

    public void setParameters(Parameters parameters, boolean policy) throws IllegalStateException {
        if (!this.isParameterizable()) {
            String error = REZ.getString("deployment.parameters.irrational", (Object)this.getDeploymentClass().getName(), (Object)this.toString());
            throw new IllegalStateException(error);
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (policy) {
            Properties props = Parameters.toProperties((Parameters)this.m_parameters);
            Properties suppliment = Parameters.toProperties((Parameters)parameters);
            Enumeration<?> enumeration = suppliment.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = suppliment.getProperty(name);
                if (value == null) {
                    ((Hashtable)props).remove(name);
                    continue;
                }
                props.setProperty(name, value);
            }
            this.m_parameters = Parameters.fromProperties((Properties)props);
        } else {
            this.m_parameters = parameters;
        }
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public boolean isConfigurable() {
        return (class$org$apache$avalon$framework$configuration$Configurable == null ? (class$org$apache$avalon$framework$configuration$Configurable = DefaultDeploymentModel.class$("org.apache.avalon.framework.configuration.Configurable")) : class$org$apache$avalon$framework$configuration$Configurable).isAssignableFrom(this.getDeploymentClass());
    }

    public void setConfiguration(Configuration config) throws IllegalStateException, NullPointerException {
        this.setConfiguration(config, true);
    }

    public void setConfiguration(Configuration config, boolean policy) throws IllegalStateException, NullPointerException {
        if (!this.isConfigurable()) {
            String error = REZ.getString("deployment.configuration.irrational", (Object)this.getDeploymentClass().getName(), (Object)this.toString());
            throw new IllegalStateException(error);
        }
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.m_config = policy ? this.consolidateConfigurations(config, this.m_config) : config;
    }

    public Configuration getConfiguration() {
        return this.m_config;
    }

    public boolean isContextDependent() {
        return this.m_contextDependent;
    }

    public ContextModel getContextModel() {
        return this.m_contextModel;
    }

    public DependencyModel[] getDependencyModels() {
        return this.m_dependencies;
    }

    public StageModel[] getStageModels() {
        return this.m_stages;
    }

    public Class[] getInterfaces() {
        ClassLoader classLoader = this.m_context.getClassLoader();
        ArrayList list = new ArrayList();
        ServiceDescriptor[] services = this.getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            String classname = service.getReference().getClassname();
            list.add(this.getComponentClass(classLoader, classname));
        }
        if (this.getType().getExtensions().length > 0) {
            Class<?>[] interfaces = this.getDeploymentClass().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                list.add(interfaces[i]);
            }
        }
        return list.toArray(new Class[0]);
    }

    private boolean getContextDependentState() {
        if (this.m_context.getType().getStages().length > 0) {
            return true;
        }
        Class base = this.m_context.getDeploymentClass();
        String strategy = this.m_context.getType().getContext().getAttribute("urn:avalon:context.strategy", null);
        ClassLoader classLoader = this.m_context.getClassLoader();
        if (strategy != null) {
            Class contextualizable = this.getComponentClass(classLoader, strategy);
            if (contextualizable == null) {
                String error = REZ.getString("deployment.missing-strategy.error", (Object)strategy, (Object)base.getName());
                throw new IllegalStateException(error);
            }
            if (contextualizable.isAssignableFrom(base)) {
                return true;
            }
            String error = REZ.getString("deployment.inconsitent-strategy.error", (Object)contextualizable, (Object)base);
            throw new IllegalStateException(error);
        }
        Class contextualizable = this.getComponentClass(classLoader, CONTEXTUALIZABLE);
        return contextualizable != null && contextualizable.isAssignableFrom(base);
    }

    private Class getComponentClass(ClassLoader classLoader, String classname) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        try {
            return classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Configuration consolidateConfigurations(Configuration primary, Configuration defaults) {
        if (primary == null) {
            return defaults;
        }
        if (defaults == null) {
            return primary;
        }
        return new CascadingConfiguration(primary, defaults);
    }

    public String toString() {
        return "[deployment model : " + this.getQualifiedName() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

