/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.lang.reflect.InvocationTargetException;
import org.apache.avalon.composition.model.CommissioningException;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.FatalCommissioningException;

class CommissionRequest {
    private final DeploymentModel m_model;
    private final Thread m_thread;
    private long m_timeout;
    private boolean m_completed;
    private boolean m_interrupted;
    private Throwable m_exception;

    CommissionRequest(DeploymentModel model, Thread thread) {
        this.m_model = model;
        this.m_completed = false;
        this.m_interrupted = false;
        this.m_exception = null;
        this.m_thread = thread;
    }

    DeploymentModel getDeploymentModel() {
        return this.m_model;
    }

    long waitForCompletion() throws Exception {
        long t1 = System.currentTimeMillis();
        CommissionRequest commissionRequest = this;
        synchronized (commissionRequest) {
            long timeout = this.getDeploymentModel().getDeploymentTimeout();
            this.waitForCompletion(timeout);
            this.processException();
            if (this.m_completed) {
                long t2 = System.currentTimeMillis();
                return t2 - t1;
            }
            this.m_thread.interrupt();
            this.waitForCompletion(timeout);
            this.processException();
            if (this.m_interrupted || this.m_completed) {
                String error = "target: [" + this.m_model + "] did not respond within the timeout period: [" + timeout + "] and was successfully interrupted.";
                throw new CommissioningException(error);
            }
            String error = "target: [" + this.m_model + "] did not respond within the timeout period: [" + timeout + "] and failed to respond to an interrupt.";
            throw new FatalCommissioningException(error);
        }
    }

    private void waitForCompletion(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            this.wait(timeout);
        } else {
            while (!this.m_completed) {
                this.wait(1000L);
            }
        }
    }

    private void processException() throws Exception {
        if (this.m_exception != null) {
            if (this.m_exception instanceof Exception) {
                throw (Exception)this.m_exception;
            }
            if (this.m_exception instanceof Error) {
                throw (Error)this.m_exception;
            }
            String error = "Unexpected deployment error.";
            throw new InvocationTargetException(this.m_exception, "Unexpected deployment error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done() {
        CommissionRequest commissionRequest = this;
        synchronized (commissionRequest) {
            this.m_completed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupted() {
        this.m_interrupted = true;
        CommissionRequest commissionRequest = this;
        synchronized (commissionRequest) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exception(Throwable e) {
        this.m_exception = e;
        CommissionRequest commissionRequest = this;
        synchronized (commissionRequest) {
            this.m_completed = true;
            this.notify();
        }
    }
}

