/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.composition.data.BlockCompositionDirective;
import org.apache.avalon.composition.data.BlockIncludeDirective;
import org.apache.avalon.composition.data.ComponentProfile;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.NamedComponentProfile;
import org.apache.avalon.composition.data.TargetDirective;
import org.apache.avalon.composition.data.builder.ContainmentProfileBuilder;
import org.apache.avalon.composition.data.builder.XMLContainmentProfileCreator;
import org.apache.avalon.composition.data.builder.XMLTargetsCreator;
import org.apache.avalon.composition.event.CompositionEvent;
import org.apache.avalon.composition.event.CompositionListener;
import org.apache.avalon.composition.model.AssemblyException;
import org.apache.avalon.composition.model.ClassLoaderModel;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DependencyGraph;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelRepository;
import org.apache.avalon.composition.model.ServiceModel;
import org.apache.avalon.composition.model.TypeRepository;
import org.apache.avalon.composition.model.impl.Commissioner;
import org.apache.avalon.composition.model.impl.DefaultContainmentContext;
import org.apache.avalon.composition.model.impl.DefaultContainmentModelAssemblyHelper;
import org.apache.avalon.composition.model.impl.DefaultContainmentModelComponentHelper;
import org.apache.avalon.composition.model.impl.DefaultContainmentModelExportHelper;
import org.apache.avalon.composition.model.impl.DefaultContainmentModelNavigationHelper;
import org.apache.avalon.composition.model.impl.DefaultDeploymentModel;
import org.apache.avalon.composition.provider.ComponentContext;
import org.apache.avalon.composition.provider.ContainmentContext;
import org.apache.avalon.composition.provider.DeploymentContext;
import org.apache.avalon.composition.provider.ModelFactory;
import org.apache.avalon.composition.provider.SecurityModel;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.composition.util.DefaultState;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.logging.data.CategoriesDirective;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultContainmentModel
extends DefaultDeploymentModel
implements ContainmentModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContainmentModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultContainmentModel = DefaultContainmentModel.class$("org.apache.avalon.composition.model.impl.DefaultContainmentModel")) : class$org$apache$avalon$composition$model$impl$DefaultContainmentModel));
    private static final ContainmentProfileBuilder BUILDER = new ContainmentProfileBuilder();
    private static final XMLContainmentProfileCreator CREATOR = new XMLContainmentProfileCreator();
    private static final XMLTargetsCreator TARGETS = new XMLTargetsCreator();
    private final LinkedList m_compositionListeners = new LinkedList();
    private final DefaultState m_assembly = new DefaultState();
    private final ContainmentContext m_context;
    private final String m_partition;
    private final ServiceModel[] m_services;
    private final DefaultState m_commissioned = new DefaultState();
    private CategoriesDirective m_categories;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContainmentModel;

    private static String getPath(ContainmentContext context) {
        if (context.getPartitionName() == null) {
            return "/";
        }
        return context.getPartitionName();
    }

    public DefaultContainmentModel(ContainmentContext context, SecurityModel security) throws ModelException {
        super((DeploymentContext)context, security);
        this.m_context = context;
        this.m_partition = null == context.getPartitionName() ? "/" : context.getPartitionName() + context.getName() + "/";
        DeploymentProfile[] profiles = context.getContainmentProfile().getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            this.addModel(profiles[i]);
        }
        DefaultContainmentModelExportHelper helper = new DefaultContainmentModelExportHelper(this.m_context, this);
        this.m_services = helper.createServiceExport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commission() throws Exception {
        if (!this.isAssembled()) {
            this.assemble();
        }
        DefaultState defaultState = this.m_commissioned;
        synchronized (defaultState) {
            if (this.m_commissioned.isEnabled()) {
                return;
            }
            DeploymentModel[] startup = this.getStartupGraph();
            Commissioner commissioner = new Commissioner(this.getLogger(), true);
            try {
                for (int i = 0; i < startup.length; ++i) {
                    DeploymentModel child = startup[i];
                    commissioner.commission(child);
                }
            }
            finally {
                commissioner.dispose();
            }
            super.commission();
            this.m_commissioned.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommission() {
        DefaultState defaultState = this.m_commissioned;
        synchronized (defaultState) {
            if (!this.m_commissioned.isEnabled()) {
                return;
            }
            if (this.getLogger().isDebugEnabled()) {
                String message = "decommissioning";
                this.getLogger().debug(message);
            }
            super.decommission();
            DeploymentModel[] shutdown = this.getShutdownGraph();
            long timeout = this.getDeploymentTimeout();
            Commissioner commissioner = new Commissioner(this.getLogger(), false);
            try {
                for (int i = 0; i < shutdown.length; ++i) {
                    DeploymentModel child = shutdown[i];
                    child.decommission();
                }
            }
            finally {
                commissioner.dispose();
            }
            this.m_commissioned.setEnabled(false);
        }
    }

    public ClassLoaderModel getClassLoaderModel() {
        return this.m_context.getClassLoaderModel();
    }

    public long getDeploymentTimeout() {
        return 0L;
    }

    public ServiceDescriptor[] getServices() {
        return this.m_context.getContainmentProfile().getExportDirectives();
    }

    public boolean isaCandidate(DependencyDescriptor dependency) {
        return this.isaCandidate(dependency.getReference());
    }

    public boolean isaCandidate(ReferenceDescriptor reference) {
        ServiceDescriptor[] services = this.getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (!service.getReference().matches(reference)) continue;
            return true;
        }
        return false;
    }

    public boolean isaCandidate(StageDescriptor stage) {
        return false;
    }

    public boolean isAssembled() {
        return this.m_assembly.isEnabled();
    }

    public void assemble() throws AssemblyException {
        ArrayList list = new ArrayList();
        this.assemble(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble(List subjects) throws AssemblyException {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (this.isAssembled()) {
                return;
            }
            this.getLogger().debug("assembly phase");
            DefaultContainmentModelAssemblyHelper helper = new DefaultContainmentModelAssemblyHelper(this.m_context, this);
            DeploymentModel[] models = this.m_context.getModelRepository().getModels();
            for (int i = 0; i < models.length; ++i) {
                DeploymentModel model = models[i];
                helper.assembleModel(model, subjects);
            }
            this.m_assembly.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassemble() {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (!this.isAssembled()) {
                return;
            }
            this.getLogger().debug("dissassembly phase");
            DeploymentModel[] models = this.m_context.getModelRepository().getModels();
            for (int i = 0; i < models.length; ++i) {
                DeploymentModel model = models[i];
                if (model instanceof ContainmentModel) {
                    ContainmentModel containment = (ContainmentModel)model;
                    containment.disassemble();
                    continue;
                }
                ComponentModel component = (ComponentModel)model;
                this.dissasemble(component);
            }
            this.m_assembly.setEnabled(false);
        }
    }

    private void dissasemble(ComponentModel model) {
    }

    public DeploymentModel[] getProviders() {
        if (!this.isAssembled()) {
            String error = "Model is not assembled " + this;
            throw new IllegalStateException(error);
        }
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        DeploymentModel[] models = this.m_context.getModelRepository().getModels();
        for (int i = 0; i < models.length; ++i) {
            DeploymentModel model = models[i];
            DeploymentModel[] providers = model.getProviders();
            for (int j = 0; j < providers.length; ++j) {
                String root;
                DeploymentModel provider = providers[j];
                String path = provider.getPath();
                if (path.startsWith(root = this.getPartition())) continue;
                list.add(providers[j]);
            }
        }
        return list.toArray(new DeploymentModel[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompositionListener(CompositionListener listener) {
        LinkedList linkedList = this.m_compositionListeners;
        synchronized (linkedList) {
            this.m_compositionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompositionListener(CompositionListener listener) {
        LinkedList linkedList = this.m_compositionListeners;
        synchronized (linkedList) {
            this.m_compositionListeners.remove(listener);
        }
    }

    public ServiceModel[] getServiceModels() {
        return this.m_services;
    }

    public ServiceModel getServiceModel(Class clazz) {
        ServiceModel[] models = this.getServiceModels();
        for (int i = 0; i < models.length; ++i) {
            ServiceModel model = models[i];
            if (!clazz.isAssignableFrom(model.getServiceClass())) continue;
            return model;
        }
        return null;
    }

    public DeploymentModel[] getStartupGraph() {
        return this.m_context.getDependencyGraph().getStartupGraph();
    }

    public DeploymentModel[] getShutdownGraph() {
        return this.m_context.getDependencyGraph().getShutdownGraph();
    }

    public ContainmentModel addContainmentModel(URL url) throws ModelException {
        return this.addContainmentModel(url, null);
    }

    public ContainmentModel addContainmentModel(URL block, URL config) throws ModelException {
        ContainmentModel model = this.createContainmentModel(null, block);
        this.addModel(model.getName(), (DeploymentModel)model);
        this.applyTargets(config);
        return model;
    }

    public DeploymentModel addModel(DeploymentModel model) {
        String name = model.getName();
        return this.addModel(name, model);
    }

    public DeploymentModel addModel(DeploymentProfile profile) throws ModelException {
        String name = profile.getName();
        DeploymentModel model = this.createDeploymentModel(name, profile);
        this.addModel(name, model);
        return model;
    }

    DeploymentModel createDeploymentModel(DeploymentProfile profile) throws ModelException {
        String name = profile.getName();
        return this.createDeploymentModel(name, profile);
    }

    DeploymentModel createDeploymentModel(String name, DeploymentProfile profile) throws ModelException {
        if (null == profile) {
            throw new NullPointerException("profile");
        }
        ContainmentModel model = null;
        if (profile instanceof ContainmentProfile) {
            ContainmentProfile containment = (ContainmentProfile)profile;
            model = this.createContainmentModel(containment);
        } else if (profile instanceof ComponentProfile) {
            ComponentProfile deployment = (ComponentProfile)profile;
            model = this.createComponentModel(deployment);
        } else if (profile instanceof NamedComponentProfile) {
            ComponentProfile deployment = this.createComponentProfile((NamedComponentProfile)profile);
            model = this.createComponentModel(deployment);
        } else if (profile instanceof BlockIncludeDirective) {
            BlockIncludeDirective directive = (BlockIncludeDirective)profile;
            model = this.createContainmentModel(directive);
        } else if (profile instanceof BlockCompositionDirective) {
            BlockCompositionDirective directive = (BlockCompositionDirective)profile;
            model = this.createContainmentModel(directive);
        } else {
            String error = REZ.getString("containment.unknown-profile-class.error", (Object)this.getPath(), (Object)profile.getClass().getName());
            throw new ModelException(error);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModel(String name) throws IllegalArgumentException {
        ModelRepository repository;
        ModelRepository modelRepository = repository = this.m_context.getModelRepository();
        synchronized (modelRepository) {
            DeploymentModel model = repository.getModel(name);
            if (null == model) {
                String error = "No model named [" + name + "] is referenced with the model [" + this + "].";
                throw new IllegalArgumentException(error);
            }
            this.m_context.getDependencyGraph().remove(model);
            repository.removeModel(model);
            CompositionEvent event = new CompositionEvent((ContainmentModel)this, model);
            this.fireModelRemovedEvent(event);
        }
    }

    public String getPartition() {
        return this.m_partition;
    }

    public DeploymentModel[] getModels() {
        return this.m_context.getModelRepository().getModels();
    }

    public DeploymentModel getModel(String path) {
        DefaultContainmentModelNavigationHelper helper = new DefaultContainmentModelNavigationHelper(this.m_context, this);
        return helper.getModel(path);
    }

    public DeploymentModel getModel(ReferenceDescriptor descriptor) throws AssemblyException {
        DefaultContainmentModelAssemblyHelper helper = new DefaultContainmentModelAssemblyHelper(this.m_context, this);
        return helper.findServiceProvider(descriptor);
    }

    public DeploymentModel getModel(DependencyDescriptor dependency) throws AssemblyException {
        DefaultContainmentModelAssemblyHelper helper = new DefaultContainmentModelAssemblyHelper(this.m_context, this);
        return helper.findDependencyProvider(dependency);
    }

    public void applyTargets(URL config) throws ModelException {
        if (config != null) {
            TargetDirective[] targets = this.getTargets(config);
            this.applyTargets(targets);
        }
    }

    public void applyTargets(TargetDirective[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            TargetDirective target = targets[i];
            String path = target.getPath();
            DeploymentModel model = this.getModel(path);
            if (model != null) {
                this.getLogger().debug("customizing target " + model);
                if (target.getCategoriesDirective() != null) {
                    model.setCategories(target.getCategoriesDirective());
                }
                if (!(model instanceof ComponentModel)) continue;
                ComponentModel deployment = (ComponentModel)model;
                if (target.getConfiguration() == null) continue;
                deployment.setConfiguration(target.getConfiguration());
                continue;
            }
            String warning = REZ.getString("target.ignore", (Object)path, (Object)this.toString());
            this.getLogger().warn(warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentModel addModel(String name, DeploymentModel model) {
        ModelRepository repository;
        if (model.equals(this)) {
            return model;
        }
        ModelRepository modelRepository = repository = this.m_context.getModelRepository();
        synchronized (modelRepository) {
            repository.addModel(name, model);
            this.m_context.getDependencyGraph().add(model);
            CompositionEvent event = new CompositionEvent((ContainmentModel)this, model);
            this.fireModelAddedEvent(event);
            return model;
        }
    }

    private void fireModelAddedEvent(CompositionEvent event) {
        Iterator iterator = this.m_compositionListeners.iterator();
        while (iterator.hasNext()) {
            CompositionListener listener = (CompositionListener)iterator.next();
            try {
                listener.modelAdded(event);
            }
            catch (Throwable e) {
                String error = "A composition listener raised an exception";
                this.getLogger().warn("A composition listener raised an exception", e);
            }
        }
    }

    private void fireModelRemovedEvent(CompositionEvent event) {
        Iterator iterator = this.m_compositionListeners.iterator();
        while (iterator.hasNext()) {
            CompositionListener listener = (CompositionListener)iterator.next();
            try {
                listener.modelRemoved(event);
            }
            catch (Throwable e) {
                String error = "A composition listener raised an exception";
                this.getLogger().warn("A composition listener raised an exception", e);
            }
        }
    }

    private ComponentModel createComponentModel(ComponentProfile profile) throws ModelException {
        DefaultContainmentModelComponentHelper helper = new DefaultContainmentModelComponentHelper(this.m_context, this);
        ComponentContext context = helper.createComponentContext(profile);
        ModelFactory factory = this.m_context.getSystemContext().getModelFactory();
        return factory.createComponentModel(context);
    }

    private ContainmentModel createContainmentModel(ContainmentProfile profile) throws ModelException {
        String name = profile.getName();
        return this.createContainmentModel(name, profile);
    }

    private ContainmentModel createContainmentModel(String name, ContainmentProfile profile) throws ModelException {
        return this.createContainmentModel(name, profile, new URL[0]);
    }

    private ContainmentModel createContainmentModel(String name, ContainmentProfile profile, URL[] implicit) throws ModelException {
        String partition = this.getPartition();
        if (this.getLogger().isDebugEnabled()) {
            SystemContext system = this.m_context.getSystemContext();
            String message = REZ.getString("containment.add", (Object)system.toString((Object)name));
            this.getLogger().debug(message);
        }
        LoggingManager logging = this.m_context.getSystemContext().getLoggingManager();
        String base = partition + name;
        logging.addCategories(base, profile.getCategories());
        Logger log = logging.getLoggerForCategory(base);
        try {
            ClassLoaderModel classLoaderModel = this.m_context.getClassLoaderModel().createClassLoaderModel(log, profile, implicit);
            File home = new File(this.m_context.getHomeDirectory(), name);
            File temp = new File(this.m_context.getTempDirectory(), name);
            Logger logger = this.getLogger().getChildLogger(name);
            ModelRepository modelRepository = this.m_context.getModelRepository();
            DependencyGraph graph = this.m_context.getDependencyGraph();
            DefaultContainmentContext context = new DefaultContainmentContext(logger, this.m_context.getSystemContext(), classLoaderModel, modelRepository, graph, home, temp, this, profile, partition, name);
            ModelFactory factory = this.m_context.getSystemContext().getModelFactory();
            return factory.createContainmentModel((ContainmentContext)context);
        }
        catch (ModelException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.container.create.error", (Object)this.getPath(), (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    private ContainmentModel createContainmentModel(BlockCompositionDirective directive) throws ModelException {
        String name = directive.getName();
        ContainmentModel model = null;
        try {
            Repository repository = this.m_context.getSystemContext().getRepository();
            Artifact artifact = directive.getArtifact();
            URL url = repository.getResource(artifact);
            model = this.createContainmentModel(name, url);
        }
        catch (RepositoryException e) {
            String error = "Unable to include block [" + name + "] into the containmment model [" + this.getQualifiedName() + "] because of a repository related error.";
            throw new ModelException(error, (Throwable)e);
        }
        TargetDirective[] targets = directive.getTargetDirectives();
        model.applyTargets(targets);
        return model;
    }

    private ContainmentModel createContainmentModel(BlockIncludeDirective directive) throws ModelException {
        String name = directive.getName();
        String path = directive.getPath();
        try {
            if (path.indexOf(":") < 0) {
                URL anchor = this.m_context.getSystemContext().getBaseDirectory().toURL();
                URL url = new URL(anchor, path);
                return this.createContainmentModel(name, url);
            }
            URL url = new URL(path);
            return this.createContainmentModel(name, url);
        }
        catch (MalformedURLException e) {
            String error = "Unable to include block [" + name + "] into the containmment model [" + this.getQualifiedName() + "] because of a url related error.";
            throw new ModelException(error, (Throwable)e);
        }
    }

    private ContainmentModel createContainmentModel(String name, URL url) throws ModelException {
        if (url.getProtocol().equals("artifact") || url.getProtocol().equals("block")) {
            try {
                Artifact artifact = (Artifact)url.getContent();
                URL target = this.m_context.getSystemContext().getRepository().getResource(artifact);
                return this.createContainmentModel(name, target);
            }
            catch (Throwable e) {
                String error = "Unresolvable artifact reference [" + url + "].";
                throw new ModelException(error, e);
            }
        }
        String path = url.toString();
        try {
            if (path.endsWith(".jar")) {
                URL jarURL = this.convertToJarURL(url);
                URL blockURL = new URL(jarURL, "/BLOCK-INF/block.xml");
                InputStream stream = blockURL.openStream();
                try {
                    ContainmentProfile profile = BUILDER.createContainmentProfile(stream);
                    String message = "including composite block: " + blockURL.toString();
                    this.getLogger().debug(message);
                    return this.createContainmentModel(this.getName(name, (DeploymentProfile)profile), profile, new URL[]{url});
                }
                catch (Throwable e) {
                    String error = "Unable to create block from embedded descriptor [" + blockURL.toString() + "] in the containmment model [" + this.getQualifiedName() + "] due to a build related error.";
                    throw new ModelException(error, e);
                }
            }
            if (path.endsWith(".xml") || path.endsWith(".block")) {
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration config = builder.build(path);
                ContainmentProfile profile = CREATOR.createContainmentProfile(config);
                String message = "including composite block: " + path;
                this.getLogger().debug(message);
                return this.createContainmentModel(this.getName(name, (DeploymentProfile)profile), profile);
            }
            if (path.endsWith("/")) {
                this.verifyPath(path);
                URL blockURL = new URL(url.toString() + "BLOCK-INF/block.xml");
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration config = builder.build(blockURL.toString());
                ContainmentProfile profile = CREATOR.createContainmentProfile(config);
                String message = "including composite block: " + blockURL.toString();
                this.getLogger().debug(message);
                return this.createContainmentModel(this.getName(name, (DeploymentProfile)profile), profile, new URL[]{url});
            }
            if (path.endsWith(".bar")) {
                String error = "Cannot execute a block archive: " + path;
                throw new ModelException(error);
            }
            this.verifyPath(path);
            return this.createContainmentModel(name, new URL(path + "/"));
        }
        catch (ModelException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            String error = "Unable to include block [" + path + "] into the containmment model [" + this.getQualifiedName() + "] because of a url related error.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (IOException e) {
            String error = "Unable to include block [" + path + "] into the containmment model [" + this.getQualifiedName() + "] because of a io related error.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = "Unable to include block [" + path + "] into the containmment model [" + this.getQualifiedName() + "] because of an unexpected error.";
            throw new ModelException(error, e);
        }
    }

    private void verifyPath(String path) throws ModelException {
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            connection.connect();
        }
        catch (FileNotFoundException e) {
            String error = "File not found: " + path;
            throw new ModelException(error);
        }
        catch (Throwable e) {
            String error = "Invalid path: " + path;
            throw new ModelException(error, e);
        }
    }

    private String getName(String name, DeploymentProfile profile) {
        if (name != null) {
            return name;
        }
        return profile.getName();
    }

    private URL convertToJarURL(URL url) throws MalformedURLException {
        if (url.getProtocol().equals("jar")) {
            return url;
        }
        return new URL("jar:" + url.toString() + "!/");
    }

    private ComponentProfile createComponentProfile(NamedComponentProfile profile) throws ModelException {
        try {
            NamedComponentProfile holder = profile;
            String classname = holder.getClassname();
            String key = holder.getKey();
            TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
            Type type = repository.getType(classname);
            ComponentProfile template = repository.getProfile(type, key);
            return new ComponentProfile(profile.getName(), template);
        }
        catch (Throwable e) {
            String error = REZ.getString("containment.model.create.deployment.error", (Object)profile.getKey(), (Object)this.getPath(), (Object)profile.getClassname());
            throw new ModelException(error, e);
        }
    }

    private TargetDirective[] getTargets(URL url) throws ModelException {
        try {
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            Configuration config = builder.build(url.toString());
            return TARGETS.createTargets(config).getTargets();
        }
        catch (Throwable e) {
            String error = "Could not load the targets directive: " + url;
            throw new ModelException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

