/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.composition.data.ComponentProfile;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.info.DeliveryDescriptor;
import org.apache.avalon.composition.info.StagedDeliveryDescriptor;
import org.apache.avalon.composition.model.AssemblyException;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelRepository;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.model.ProviderNotFoundException;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.composition.model.TypeRepository;
import org.apache.avalon.composition.model.TypeUnknownException;
import org.apache.avalon.composition.model.impl.DefaultContainmentModel;
import org.apache.avalon.composition.model.impl.DefaultModelSelector;
import org.apache.avalon.composition.model.impl.DefaultProfileSelector;
import org.apache.avalon.composition.provider.ContainmentContext;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

class DefaultContainmentModelAssemblyHelper {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContainmentModelAssemblyHelper == null ? (class$org$apache$avalon$composition$model$impl$DefaultContainmentModelAssemblyHelper = DefaultContainmentModelAssemblyHelper.class$("org.apache.avalon.composition.model.impl.DefaultContainmentModelAssemblyHelper")) : class$org$apache$avalon$composition$model$impl$DefaultContainmentModelAssemblyHelper));
    private final ContainmentContext m_context;
    private final DefaultContainmentModel m_model;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContainmentModelAssemblyHelper;

    public DefaultContainmentModelAssemblyHelper(ContainmentContext context, DefaultContainmentModel model) {
        this.m_context = context;
        this.m_model = model;
    }

    public void assembleModel(DeploymentModel model, List subjects) throws AssemblyException {
        if (null == model) {
            throw new NullPointerException("model");
        }
        if (null == subjects) {
            throw new NullPointerException("subjects");
        }
        if (subjects.contains(model)) {
            return;
        }
        if (model.isAssembled()) {
            return;
        }
        if (model instanceof ComponentModel) {
            this.assembleComponent((ComponentModel)model, subjects);
        } else {
            ContainmentModel containment = (ContainmentModel)model;
            containment.assemble(subjects);
        }
    }

    private void assembleComponent(ComponentModel model, List subjects) throws AssemblyException {
        DeploymentModel provider;
        StageModel stage;
        ModelRepository repository = this.m_context.getModelRepository();
        ContextModel context = model.getContextModel();
        DeliveryDescriptor delivery = context.getDeliveryDescriptor();
        if (context.isEnabled() && delivery instanceof StagedDeliveryDescriptor && null == context.getProvider()) {
            StagedDeliveryDescriptor phased = (StagedDeliveryDescriptor)delivery;
            Class clazz = phased.getDeliveryInterfaceClass();
            try {
                subjects.add(model);
                stage = new StageDescriptor(clazz.getName());
                provider = this.findExtensionProvider(repository, (StageDescriptor)stage, subjects);
                context.setProvider(provider);
            }
            catch (Throwable e) {
                String error = "Unable to assemble component: " + model + " due to a component context phase handler establishment failure.";
                throw new AssemblyException(error, e);
            }
            finally {
                subjects.remove(model);
            }
        }
        StageModel[] stages = model.getStageModels();
        for (int i = 0; i < stages.length; ++i) {
            stage = stages[i];
            if (null != stage.getProvider()) continue;
            try {
                subjects.add(model);
                provider = this.findExtensionProvider(repository, stage, subjects);
                stage.setProvider(provider);
                continue;
            }
            catch (Throwable e) {
                String error = "Unable to assemble component: " + model + " due to a component extension handler establishment failure.";
                throw new AssemblyException(error, e);
            }
            finally {
                subjects.remove(model);
            }
        }
        DependencyModel[] dependencies = model.getDependencyModels();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyModel dependency = dependencies[i];
            if (null != dependency.getProvider()) continue;
            try {
                subjects.add(model);
                DeploymentModel provider2 = this.findDependencyProvider(repository, dependency, subjects);
                dependency.setProvider(provider2);
                continue;
            }
            catch (Throwable e) {
                String error = "Unable to assemble component: " + model + " due to a service provider establishment failure.";
                throw new AssemblyException(error, e);
            }
            finally {
                subjects.remove(model);
            }
        }
    }

    private DeploymentModel findDependencyProvider(ModelRepository repository, DependencyModel dependency, List subjects) throws AssemblyException {
        String path = dependency.getPath();
        if (null != path) {
            DeploymentModel model = this.m_model.getModel(path);
            if (null == model) {
                String error = "Could not locate a model at the address: [" + path + "] in " + this + ".";
                throw new AssemblyException(error);
            }
            this.assembleModel(model, subjects);
            return model;
        }
        return this.findDependencyProvider(repository, dependency.getDependency(), subjects);
    }

    DeploymentModel findDependencyProvider(DependencyDescriptor dependency) throws AssemblyException {
        ArrayList list = new ArrayList();
        ModelRepository repository = this.m_context.getModelRepository();
        return this.findDependencyProvider(repository, dependency, list);
    }

    private DeploymentModel findDependencyProvider(ModelRepository repository, DependencyDescriptor dependency, List subjects) throws AssemblyException {
        DefaultModelSelector selector = new DefaultModelSelector();
        DeploymentModel[] candidates = repository.getCandidateProviders(dependency);
        DeploymentModel model = selector.select(candidates, dependency);
        if (model != null) {
            this.assembleModel(model, subjects);
            return model;
        }
        DefaultProfileSelector profileSelector = new DefaultProfileSelector();
        DeploymentProfile[] profiles = this.findDependencyProfiles(dependency);
        DeploymentProfile profile = profileSelector.select(profiles, dependency);
        if (profile != null) {
            try {
                DeploymentModel solution = this.m_model.createDeploymentModel(profile);
                this.assembleModel(solution, subjects);
                this.m_model.addModel(solution);
                return solution;
            }
            catch (AssemblyException ae) {
                String error = "Nested assembly failure while attempting to construct model for the profile: " + profile + " for the dependency: [" + dependency + "].";
                throw new AssemblyException(error, (Throwable)ae);
            }
            catch (ModelException me) {
                String error = "Nested model failure while attempting to add model for the profile: " + profile + " for the dependency: [" + dependency + "].";
                throw new AssemblyException(error, (Throwable)me);
            }
        }
        String error = "Unable to locate a service provider for the dependency: [ " + dependency + "].";
        throw new AssemblyException(error);
    }

    DeploymentModel findServiceProvider(ReferenceDescriptor reference) throws AssemblyException {
        ArrayList list = new ArrayList();
        ModelRepository repository = this.m_context.getModelRepository();
        return this.findServiceProvider(repository, reference, list);
    }

    private DeploymentModel findServiceProvider(ModelRepository repository, ReferenceDescriptor reference, List subjects) throws AssemblyException {
        DefaultModelSelector selector = new DefaultModelSelector();
        DeploymentModel[] candidates = repository.getCandidateProviders(reference);
        DeploymentModel model = selector.select(candidates, reference);
        if (model != null) {
            this.assembleModel(model, subjects);
            return model;
        }
        DefaultProfileSelector profileSelector = new DefaultProfileSelector();
        DeploymentProfile[] profiles = this.findServiceProfiles(reference);
        DeploymentProfile profile = profileSelector.select(profiles, reference);
        if (profile != null) {
            try {
                DeploymentModel solution = this.m_model.createDeploymentModel(profile);
                this.assembleModel(solution, subjects);
                this.m_model.addModel(solution);
                return solution;
            }
            catch (AssemblyException ae) {
                String error = "Nested assembly failure while attempting to construct model for the profile: [" + profile + "] for the reference: [" + reference + "].";
                throw new AssemblyException(error, (Throwable)ae);
            }
            catch (ModelException me) {
                String error = "Nested model failure while attempting to add model for the profile: " + profile + " for the reference: [" + reference + "].";
                throw new AssemblyException(error, (Throwable)me);
            }
        }
        String error = "Unable to locate a service provider for the reference: [ " + reference + "].";
        throw new ProviderNotFoundException(error);
    }

    private DeploymentModel findExtensionProvider(ModelRepository repository, StageModel stage, List subjects) throws AssemblyException {
        String path = stage.getPath();
        if (null != path) {
            DeploymentModel model = this.m_model.getModel(path);
            if (null == model) {
                String error = "Could not locate a model at the address: [" + path + "] in " + this + ".";
                throw new AssemblyException(error);
            }
            this.assembleModel(model, subjects);
            return model;
        }
        return this.findExtensionProvider(repository, stage.getStage(), subjects);
    }

    private DeploymentModel findExtensionProvider(ModelRepository repository, StageDescriptor stage, List subjects) throws AssemblyException {
        DefaultModelSelector selector = new DefaultModelSelector();
        DeploymentModel[] candidates = repository.getCandidateProviders(stage);
        DeploymentModel model = selector.select(candidates, stage);
        if (model != null) {
            this.assembleModel(model, subjects);
            return model;
        }
        DefaultProfileSelector profileSelector = new DefaultProfileSelector();
        DeploymentProfile[] profiles = this.findExtensionProfiles(stage);
        DeploymentProfile profile = profileSelector.select(profiles, stage);
        if (profile != null) {
            try {
                DeploymentModel solution = this.m_model.createDeploymentModel(profile);
                this.assembleModel(solution, subjects);
                this.m_model.addModel(solution);
                return solution;
            }
            catch (AssemblyException ae) {
                String error = "Nested assembly failure while attempting to construct model for the extension profile: [" + profile + "] for the stage dependency: [" + stage + "].";
                throw new AssemblyException(error, (Throwable)ae);
            }
            catch (ModelException me) {
                String error = "Nested model failure while attempting to add model for the extension profile: " + profile + " for the stage dependency: [" + stage + "].";
                throw new AssemblyException(error, (Throwable)me);
            }
        }
        String error = "Unable to locate a extension provider for the stage: [ " + stage + "].";
        throw new ProviderNotFoundException(error);
    }

    private DeploymentProfile[] findExtensionProfiles(StageDescriptor stage) {
        TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
        Type[] types = repository.getTypes(stage);
        try {
            return this.getProfiles(repository, types);
        }
        catch (TypeUnknownException tue) {
            String error = "An irrational condition has occured.";
            throw new ModelRuntimeException("An irrational condition has occured.", (Throwable)tue);
        }
    }

    private DeploymentProfile[] findDependencyProfiles(DependencyDescriptor dependency) {
        TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
        Type[] types = repository.getTypes(dependency);
        try {
            return this.getProfiles(repository, types);
        }
        catch (TypeUnknownException tue) {
            String error = "An irrational condition has occured.";
            throw new ModelRuntimeException("An irrational condition has occured.", (Throwable)tue);
        }
    }

    private DeploymentProfile[] findServiceProfiles(ReferenceDescriptor reference) {
        TypeRepository repository = this.m_context.getClassLoaderModel().getTypeRepository();
        Type[] types = repository.getTypes(reference);
        try {
            return this.getProfiles(repository, types);
        }
        catch (TypeUnknownException tue) {
            String error = "An irrational condition has occured.";
            throw new ModelRuntimeException("An irrational condition has occured.", (Throwable)tue);
        }
    }

    private DeploymentProfile[] getProfiles(TypeRepository repository, Type[] types) throws TypeUnknownException {
        ArrayList<ComponentProfile> list = new ArrayList<ComponentProfile>();
        for (int i = 0; i < types.length; ++i) {
            ComponentProfile[] profiles = repository.getProfiles(types[i]);
            for (int j = 0; j < profiles.length; ++j) {
                list.add(profiles[j]);
            }
        }
        return list.toArray(new DeploymentProfile[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

