/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelRepository;
import org.apache.avalon.composition.model.TypeRepository;
import org.apache.avalon.composition.model.impl.DefaultModelSelector;
import org.apache.avalon.composition.model.impl.DefaultServiceModel;
import org.apache.avalon.composition.provider.ContainmentContext;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

class DefaultContainmentModelExportHelper {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContainmentModelExportHelper == null ? (class$org$apache$avalon$composition$model$impl$DefaultContainmentModelExportHelper = DefaultContainmentModelExportHelper.class$("org.apache.avalon.composition.model.impl.DefaultContainmentModelExportHelper")) : class$org$apache$avalon$composition$model$impl$DefaultContainmentModelExportHelper));
    private final ContainmentContext m_context;
    private final ContainmentModel m_model;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContainmentModelExportHelper;

    public DefaultContainmentModelExportHelper(ContainmentContext context, ContainmentModel model) {
        this.m_context = context;
        this.m_model = model;
    }

    public DefaultServiceModel[] createServiceExport() throws ModelException {
        ServiceDirective[] export = this.m_context.getContainmentProfile().getExportDirectives();
        DefaultServiceModel[] services = new DefaultServiceModel[export.length];
        for (int i = 0; i < export.length; ++i) {
            ServiceDirective service = export[i];
            Class clazz = this.getServiceExportClass(service);
            DeploymentModel provider = this.locateImplementionProvider(service);
            services[i] = new DefaultServiceModel(service, clazz, provider);
        }
        return services;
    }

    private Class getServiceExportClass(ServiceDirective service) throws ModelException {
        String classname = service.getReference().getClassname();
        try {
            ClassLoader classloader = this.m_context.getClassLoader();
            return classloader.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Cannot load service class [" + classname + "].";
            throw new ModelException(error, e);
        }
    }

    private DeploymentModel locateImplementionProvider(ServiceDirective service) throws ModelException {
        String path = service.getPath();
        if (null != path) {
            DeploymentModel provider = this.m_model.getModel(path);
            if (null == provider) {
                String error = "Implemention provider path [" + path + "] for the exported service [" + service.getReference() + "] in the containment model " + this.m_model + " does not reference a known model.";
                throw new ModelException(error);
            }
            return provider;
        }
        DependencyDescriptor dependency = new DependencyDescriptor("export", service.getReference());
        DefaultModelSelector selector = new DefaultModelSelector();
        ModelRepository repository = this.m_context.getModelRepository();
        DeploymentModel[] candidates = repository.getModels();
        DeploymentModel provider = selector.select(candidates, dependency);
        if (null != provider) {
            return provider;
        }
        TypeRepository repo = this.m_context.getClassLoaderModel().getTypeRepository();
        DeploymentProfile profile = repo.getProfile(dependency, false);
        if (profile != null) {
            return this.m_model.addModel(profile);
        }
        String error = "Could not locate a provider for the exported service [" + dependency.getReference() + "] in the containment model " + this.m_model;
        throw new ModelException(error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

