/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.provider.ContainmentContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

class DefaultContainmentModelNavigationHelper {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContainmentModelNavigationHelper == null ? (class$org$apache$avalon$composition$model$impl$DefaultContainmentModelNavigationHelper = DefaultContainmentModelNavigationHelper.class$("org.apache.avalon.composition.model.impl.DefaultContainmentModelNavigationHelper")) : class$org$apache$avalon$composition$model$impl$DefaultContainmentModelNavigationHelper));
    private final ContainmentContext m_context;
    private final ContainmentModel m_model;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContainmentModelNavigationHelper;

    public DefaultContainmentModelNavigationHelper(ContainmentContext context, ContainmentModel model) {
        this.m_context = context;
        this.m_model = model;
    }

    public DeploymentModel getModel(String path) {
        ContainmentModel parent = this.m_context.getParentContainmentModel();
        if (path.equals("")) {
            return this.m_model;
        }
        if (path.startsWith("/")) {
            if (null != parent) {
                return parent.getModel(path);
            }
            return this.m_model.getModel(path.substring(1));
        }
        String root = this.getRootName(path);
        if (root.equals("..")) {
            if (null != parent) {
                String remainder = this.getRemainder(root, path);
                return parent.getModel(remainder);
            }
            String error = "Supplied path [" + path + "] references a container above the root container.";
            throw new IllegalArgumentException(error);
        }
        if (root.equals(".")) {
            String remainder = this.getRemainder(root, path);
            return this.m_model.getModel(remainder);
        }
        if (path.indexOf("/") < 0) {
            return this.m_context.getModelRepository().getModel(path);
        }
        DeploymentModel model = this.m_context.getModelRepository().getModel(root);
        if (model != null) {
            if (model instanceof ContainmentModel) {
                ContainmentModel container = (ContainmentModel)model;
                String remainder = this.getRemainder(root, path);
                return container.getModel(remainder);
            }
            String error = "The path element [" + root + "] does not reference a containment model within [" + this.m_model + "].";
            throw new IllegalArgumentException(error);
        }
        String error = "Unable to locate a container with name [" + root + "] within the container [" + this.m_model + "].";
        throw new IllegalArgumentException(error);
    }

    private String getRootName(String path) {
        int n = path.indexOf("/");
        if (n < 0) {
            return path;
        }
        return path.substring(0, n);
    }

    private String getRemainder(String name, String path) {
        return path.substring(name.length() + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

