/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.SelectionDirective;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.impl.DefaultDependent;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultDependencyModel
extends DefaultDependent
implements DependencyModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultDependencyModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultDependencyModel = DefaultDependencyModel.class$("org.apache.avalon.composition.model.impl.DefaultDependencyModel")) : class$org$apache$avalon$composition$model$impl$DefaultDependencyModel));
    private final DependencyDescriptor m_descriptor;
    private final DependencyDirective m_directive;
    private final String m_partition;
    private final String m_name;
    private final String m_source;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultDependencyModel;

    public DefaultDependencyModel(Logger logger, String partition, String name, DependencyDescriptor descriptor, DependencyDirective directive) throws ModelException {
        super(logger);
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
        this.m_descriptor = descriptor;
        this.m_directive = directive;
        this.m_partition = partition;
        this.m_name = name;
        if (directive != null) {
            if (directive.getSource() != null) {
                this.m_source = this.resolvePath(partition, directive.getSource());
                String message = REZ.getString("dependency.path.debug", (Object)this.m_source, (Object)directive.getKey());
                this.getLogger().debug(message);
            } else {
                this.m_source = null;
            }
        } else {
            this.m_source = null;
        }
    }

    public DependencyDescriptor getDependency() {
        return this.m_descriptor;
    }

    public String getPath() {
        return this.m_source;
    }

    public ServiceDescriptor[] filter(ServiceDescriptor[] candidates) {
        if (this.m_directive != null && this.m_directive.getSource() == null) {
            return this.filter(this.m_directive, candidates);
        }
        return candidates;
    }

    private ServiceDescriptor[] filter(DependencyDirective directive, ServiceDescriptor[] services) {
        SelectionDirective[] filters = this.getFilters(directive);
        ArrayList<ServiceDescriptor> list = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (!this.isaCandidate(service, filters)) continue;
            list.add(service);
        }
        ServiceDescriptor[] candidates = list.toArray(new ServiceDescriptor[0]);
        return candidates;
    }

    private boolean isaCandidate(ServiceDescriptor service, SelectionDirective[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            SelectionDirective filter = filters[i];
            if (this.isaCandidate(service, filter)) continue;
            return false;
        }
        return true;
    }

    private boolean isaCandidate(ServiceDescriptor service, SelectionDirective filter) {
        String feature = filter.getFeature();
        String value = filter.getValue();
        String criteria = filter.getCriteria();
        if (criteria.equals("equals")) {
            return value.equals(service.getAttribute(feature));
        }
        if (criteria.equals("exists")) {
            return service.getAttribute(feature) != null;
        }
        if (criteria.equals("includes")) {
            String v = service.getAttribute(feature);
            if (v != null) {
                return v.indexOf(value) > -1;
            }
            return false;
        }
        String error = REZ.getString("dependency.invalid-criteria.error", (Object)criteria, (Object)feature);
        throw new IllegalArgumentException(error);
    }

    private String resolvePath(String partition, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith("../")) {
            String parent = this.getParentPath(partition);
            return this.resolvePath(parent, path.substring(3));
        }
        if (path.startsWith("./")) {
            return this.resolvePath(partition, path.substring(2));
        }
        return partition + path;
    }

    private String getParentPath(String partition) {
        int n = partition.lastIndexOf("/");
        if (n > 0) {
            int index = partition.substring(0, n - 1).lastIndexOf("/");
            if (index == 0) {
                return "/";
            }
            return partition.substring(0, index) + "/";
        }
        String error = "Illegal attempt to reference a containment context above the root context.";
        throw new IllegalArgumentException("Illegal attempt to reference a containment context above the root context.");
    }

    private SelectionDirective[] getFilters(DependencyDirective directive) {
        ArrayList<SelectionDirective> list = new ArrayList<SelectionDirective>();
        SelectionDirective[] selections = directive.getSelectionDirectives();
        for (int i = 0; i < selections.length; ++i) {
            SelectionDirective selection = selections[i];
            if (!selection.isRequired()) continue;
            list.add(selection);
        }
        return list.toArray(new SelectionDirective[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

