/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.security.AccessControlContext;
import java.security.Permissions;
import java.security.ProtectionDomain;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.model.Commissionable;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.provider.DeploymentContext;
import org.apache.avalon.composition.provider.SecurityModel;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.logging.data.CategoriesDirective;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public abstract class DefaultDeploymentModel
implements DeploymentModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel = DefaultDeploymentModel.class$("org.apache.avalon.composition.model.impl.DefaultDeploymentModel")) : class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel));
    private final DeploymentContext m_context;
    private final SecurityModel m_security;
    private final AccessControlContext m_access;
    private Commissionable m_handler = null;
    private CategoriesDirective m_categories;
    private Logger m_logger;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultDeploymentModel;

    public DefaultDeploymentModel(DeploymentContext context, SecurityModel security) {
        if (null == context) {
            throw new NullPointerException("context");
        }
        if (null == security) {
            throw new NullPointerException("security");
        }
        this.m_context = context;
        this.m_security = security;
        this.m_logger = this.m_context.getLogger();
        this.m_categories = this.m_context.getProfile().getCategories();
        Permissions permissions = security.getPermissions();
        ProtectionDomain domain = new ProtectionDomain(null, permissions);
        ProtectionDomain[] domains = new ProtectionDomain[]{domain};
        this.m_access = new AccessControlContext(domains);
    }

    public void commission() throws Exception {
        this.m_context.getSystemContext().commission((DeploymentModel)this);
    }

    public void decommission() {
        this.m_context.getSystemContext().decommission((DeploymentModel)this);
    }

    public Object resolve() throws Exception {
        return this.m_context.getSystemContext().resolve((DeploymentModel)this);
    }

    public Object resolve(boolean proxy) throws Exception {
        return this.m_context.getSystemContext().resolve((DeploymentModel)this, proxy);
    }

    public void release(Object instance) {
        this.m_context.getSystemContext().release((DeploymentModel)this, instance);
    }

    public String getName() {
        return this.m_context.getName();
    }

    public String getPath() {
        if (null == this.m_context.getPartitionName()) {
            return "/";
        }
        return this.m_context.getPartitionName();
    }

    public String getQualifiedName() {
        return this.getPath() + this.getName();
    }

    public Mode getMode() {
        return this.m_context.getMode();
    }

    public DeploymentModel[] getConsumerGraph() {
        return this.m_context.getDependencyGraph().getConsumerGraph((DeploymentModel)this);
    }

    public DeploymentModel[] getProviderGraph() {
        return this.m_context.getDependencyGraph().getProviderGraph((DeploymentModel)this);
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public Permissions getPermissions() {
        return this.m_security.getPermissions();
    }

    public AccessControlContext getAccessControlContext() {
        return this.m_access;
    }

    public String toString() {
        return "[" + this.getQualifiedName() + "]";
    }

    public boolean equals(Object other) {
        boolean equal = super.equals(other);
        return equal;
    }

    public long getDeploymentTimeout() {
        SystemContext system = this.m_context.getSystemContext();
        return system.getDefaultDeploymentTimeout();
    }

    public CategoriesDirective getCategories() {
        if (this.m_categories == null) {
            return this.m_context.getProfile().getCategories();
        }
        return this.m_categories;
    }

    public void setCategories(CategoriesDirective categories) {
        this.m_categories = categories;
        LoggingManager logging = this.m_context.getSystemContext().getLoggingManager();
        String path = this.getQualifiedName();
        logging.addCategories(path, categories);
        this.m_logger = logging.getLoggerForCategory(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ DeploymentModel[] getProviders();

    public abstract /* synthetic */ boolean isAssembled();

    public abstract /* synthetic */ boolean isaCandidate(ReferenceDescriptor var1);

    public abstract /* synthetic */ boolean isaCandidate(StageDescriptor var1);

    public abstract /* synthetic */ boolean isaCandidate(DependencyDescriptor var1);

    public abstract /* synthetic */ ServiceDescriptor[] getServices();
}

