/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avalon.composition.data.ExcludeDirective;
import org.apache.avalon.composition.data.IncludeDirective;
import org.apache.avalon.composition.model.FilesetModel;
import org.apache.avalon.composition.model.impl.DirectoryScanner;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class DefaultFilesetModel
extends AbstractLogEnabled
implements FilesetModel {
    private File m_anchor = null;
    private IncludeDirective[] m_includes = null;
    private ExcludeDirective[] m_excludes = null;
    private String[] m_defaultIncludes = null;
    private String[] m_defaultExcludes = null;
    private ArrayList m_list = null;
    private final Logger m_logger;

    public DefaultFilesetModel(File anchor, IncludeDirective[] includes, ExcludeDirective[] excludes, String[] defaultIncludes, String[] defaultExcludes, Logger logger) {
        this.m_logger = logger;
        this.m_list = new ArrayList();
        this.setBaseDirectory(anchor);
        this.setIncludeDirectives(includes);
        this.setExcludeDirectives(excludes);
        this.setDefaultIncludes(defaultIncludes);
        this.setDefaultExcludes(defaultExcludes);
    }

    private void setBaseDirectory(File anchor) {
        this.m_anchor = anchor;
    }

    private void setIncludeDirectives(IncludeDirective[] includes) {
        this.m_includes = includes;
    }

    private void setExcludeDirectives(ExcludeDirective[] excludes) {
        this.m_excludes = excludes;
    }

    private void setDefaultIncludes(String[] defaultIncludes) {
        this.m_defaultIncludes = defaultIncludes == null ? new String[0] : defaultIncludes;
    }

    private void setDefaultExcludes(String[] defaultExcludes) {
        this.m_defaultExcludes = defaultExcludes == null ? new String[0] : defaultExcludes;
    }

    public ArrayList getIncludes() {
        return this.m_list;
    }

    public void resolveFileset() throws IOException, IllegalStateException {
        int i;
        if (this.m_anchor == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.m_anchor.exists()) {
            throw new IllegalStateException("basedir " + this.m_anchor + " does not exist");
        }
        if (!this.m_anchor.isDirectory()) {
            throw new IllegalStateException("basedir " + this.m_anchor + " is not a directory");
        }
        if (this.m_includes.length == 0 && this.m_defaultIncludes.length == 0) {
            this.m_list.add(this.m_anchor);
            this.m_logger.debug("candidates=[" + this.m_anchor + "]");
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setLogger(this.m_logger);
        ds.setBasedir(this.m_anchor);
        this.m_logger.debug("ds.basedir=[" + ds.getBasedir() + "]");
        for (int i2 = 0; i2 < this.m_defaultExcludes.length; ++i2) {
            this.m_logger.debug("m_defaultExcludes[" + i2 + "]=[" + this.m_defaultExcludes[i2] + "]");
            DirectoryScanner.addDefaultExclude(this.m_defaultExcludes[i2]);
        }
        String[] includes = new String[this.m_includes.length];
        if (this.m_includes.length == 0) {
            for (i = 0; i < this.m_defaultIncludes.length; ++i) {
                includes[i] = this.m_defaultIncludes[i];
                this.m_logger.debug("includes[" + i + "]=[" + includes[i] + "]");
            }
        } else {
            for (i = 0; i < this.m_includes.length; ++i) {
                includes[i] = this.m_includes[i].getPath();
                this.m_logger.debug("includes[" + i + "]=[" + includes[i] + "]");
            }
        }
        ds.setIncludes(includes);
        String[] excludes = new String[this.m_excludes.length];
        for (int i3 = 0; i3 < this.m_excludes.length; ++i3) {
            excludes[i3] = this.m_excludes[i3].getPath();
            this.m_logger.debug("excludes[" + i3 + "]=[" + excludes[i3] + "]");
        }
        ds.setExcludes(excludes);
        ds.setCaseSensitive(true);
        ds.scan();
        this.m_logger.debug(ds.toString());
        String[] candidates = ds.getIncludedFiles();
        if (candidates.length > 0) {
            for (int i4 = 0; i4 < candidates.length; ++i4) {
                File file = new File(this.m_anchor, candidates[i4]);
                this.m_logger.debug("candidates[" + i4 + "]=[" + file.getAbsolutePath() + "]");
                this.m_list.add(file);
            }
        } else {
            this.m_list.add(this.m_anchor);
            this.m_logger.debug("candidates=[" + this.m_anchor + "]");
        }
    }
}

