/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelRepository;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

public class DefaultModelRepository
implements ModelRepository {
    private ModelRepository m_parent;
    private Logger m_logger;
    private final Map m_models = new Hashtable();

    public DefaultModelRepository(ModelRepository parent, Logger logger) {
        this.m_parent = parent;
        this.m_logger = logger;
    }

    public DeploymentModel getModel(DependencyDescriptor dependency) {
        return this.getModel(dependency.getReference());
    }

    public DeploymentModel getModel(ReferenceDescriptor reference) {
        Iterator iterator = this.m_models.values().iterator();
        while (iterator.hasNext()) {
            DeploymentModel model = (DeploymentModel)iterator.next();
            if (!model.isaCandidate(reference)) continue;
            return model;
        }
        if (this.m_parent != null) {
            return this.m_parent.getModel(reference);
        }
        return null;
    }

    public DeploymentModel[] getCandidateProviders(StageDescriptor stage) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        Iterator iterator = this.m_models.values().iterator();
        while (iterator.hasNext()) {
            DeploymentModel model = (DeploymentModel)iterator.next();
            if (!model.isaCandidate(stage)) continue;
            list.add(model);
        }
        if (this.m_parent != null) {
            DeploymentModel[] models = this.m_parent.getCandidateProviders(stage);
            for (int i = 0; i < models.length; ++i) {
                list.add(models[i]);
            }
        }
        return list.toArray(new DeploymentModel[0]);
    }

    public DeploymentModel[] getCandidateProviders(DependencyDescriptor dependency) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        Iterator iterator = this.m_models.values().iterator();
        while (iterator.hasNext()) {
            DeploymentModel model = (DeploymentModel)iterator.next();
            if (!model.isaCandidate(dependency)) continue;
            list.add(model);
        }
        if (this.m_parent != null) {
            DeploymentModel[] models = this.m_parent.getCandidateProviders(dependency);
            for (int i = 0; i < models.length; ++i) {
                list.add(models[i]);
            }
        }
        return list.toArray(new DeploymentModel[0]);
    }

    public DeploymentModel[] getCandidateProviders(ReferenceDescriptor reference) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        Iterator iterator = this.m_models.values().iterator();
        while (iterator.hasNext()) {
            DeploymentModel model = (DeploymentModel)iterator.next();
            if (!model.isaCandidate(reference)) continue;
            list.add(model);
        }
        if (this.m_parent != null) {
            DeploymentModel[] models = this.m_parent.getCandidateProviders(reference);
            for (int i = 0; i < models.length; ++i) {
                list.add(models[i]);
            }
        }
        return list.toArray(new DeploymentModel[0]);
    }

    public DeploymentModel getModel(StageDescriptor stage) {
        Iterator iterator = this.m_models.values().iterator();
        while (iterator.hasNext()) {
            DeploymentModel model = (DeploymentModel)iterator.next();
            if (!model.isaCandidate(stage)) continue;
            return model;
        }
        if (this.m_parent != null) {
            return this.m_parent.getModel(stage);
        }
        return null;
    }

    public void addModel(DeploymentModel model) {
        this.m_models.put(model.getName(), model);
    }

    public void addModel(String name, DeploymentModel model) {
        this.m_models.put(name, model);
    }

    public void removeModel(DeploymentModel model) {
        this.m_models.remove(model.getName());
    }

    public DeploymentModel[] getModels() {
        return this.m_models.values().toArray(new DeploymentModel[0]);
    }

    public DeploymentModel getModel(String name) {
        DeploymentModel model = (DeploymentModel)this.m_models.get(name);
        if (model == null && this.m_logger != null) {
            this.m_logger.debug("Can't find '" + name + "' in model repository: " + this.m_models);
        }
        return model;
    }
}

