/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.util.ArrayList;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelSelector;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

class DefaultModelSelector
implements ModelSelector {
    DefaultModelSelector() {
    }

    public DeploymentModel select(DeploymentModel[] models, DependencyDescriptor dependency) {
        DeploymentModel[] candidates = this.filterCandidateProviders(models, dependency);
        return this.select(candidates);
    }

    public DeploymentModel select(DeploymentModel[] models, StageDescriptor stage) {
        DeploymentModel[] candidates = this.filterCandidateProviders(models, stage);
        return this.select(candidates);
    }

    public DeploymentModel select(DeploymentModel[] models, ReferenceDescriptor reference) {
        DeploymentModel[] candidates = this.filterCandidateProviders(models, reference);
        return this.select(candidates);
    }

    private DeploymentModel[] filterCandidateProviders(DeploymentModel[] models, ReferenceDescriptor reference) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        for (int i = 0; i < models.length; ++i) {
            DeploymentModel model = models[i];
            if (!model.isaCandidate(reference)) continue;
            list.add(model);
        }
        return list.toArray(new DeploymentModel[0]);
    }

    private DeploymentModel[] filterCandidateProviders(DeploymentModel[] models, DependencyDescriptor dependency) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        for (int i = 0; i < models.length; ++i) {
            DeploymentModel model = models[i];
            if (!model.isaCandidate(dependency)) continue;
            list.add(model);
        }
        return list.toArray(new DeploymentModel[0]);
    }

    private DeploymentModel[] filterCandidateProviders(DeploymentModel[] models, StageDescriptor stage) {
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        for (int i = 0; i < models.length; ++i) {
            DeploymentModel model = models[i];
            if (!model.isaCandidate(stage)) continue;
            list.add(model);
        }
        return list.toArray(new DeploymentModel[0]);
    }

    private DeploymentModel select(DeploymentModel[] models) {
        int i;
        if (models.length == 0) {
            return null;
        }
        for (i = 0; i < models.length; ++i) {
            if (!models[i].getMode().equals((Object)Mode.EXPLICIT)) continue;
            return models[i];
        }
        for (i = 0; i < models.length; ++i) {
            if (!models[i].getMode().equals((Object)Mode.PACKAGED)) continue;
            return models[i];
        }
        for (i = 0; i < models.length; ++i) {
            if (!models[i].getMode().equals((Object)Mode.IMPLICIT)) continue;
            return models[i];
        }
        return null;
    }
}

