/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.Permissions;
import org.apache.avalon.composition.data.SecurityProfile;
import org.apache.avalon.composition.provider.SecurityModel;
import org.apache.avalon.composition.provider.SystemRuntimeException;
import org.apache.avalon.meta.info.PermissionDescriptor;

public final class DefaultSecurityModel
implements SecurityModel {
    private static final Permission[] EMPTY_PERMISSIONS = new Permission[0];
    private final Permissions m_permissions;
    private final String m_name;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultSecurityModel;

    public DefaultSecurityModel() {
        this.m_permissions = new Permissions();
        this.m_name = "default";
    }

    public DefaultSecurityModel(SecurityProfile profile) {
        this.m_name = profile.getName();
        PermissionDescriptor[] permissions = profile.getPermissionDescriptors();
        this.m_permissions = this.buildPermissions(permissions);
    }

    public String getName() {
        return this.m_name;
    }

    public Permissions getPermissions() {
        return this.m_permissions;
    }

    private Permissions buildPermissions(PermissionDescriptor[] descriptors) throws SystemRuntimeException {
        Permissions permissions = new Permissions();
        for (int i = 0; i < descriptors.length; ++i) {
            PermissionDescriptor descriptor = descriptors[i];
            try {
                Permission permission = this.createPermission(descriptors[i]);
                permissions.add(permission);
                continue;
            }
            catch (Throwable e) {
                String error = "Invalid permission descriptor " + descriptor + ".";
                throw new SystemRuntimeException(error, e);
            }
        }
        return permissions;
    }

    private Permission createPermission(PermissionDescriptor descriptor) throws Exception {
        String classname = descriptor.getClassname();
        String name = descriptor.getName();
        String actions = this.getActions(descriptor);
        return DefaultSecurityModel.createPermission(classname, name, actions);
    }

    private String getActions(PermissionDescriptor descriptor) {
        String[] actions = descriptor.getActions();
        if (actions.length == 0) {
            return null;
        }
        String result = "";
        for (int i = 0; i < actions.length; ++i) {
            result = i > 0 ? result + "," + actions[i] : result + actions[i];
        }
        return result;
    }

    private static Permission createPermission(String classname, String name, String action) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ClassCastException, InvocationTargetException {
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        ClassLoader trustedClassloader = (class$org$apache$avalon$composition$model$impl$DefaultSecurityModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultSecurityModel = DefaultSecurityModel.class$("org.apache.avalon.composition.model.impl.DefaultSecurityModel")) : class$org$apache$avalon$composition$model$impl$DefaultSecurityModel).getClassLoader();
        Class<?> clazz = trustedClassloader.loadClass(classname);
        Constructor[] constructors = clazz.getConstructors();
        if (name == null) {
            return (Permission)clazz.newInstance();
        }
        if (action == null) {
            Constructor cons = DefaultSecurityModel.getConstructor(constructors, 1);
            Object[] arg = new Object[]{name};
            return (Permission)cons.newInstance(arg);
        }
        Constructor cons = DefaultSecurityModel.getConstructor(constructors, 2);
        Object[] args = new Object[]{name, action};
        return (Permission)cons.newInstance(args);
    }

    private static Constructor getConstructor(Constructor[] constructors, int noOfParameters) {
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] params = constructors[i].getParameterTypes();
            if (params.length != noOfParameters) continue;
            return constructors[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

