/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.composition.data.SecurityProfile;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.model.impl.DefaultSystemContext;
import org.apache.avalon.composition.provider.SecurityModel;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.composition.provider.SystemContextFactory;
import org.apache.avalon.composition.provider.SystemException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.logging.provider.LoggingCriteria;
import org.apache.avalon.logging.provider.LoggingFactory;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.provider.Builder;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultSystemContextFactory
implements SystemContextFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory == null ? (class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory = DefaultSystemContextFactory.class$("org.apache.avalon.composition.model.impl.DefaultSystemContextFactory")) : class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory));
    private final InitialContext m_context;
    private File m_home;
    private File m_temp;
    private File m_anchor;
    private Repository m_repository;
    private LoggingManager m_logging;
    private long m_timeout = 10000L;
    private SecurityModel m_security;
    private boolean m_trace = false;
    private Class m_runtime;
    private Artifact m_artifact;
    private Artifact m_lifestyle;
    private String m_name = "system";
    private SecurityProfile[] m_profiles;
    private Map m_grants;
    private Context m_parent;
    private boolean m_secure = false;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory;
    static /* synthetic */ Class class$org$apache$avalon$logging$provider$LoggingManager;

    public DefaultSystemContextFactory(InitialContext context) {
        this.m_context = context;
    }

    public void setSecurityEnabled(boolean secure) {
        this.m_secure = secure;
    }

    public void setParentContext(Context parent) {
        this.m_parent = parent;
    }

    public void setRuntime(Artifact artifact) {
        this.m_artifact = artifact;
    }

    public void setLifestyleArtifact(Artifact artifact) {
        this.m_lifestyle = artifact;
    }

    public void setRuntime(Class clazz) {
        this.m_runtime = clazz;
    }

    public void setRepository(Repository repository) {
        this.m_repository = repository;
    }

    public void setLoggingManager(LoggingManager logging) {
        this.m_logging = logging;
    }

    public void setDefaultDeploymentTimeout(long timeout) {
        this.m_timeout = timeout;
    }

    public void setTraceEnabled(boolean trace) {
        this.m_trace = trace;
    }

    public void setSecurityModel(SecurityModel security) {
        this.m_security = security;
    }

    public void setWorkingDirectory(File work) {
        this.m_home = work;
    }

    public void setTemporaryDirectory(File temp) {
        this.m_temp = temp;
    }

    public void setAnchorDirectory(File anchor) {
        this.m_anchor = anchor;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSecurityProfiles(SecurityProfile[] profiles) {
        this.m_profiles = profiles;
    }

    public void setGrantsTable(Map grants) {
        this.m_grants = grants;
    }

    public SystemContext createSystemContext() throws SystemException {
        return new DefaultSystemContext(this.m_context, this.getParentContext(), this.getRuntimeArtifact(), this.getLifestyleArtifact(), this.getRuntimeClass(), this.getLoggingManager(), this.getBaseDirectory(), this.getHomeDirectory(), this.getTempDirectory(), this.getAnchorDirectory(), this.getRepository(), this.getName(), this.isTraceEnabled(), this.getDefaultDeploymentTimeout(), this.getSecurityEnabled(), this.getSecurityProfiles(), this.getGrantsTable());
    }

    public boolean getSecurityEnabled() {
        return this.m_secure;
    }

    public Context getParentContext() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public Map getGrantsTable() {
        if (null == this.m_grants) {
            return new Hashtable();
        }
        return this.m_grants;
    }

    public SecurityProfile[] getSecurityProfiles() {
        if (null != this.m_profiles) {
            return this.m_profiles;
        }
        return new SecurityProfile[0];
    }

    public File getBaseDirectory() {
        return this.m_context.getInitialWorkingDirectory();
    }

    public File getHomeDirectory() {
        if (null != this.m_home) {
            return this.m_home;
        }
        return new File(this.getBaseDirectory(), "home");
    }

    public File getTempDirectory() {
        if (null != this.m_temp) {
            return this.m_temp;
        }
        return new File(this.getBaseDirectory(), "temp");
    }

    public File getAnchorDirectory() {
        if (null != this.m_anchor) {
            return this.m_anchor;
        }
        return this.getBaseDirectory();
    }

    public Repository getRepository() {
        if (null != this.m_repository) {
            return this.m_repository;
        }
        return this.m_context.getRepository();
    }

    public boolean isTraceEnabled() {
        return this.m_trace;
    }

    public LoggingManager getLoggingManager() {
        if (null != this.m_logging) {
            return this.m_logging;
        }
        return this.createLoggingManager();
    }

    public long getDefaultDeploymentTimeout() {
        return this.m_timeout;
    }

    public Class getRuntimeClass() {
        return this.m_runtime;
    }

    public Artifact getRuntimeArtifact() {
        return this.m_artifact;
    }

    public Artifact getLifestyleArtifact() {
        return this.m_lifestyle;
    }

    private LoggingManager createLoggingManager() {
        boolean trace = this.isTraceEnabled();
        try {
            return DefaultSystemContextFactory.createLoggingManager(this.m_context, null, null, null, trace);
        }
        catch (Throwable e) {
            String error = "Cannot create logging manager due to a construction error.";
            throw new ModelRuntimeException("Cannot create logging manager due to a construction error.", e);
        }
    }

    public static LoggingManager createLoggingManager(InitialContext context, Artifact artifact, File dir, URL path, boolean trace) throws Exception {
        DefaultSystemContextFactory.assertNotNull(context, "context");
        Artifact implementation = DefaultSystemContextFactory.locateArtifact(context, class$org$apache$avalon$logging$provider$LoggingManager == null ? (class$org$apache$avalon$logging$provider$LoggingManager = DefaultSystemContextFactory.class$("org.apache.avalon.logging.provider.LoggingManager")) : class$org$apache$avalon$logging$provider$LoggingManager, artifact);
        File basedir = DefaultSystemContextFactory.getBaseDirectory(context, dir);
        ClassLoader classloader = (class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory == null ? (class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory = DefaultSystemContextFactory.class$("org.apache.avalon.composition.model.impl.DefaultSystemContextFactory")) : class$org$apache$avalon$composition$model$impl$DefaultSystemContextFactory).getClassLoader();
        Builder builder = context.newBuilder(classloader, implementation);
        LoggingFactory factory = (LoggingFactory)builder.getFactory();
        LoggingCriteria params = factory.createDefaultLoggingCriteria();
        params.setBaseDirectory(basedir);
        params.setLoggingConfiguration(path);
        params.setDebugEnabled(trace);
        return factory.createLoggingManager(params);
    }

    private static Artifact locateArtifact(InitialContext context, Class clazz, Artifact artifact) {
        if (null != artifact) {
            return artifact;
        }
        return DefaultSystemContextFactory.locateArtifact(context, clazz);
    }

    private static Artifact locateArtifact(InitialContext context, Class clazz) throws IllegalStateException {
        DefaultSystemContextFactory.assertNotNull(context, "context");
        DefaultSystemContextFactory.assertNotNull(clazz, "clazz");
        Artifact[] artifacts = context.getRepository().getCandidates(clazz);
        if (artifacts.length < 1) {
            String error = "No factory registered for the class [" + clazz.getName() + "].";
            throw new IllegalStateException(error);
        }
        return artifacts[0];
    }

    private static void assertNotNull(Object object, String key) throws NullPointerException {
        if (null == object) {
            throw new NullPointerException(key);
        }
    }

    private static File getBaseDirectory(InitialContext context, File dir) {
        if (null != dir) {
            return dir;
        }
        return context.getInitialWorkingDirectory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

