/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.composition.model.FileSelector;
import org.apache.avalon.composition.model.impl.DefaultFileSelector;
import org.apache.avalon.composition.util.FileUtils;
import org.apache.avalon.composition.util.ScannerUtils;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.util.env.Env;

public class DirectoryScanner {
    private static final boolean ON_VMS = Env.isOpenVMS();
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static Vector defaultExcludes = new Vector();
    private File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected FileSelector[] selectors = null;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    private static final FileUtils fileUtils;
    protected boolean everythingIncluded = true;
    private Logger m_logger;
    private Map fileListMap = new HashMap();
    private Set scannedDirs = new HashSet();

    protected static boolean matchPatternStart(String pattern, String str) {
        return ScannerUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return ScannerUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return ScannerUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return ScannerUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return ScannerUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return ScannerUtils.match(pattern, str, isCaseSensitive);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
        }
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                String pattern = includes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.includes[i] = pattern;
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                String pattern = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.excludes[i] = pattern;
            }
        }
    }

    public void setSelectors(FileSelector[] selectors) {
        this.selectors = selectors;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException, IOException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            System.out.println("basedir=[" + this.basedir + "]");
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "*.jar";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        if (this.selectors == null) {
            this.selectors = new FileSelector[1];
            this.selectors[0] = new DefaultFileSelector();
        }
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.checkIncludePatterns();
        this.clearCaches();
    }

    private void checkIncludePatterns() throws IOException {
        Hashtable<String, String> newroots = new Hashtable<String, String>();
        for (int icounter = 0; icounter < this.includes.length; ++icounter) {
            String newpattern = ScannerUtils.rtrimWildcardTokens(this.includes[icounter]);
            newroots.put(newpattern, this.includes[icounter]);
            this.getLogger().debug("newpattern=[" + newpattern + "]; " + "includes[" + icounter + "]=[" + this.includes[icounter] + "]");
        }
        if (newroots.containsKey("")) {
            this.scandir(this.basedir, "", true);
        } else {
            Enumeration enum2 = newroots.keys();
            File canonBase = null;
            canonBase = this.basedir.getCanonicalFile();
            this.getLogger().debug("canonBase=[" + canonBase + "]");
            while (enum2.hasMoreElements()) {
                File f;
                File canonFile;
                String path;
                String currentelement = (String)enum2.nextElement();
                this.getLogger().debug("currentelement=[" + currentelement + "]");
                String originalpattern = (String)newroots.get(currentelement);
                this.getLogger().debug("originalpattern=[" + originalpattern + "]");
                File myfile = new File(this.basedir, currentelement);
                this.getLogger().debug("myfile=[" + myfile.getAbsolutePath() + "]");
                if (myfile.exists() && (!(path = fileUtils.removeLeadingPath(canonBase, canonFile = myfile.getCanonicalFile())).equals(currentelement) || ON_VMS) && null != (myfile = this.findFile(this.basedir, currentelement))) {
                    currentelement = fileUtils.removeLeadingPath(this.basedir, myfile);
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive || !(f = this.findFileCaseInsensitive(this.basedir, currentelement)).exists())) {
                    currentelement = fileUtils.removeLeadingPath(this.basedir, f);
                    myfile = f;
                }
                if (myfile == null || !myfile.exists() || !this.followSymlinks && this.isSymlink(this.basedir, currentelement)) continue;
                if (myfile.isDirectory()) {
                    this.getLogger().debug("file is a directory!");
                    if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                        this.getLogger().debug("calling accounForIncludedDir(" + currentelement + "," + myfile.getAbsolutePath() + ")");
                        this.accountForIncludedDir(currentelement, myfile, true);
                        continue;
                    }
                    if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                        currentelement = currentelement + File.separatorChar;
                    }
                    this.getLogger().debug("calling scandir(" + myfile.getAbsolutePath() + "," + currentelement + ")");
                    this.scandir(myfile, currentelement, true);
                    continue;
                }
                if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                    this.accountForIncludedFile(currentelement, myfile);
                    continue;
                }
                if (this.isCaseSensitive || !originalpattern.equalsIgnoreCase(currentelement)) continue;
                this.accountForIncludedFile(currentelement, myfile);
            }
        }
    }

    protected void scandir(File dir, String vpath, boolean fast) throws IOException {
        this.getLogger().debug("Inside scandir");
        if (dir == null) {
            throw new IOException("dir must not be null.");
        }
        if (!dir.exists()) {
            throw new IOException(dir + " doesn't exists.");
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir + " is not a directory.");
        }
        if (fast && this.hasBeenScanned(vpath)) {
            return;
        }
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            throw new IOException("IO error scanning directory " + dir.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            Vector<Object> noLinks = new Vector<Object>();
            for (int i = 0; i < newfiles.length; ++i) {
                try {
                    if (fileUtils.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + (String)newfiles[i];
                        File file = new File(dir, (String)newfiles[i]);
                        if (file.isDirectory()) {
                            this.dirsExcluded.addElement(name);
                            continue;
                        }
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    noLinks.addElement(newfiles[i]);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.addElement(newfiles[i]);
                }
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        for (int i = 0; i < newfiles.length; ++i) {
            String name = vpath + newfiles[i];
            File file = new File(dir, (String)newfiles[i]);
            this.getLogger().debug("file=[" + file.getAbsolutePath() + "]");
            if (file.isDirectory()) {
                this.getLogger().debug("this is a directory.");
                if (this.isIncluded(name)) {
                    this.getLogger().debug("and it will be included");
                    this.accountForIncludedDir(name, file, fast);
                } else {
                    this.getLogger().debug("and it will not be included");
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandir(file, name + File.separator, fast);
                    }
                }
                if (fast) continue;
                this.scandir(file, name + File.separator, fast);
                continue;
            }
            if (!file.isFile()) continue;
            this.getLogger().debug("this is a file");
            if (this.isIncluded(name)) {
                this.getLogger().debug("and it will be included");
                this.accountForIncludedFile(name, file);
                continue;
            }
            this.getLogger().debug("and it will not be included");
            this.everythingIncluded = false;
            this.filesNotIncluded.addElement(name);
        }
    }

    private void accountForIncludedFile(String name, File file) {
        if (!(this.filesIncluded.contains(name) || this.filesExcluded.contains(name) || this.filesDeselected.contains(name))) {
            if (!this.isExcluded(name)) {
                if (this.isSelected(name, file)) {
                    this.filesIncluded.addElement(name);
                } else {
                    this.everythingIncluded = false;
                    this.filesDeselected.addElement(name);
                }
            } else {
                this.everythingIncluded = false;
                this.filesExcluded.addElement(name);
            }
        }
    }

    private void accountForIncludedDir(String name, File file, boolean fast) throws IOException {
        this.getLogger().debug("Inside accountForIncludeDir");
        if (!(this.dirsIncluded.contains(name) || this.dirsExcluded.contains(name) || this.dirsDeselected.contains(name))) {
            this.getLogger().debug("waypoint-1");
            if (!this.isExcluded(name)) {
                this.getLogger().debug("waypoint-2a");
                if (this.isSelected(name, file)) {
                    this.getLogger().debug("waypoint-3a");
                    this.dirsIncluded.addElement(name);
                    if (fast) {
                        this.getLogger().debug("calling scandir(" + file.getAbsolutePath() + "," + name + File.separator);
                        this.scandir(file, name + File.separator, fast);
                    }
                } else {
                    this.getLogger().debug("waypoint-3b");
                    this.everythingIncluded = false;
                    this.dirsDeselected.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.getLogger().debug("waypoint-4b");
                        this.scandir(file, name + File.separator, fast);
                    }
                }
            } else {
                this.getLogger().debug("waypoint-2b");
                this.everythingIncluded = false;
                this.dirsExcluded.addElement(name);
                if (fast && this.couldHoldIncluded(name)) {
                    this.getLogger().debug("waypoint-3c");
                    this.scandir(file, name + File.separator, fast);
                }
            }
        }
    }

    protected boolean isIncluded(String name) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!DirectoryScanner.matchPath(this.includes[i], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!DirectoryScanner.matchPatternStart(this.includes[i], name, this.isCaseSensitive) || !this.isMorePowerfulThanExcludes(name, this.includes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = name + File.separator + "**";
        for (int counter = 0; counter < this.excludes.length; ++counter) {
            if (!this.excludes[counter].equals(soughtexclude)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String name) {
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!DirectoryScanner.matchPath(this.excludes[i], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, name, file)) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getIncludedFiles() {
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    private String[] list(File file) {
        String[] files = (String[])this.fileListMap.get(file);
        if (files == null && (files = file.list()) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    private File findFileCaseInsensitive(File base, String path) throws IOException {
        File f = this.findFileCaseInsensitive(base, ScannerUtils.tokenizePath(path));
        return f == null ? new File(base, path) : f;
    }

    private File findFileCaseInsensitive(File base, Vector pathElements) throws IOException {
        int i;
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new IOException("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = (String)pathElements.remove(0);
        for (i = 0; i < files.length; ++i) {
            if (!files[i].equals(current)) continue;
            base = new File(base, files[i]);
            return this.findFileCaseInsensitive(base, pathElements);
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].equalsIgnoreCase(current)) continue;
            base = new File(base, files[i]);
            return this.findFileCaseInsensitive(base, pathElements);
        }
        return null;
    }

    private File findFile(File base, String path) throws IOException {
        return this.findFile(base, ScannerUtils.tokenizePath(path));
    }

    private File findFile(File base, Vector pathElements) throws IOException {
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new IOException("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = (String)pathElements.remove(0);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(current)) continue;
            base = new File(base, files[i]);
            return this.findFile(base, pathElements);
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, ScannerUtils.tokenizePath(path));
    }

    private boolean isSymlink(File base, Vector pathElements) {
        if (pathElements.size() > 0) {
            String current = (String)pathElements.remove(0);
            try {
                if (fileUtils.isSymbolicLink(base, current)) {
                    return true;
                }
                base = new File(base, current);
                return this.isSymlink(base, pathElements);
            }
            catch (IOException ioe) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
                return false;
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    private void clearCaches() {
        this.fileListMap.clear();
        this.scannedDirs.clear();
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("{basedir=[" + this.basedir.getAbsolutePath() + "];");
        buffer.append("isCaseSensitive=[" + this.isCaseSensitive + "];");
        buffer.append("includes=(");
        for (i = 0; i < this.includes.length; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(this.includes[i]);
        }
        buffer.append(");");
        buffer.append("excludes=(");
        for (i = 0; i < this.excludes.length; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(this.excludes[i]);
        }
        buffer.append(")}");
        return buffer.toString();
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
        fileUtils = FileUtils.newFileUtils();
    }
}

