/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.avalon.composition.data.builder.ProfilePackageBuilder;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.builder.ServiceBuilder;
import org.apache.avalon.meta.info.builder.TypeBuilder;
import org.apache.avalon.meta.info.verifier.TypeVerifier;
import org.apache.avalon.util.exception.ExceptionHelper;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

class Scanner
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$Scanner == null ? (class$org$apache$avalon$composition$model$impl$Scanner = Scanner.class$("org.apache.avalon.composition.model.impl.Scanner")) : class$org$apache$avalon$composition$model$impl$Scanner));
    private static final String X_INFO = ".xinfo";
    private static final String X_TYPE = ".xtype";
    private static final String X_SERVICE = ".xservice";
    private static final String X_PROFILE = ".xprofile";
    private static final TypeBuilder TYPE_BUILDER = new TypeBuilder();
    private static final ServiceBuilder SERVICE_BUILDER = new ServiceBuilder();
    private static final ProfilePackageBuilder PACKAGE_BUILDER = new ProfilePackageBuilder();
    private ClassLoader m_classloader;
    private SystemContext m_system;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$Scanner;

    public Scanner(Logger logger, SystemContext system, ClassLoader classloader) {
        if (classloader == null) {
            throw new NullPointerException("classloader");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.m_classloader = classloader;
        this.m_system = system;
        this.enableLogging(logger);
    }

    public void scan(URL[] urls, List types, List services) throws ModelException {
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            this.scanURL(url, types, services);
        }
    }

    private void scanURL(URL url, List types, List services) throws ModelException {
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("scanner.scanning", (Object)this.m_system.toString((Object)url.toString()));
            this.getLogger().debug(message);
        }
        if (this.isDirectory(url)) {
            this.scanDirectory(url, types, services);
        } else if (url.getProtocol().equals("jar") || url.getProtocol().equals("file") && url.toString().endsWith(".jar")) {
            this.scanJarFileURL(url, types, services);
        } else {
            this.scanInputStream(url, types, services);
        }
    }

    private void scanDirectory(URL url, List types, List services) throws ModelException {
        try {
            File directory = this.getDirectory(url);
            this.scanDirectoryContent(directory, directory, types, services);
        }
        catch (Throwable e) {
            String error = REZ.getString("scanner.dir-scan.error", (Object)url.toString());
            throw new ModelException(error, e);
        }
    }

    private void scanJarFileURL(URL url, List types, List services) throws ModelException {
        URL uri = url;
        try {
            if (!url.getProtocol().equals("jar")) {
                uri = this.getJarURL(url);
            }
            if (!uri.toString().endsWith("!/")) {
                String error = REZ.getString("scanner.nested-jar-unsupported.error", (Object)url.toString());
                throw new ModelException(error);
            }
            JarURLConnection jar = (JarURLConnection)uri.openConnection();
            JarFile base = jar.getJarFile();
            this.scanJarFile(base, types, services);
        }
        catch (Throwable e) {
            String error = REZ.getString("scanner.jar.error", (Object)url.toString());
            throw new ModelException(error, e);
        }
    }

    private void scanJarFile(JarFile base, List types, List services) throws Exception {
        Enumeration<JarEntry> entries = base.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(X_TYPE) || name.endsWith(X_INFO)) {
                this.addType(types, name);
                continue;
            }
            if (!name.endsWith(X_SERVICE)) continue;
            this.addService(services, name);
        }
    }

    private void scanInputStream(URL url, List types, List services) {
        block4: {
            try {
                InputStream object = url.openStream();
                if (object != null) {
                    JarInputStream stream = new JarInputStream(object);
                    this.scanJarInputStream(stream, types, services);
                    return;
                }
                if (this.getLogger().isWarnEnabled()) {
                    String warning = REZ.getString("scanner.stream.unrecognized-content.warning", (Object)url.toString());
                    this.getLogger().warn(warning);
                }
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                String error = REZ.getString("scanner.stream.content.error", (Object)url.toString());
                String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)this.getLogger().isDebugEnabled());
                this.getLogger().warn(warning);
            }
        }
    }

    private void scanJarInputStream(JarInputStream stream, List types, List services) throws Exception {
        ZipEntry entry = null;
        try {
            entry = stream.getNextEntry();
        }
        catch (Throwable e) {
            entry = null;
        }
        while (entry != null) {
            String name = entry.getName();
            if (name.endsWith(X_TYPE) || name.endsWith(X_INFO)) {
                this.addType(types, name);
            } else if (name.endsWith(X_SERVICE)) {
                this.addService(services, name);
            }
            try {
                entry = stream.getNextEntry();
            }
            catch (Throwable e) {
                entry = null;
            }
        }
    }

    private void scanDirectoryContent(File base, File dir, List types, List services) throws Exception {
        File[] files = dir.listFiles();
        String path = base.toString();
        int j = path.length();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.scanDirectoryContent(base, file, types, services);
                continue;
            }
            this.scanFile(j, file, types, services);
        }
    }

    private void scanFile(int j, File file, List types, List services) throws Exception {
        String filename = file.toString();
        String name = filename.substring(j, filename.length());
        if (name.endsWith(X_TYPE) || name.endsWith(X_INFO)) {
            this.addType(types, name);
        } else if (name.endsWith(X_SERVICE)) {
            this.addService(services, name);
        }
    }

    private void addType(List types, String name) throws Exception {
        block5: {
            String classname = this.parseResourceName(name);
            Class clazz = this.getComponentClass(classname);
            Type type = TYPE_BUILDER.buildType(clazz);
            try {
                this.verifyType(type, clazz);
                if (this.getLogger().isDebugEnabled()) {
                    String message = REZ.getString("scanner.type.addition", (Object)classname);
                    this.getLogger().debug(message);
                }
                types.add(type);
            }
            catch (NoClassDefFoundError e) {
                if (this.getLogger().isWarnEnabled()) {
                    String error = REZ.getString("scanner.type.verification.ncdf.failure", (Object)classname, (Object)e.getMessage());
                    this.getLogger().warn(error);
                }
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) break block5;
                String error = REZ.getString("scanner.type.verification.failure", (Object)classname);
                this.getLogger().warn(ExceptionHelper.packException((String)error, (Throwable)e, (boolean)this.getLogger().isDebugEnabled()));
            }
        }
    }

    private void addService(List list, String name) throws Exception {
        block3: {
            String classname = this.parseResourceName(name);
            Service service = SERVICE_BUILDER.build(classname, this.m_classloader);
            try {
                this.verifyService(service);
                if (this.getLogger().isDebugEnabled()) {
                    String message = REZ.getString("scanner.service.addition", (Object)classname);
                    this.getLogger().debug(message);
                }
                list.add(service);
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                String error = REZ.getString("scanner.service.verification.failure", (Object)classname);
                this.getLogger().warn(ExceptionHelper.packException((String)error, (Throwable)e, (boolean)this.getLogger().isDebugEnabled()));
            }
        }
    }

    private void verifyType(Type type, Class clazz) throws Exception {
        String name = type.getInfo().getName();
        Class[] classes = this.getServiceClasses(type);
        TypeVerifier verifier = new TypeVerifier();
        verifier.verifyType(name, clazz, classes);
    }

    private void verifyService(Service service) throws Exception {
        String classname = service.getClassname();
        try {
            this.m_classloader.loadClass(classname);
        }
        catch (NoClassDefFoundError ncdf) {
            String ref = this.parseResourceName(ncdf.getMessage());
            String error = REZ.getString("scanner.service.bad-class.error", (Object)classname, (Object)ref);
            throw new ModelException(error);
        }
        catch (ClassNotFoundException cnfe) {
            String error = REZ.getString("scanner.service.missing-class.error", (Object)classname);
            throw new ModelException(error);
        }
    }

    private Class[] getServiceClasses(Type type) throws ModelException {
        ArrayList<Class> list = new ArrayList<Class>();
        ServiceDescriptor[] services = type.getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (!service.getAttribute("urn:avalon:service.protocol", "native").equals("native") || service.getAttribute("urn:avalon:service.accessor", null) != null) continue;
            list.add(this.getServiceClass(services[i]));
        }
        return list.toArray(new Class[0]);
    }

    private Class getComponentClass(Type type) throws ModelException {
        if (null == type) {
            throw new NullPointerException("type");
        }
        return this.getComponentClass(type.getInfo().getClassname());
    }

    private Class getComponentClass(String classname) throws ModelException {
        try {
            return this.m_classloader.loadClass(classname);
        }
        catch (NoClassDefFoundError ncdf) {
            String ref = this.parseResourceName(ncdf.getMessage());
            String error = REZ.getString("scanner.type.bad-class.error", (Object)classname, (Object)ref);
            throw new ModelException(error);
        }
        catch (ClassNotFoundException cnfe) {
            String error = REZ.getString("scanner.type.missing-class.error", (Object)classname);
            throw new ModelException(error);
        }
    }

    private Class getServiceClass(ServiceDescriptor service) throws ModelException {
        String classname = service.getReference().getClassname();
        try {
            return this.m_classloader.loadClass(classname);
        }
        catch (NoClassDefFoundError ncdf) {
            String ref = this.parseResourceName(ncdf.getMessage());
            String error = REZ.getString("scanner.service.bad-class.error", (Object)classname, (Object)ref);
            throw new ModelException(error);
        }
        catch (ClassNotFoundException cnfe) {
            String error = REZ.getString("scanner.service.missing-class.error", (Object)classname);
            throw new ModelException(error);
        }
    }

    private boolean isDirectory(URL url) {
        if (url.getProtocol().equals("file")) {
            return this.getFile(url).isDirectory();
        }
        return false;
    }

    private File getDirectory(URL url) throws IllegalArgumentException {
        File file = this.getFile(url);
        if (file.isDirectory()) {
            return file;
        }
        String error = REZ.getString("scanner.url-not-a-directory.error", (Object)url.toString());
        throw new IllegalArgumentException(error);
    }

    private File getFile(URL url) throws IllegalArgumentException {
        if (url.getProtocol().equals("file")) {
            return new File(url.toString().substring(5));
        }
        String error = REZ.getString("scanner.not-file-protocol.error", (Object)url.toString());
        throw new IllegalArgumentException(error);
    }

    private String parseResourceName(String resource) {
        try {
            int i = resource.lastIndexOf(".");
            String name = resource.substring(0, i);
            String name2 = name.replace('/', '.');
            String name3 = name2.replace('\\', '.');
            if (name3.startsWith(".")) {
                return name3.substring(1, name3.length());
            }
            return name3;
        }
        catch (Throwable e) {
            return resource;
        }
    }

    private URL getJarURL(URL url) throws MalformedURLException {
        if (url.getProtocol().equals("jar")) {
            return url;
        }
        return new URL("jar:" + url.toString() + "!/");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

