/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.util;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.avalon.util.env.Env;

public class FileUtils {
    private boolean onNetWare = Env.isNetWare();

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    protected FileUtils() {
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File resolvedParent = new File(parent.getCanonicalPath());
        File toTest = new File(resolvedParent, name);
        return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    public String removeLeadingPath(File leading, File path) throws IOException {
        String p;
        String l = this.normalize(leading.getAbsolutePath()).getAbsolutePath();
        if (l.equals(p = this.normalize(path.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        if (p.startsWith(l)) {
            return p.substring(l.length());
        }
        return p;
    }

    public File normalize(String path) throws IOException {
        int i;
        String orig = path;
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!this.onNetWare) {
            if (!(path.startsWith(File.separator) || path.length() >= 2 && Character.isLetter(path.charAt(0)) && colon == 1)) {
                String msg = path + " is not an absolute path";
                throw new IOException(msg);
            }
        } else if (!path.startsWith(File.separator) && colon == -1) {
            String msg = path + " is not an absolute path";
            throw new IOException(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (!this.onNetWare && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || this.onNetWare && colon > -1) {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            for (int i2 = 0; i2 < colon; ++i2) {
                sbRoot.append(Character.toUpperCase(ca[i2]));
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            for (i = colon + 1; i < ca.length; ++i) {
                if (ca[i] == '\\' && (ca[i] != '\\' || ca[i - 1] == '\\')) continue;
                sbPath.append(ca[i]);
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        } else if (path.length() == 1) {
            root = File.separator;
            path = "";
        } else if (path.charAt(1) == File.separatorChar) {
            root = File.separator + File.separator;
            path = path.substring(2);
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        Stack<String> s = new Stack<String>();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new IOException("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return new File(path);
    }
}

