/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.builder;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.logging.data.CategoriesDirective;
import org.apache.avalon.logging.data.CategoryDirective;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.excalibur.configuration.ConfigurationUtil;

public abstract class XMLProfileCreator {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$data$builder$XMLProfileCreator == null ? (class$org$apache$avalon$composition$data$builder$XMLProfileCreator = XMLProfileCreator.class$("org.apache.avalon.composition.data.builder.XMLProfileCreator")) : class$org$apache$avalon$composition$data$builder$XMLProfileCreator));
    static /* synthetic */ Class class$org$apache$avalon$composition$data$builder$XMLProfileCreator;

    protected String getName(String base, Configuration config, String defaultName) {
        String name = config.getAttribute("name", defaultName);
        if (base == null) {
            return name;
        }
        return base + "-" + name;
    }

    protected int getActivationDirective(Configuration config) {
        return this.getActivationDirective(config, -1);
    }

    protected int getActivationDirective(Configuration config, int fallback) {
        String value = config.getAttribute("activation", null);
        if (value == null) {
            return fallback;
        }
        String string = value.toLowerCase().trim();
        if (string.equals("startup") || string.equals("true")) {
            return 1;
        }
        if (string.equals("lazy") || string.equals("false")) {
            return 0;
        }
        return -1;
    }

    public CategoriesDirective getCategoriesDirective(Configuration config) throws ConfigurationException {
        if (null == config) {
            return null;
        }
        String name = config.getAttribute("name", ".");
        String priority = config.getAttribute("priority", null);
        String target = config.getAttribute("target", null);
        Configuration[] children = config.getChildren();
        CategoryDirective[] categories = this.getCategoryDirectives(children);
        return new CategoriesDirective(name, priority, target, categories);
    }

    public CategoryDirective getCategoryDirective(Configuration config) throws ConfigurationException {
        try {
            String name = config.getAttribute("name");
            String priority = config.getAttribute("priority", null);
            String target = config.getAttribute("target", null);
            return new CategoryDirective(name, priority, target);
        }
        catch (ConfigurationException e) {
            String error = "Invalid category descriptor." + ConfigurationUtil.list((Configuration)config);
            throw new ConfigurationException(error, (Throwable)e);
        }
    }

    private CategoryDirective[] getCategoryDirectives(Configuration[] children) throws ConfigurationException {
        CategoryDirective[] categories = new CategoryDirective[children.length];
        for (int i = 0; i < children.length; ++i) {
            Configuration config = children[i];
            String name = config.getName();
            if (name.equals("category")) {
                categories[i] = this.getCategoryDirective(config);
                continue;
            }
            if (name.equals("categories")) {
                categories[i] = this.getCategoriesDirective(config);
                continue;
            }
            String error = "Nested element [" + name + "] not recognized.";
            throw new ConfigurationException(error);
        }
        return categories;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

