/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.builder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avalon.composition.data.SecurityProfile;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.meta.info.PermissionDescriptor;

public final class XMLSecurityProfileBuilder {
    public SecurityProfile[] createSecurityProfiles(Configuration config) throws Exception {
        Configuration[] configs = config.getChildren("profile");
        SecurityProfile[] profiles = new SecurityProfile[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            SecurityProfile profile;
            Configuration conf = configs[i];
            profiles[i] = profile = this.createSecurityProfile(conf);
        }
        return profiles;
    }

    public SecurityProfile createSecurityProfile(Configuration config) throws Exception {
        String name = config.getAttribute("name");
        Configuration conf = config.getChild("permissions");
        PermissionDescriptor[] permissions = this.buildPermissions(conf);
        return new SecurityProfile(name, permissions);
    }

    private PermissionDescriptor[] buildPermissions(Configuration config) throws ConfigurationException {
        ArrayList list = new ArrayList();
        Configuration[] children = config.getChildren("permission");
        PermissionDescriptor[] permissions = new PermissionDescriptor[children.length];
        for (int i = 0; i < children.length; ++i) {
            PermissionDescriptor permission;
            permissions[i] = permission = this.buildPermission(children[i]);
        }
        return permissions;
    }

    private PermissionDescriptor buildPermission(Configuration config) throws ConfigurationException {
        String classname = config.getAttribute("class");
        String name = config.getAttribute("name", null);
        ArrayList list = new ArrayList();
        Configuration[] children = config.getChildren("action");
        String[] actions = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            String action;
            Configuration child = children[i];
            actions[i] = action = child.getValue();
        }
        return new PermissionDescriptor(classname, name, actions);
    }

    private Certificate[] createCertificates(Configuration config) throws Exception {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            int j;
            Certificate[] certs;
            Configuration child = children[i];
            String name = child.getName();
            if (name.equals("pkcs7")) {
                certs = this.createPKCS7(child);
                for (j = 0; j < certs.length; ++j) {
                    list.add(certs[j]);
                }
                continue;
            }
            if (name.equals("x509")) {
                certs = this.createX509(child);
                for (j = 0; j < certs.length; ++j) {
                    list.add(certs[j]);
                }
                continue;
            }
            String error = "Unrecognized certificate type [" + name + "].";
            throw new ConfigurationException(error);
        }
        return list.toArray(new Certificate[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] createPKCS7(Configuration config) throws Exception {
        String href = config.getAttribute("href");
        InputStream in = null;
        try {
            URL url = new URL(href);
            in = url.openStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(in);
            Certificate[] certificates = new Certificate[certs.size()];
            Certificate[] certificateArray = certs.toArray(certificates);
            return certificateArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] createX509(Configuration config) throws ConfigurationException, CertificateException, IOException {
        String href = config.getAttribute("href", "");
        String data = config.getValue();
        InputStream in = null;
        try {
            if (href == null || "".equals(href)) {
                in = new ByteArrayInputStream(data.getBytes("UTF-8"));
            } else {
                URL url = new URL(href);
                in = url.openStream();
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(in);
            Certificate[] certificates = new Certificate[certs.size()];
            Certificate[] certificateArray = certs.toArray(certificates);
            return certificateArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

