/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.impl.CommissionRequest;
import org.apache.avalon.composition.model.impl.SimpleFIFO;
import org.apache.avalon.framework.logger.Logger;

class Commissioner
implements Runnable {
    private static int m_ThreadCounter = 0;
    private final Logger m_logger;
    private final SimpleFIFO m_queue = new SimpleFIFO();
    private final String m_message;
    private final boolean m_flag;
    private Thread m_thread;

    Commissioner(Logger logger, boolean flag) {
        this.m_logger = logger;
        String name = "Commissioner [" + ++m_ThreadCounter + "]";
        this.m_flag = flag;
        this.m_message = flag ? "commissioning" : "decommissioning";
        this.m_thread = new Thread((Runnable)this, name);
        this.m_thread.start();
    }

    void commission(DeploymentModel model) throws Exception {
        if (null == model) {
            throw new NullPointerException("model");
        }
        if (null != this.m_thread) {
            if (this.m_logger.isDebugEnabled()) {
                if (model instanceof ContainmentModel) {
                    this.m_logger.debug(this.m_message + " container [" + model.getName() + "]");
                } else {
                    this.m_logger.debug(this.m_message + " component [" + model.getName() + "]");
                }
            }
            CommissionRequest request = new CommissionRequest(model, this.m_thread);
            this.m_queue.put(request);
            long t = request.waitForCompletion();
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug(this.m_message + " of [" + model.getName() + "] completed in " + t + " milliseconds");
            }
        } else {
            String warning = "Ignoring " + this.m_message + " request on a disposed commissioner.";
            this.m_logger.warn(warning);
        }
    }

    void dispose() {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("commissioner disposal");
        }
        if (null != this.m_thread) {
            this.m_thread.interrupt();
        }
    }

    public void run() {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug(this.m_message + " thread started");
        }
        block5: while (true) {
            try {
                while (true) {
                    CommissionRequest request = (CommissionRequest)this.m_queue.get();
                    DeploymentModel model = request.getDeploymentModel();
                    try {
                        if (this.m_flag) {
                            model.commission();
                        } else {
                            model.decommission();
                        }
                        request.done();
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        request.interrupted();
                        continue;
                    }
                    catch (Throwable e) {
                        request.exception(e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                this.m_thread = null;
                return;
            }
        }
    }
}

