/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.StageDirective;
import org.apache.avalon.composition.info.DeliveryDescriptor;
import org.apache.avalon.composition.info.StagedDeliveryDescriptor;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.composition.model.impl.DefaultContextModel;
import org.apache.avalon.composition.model.impl.DefaultDependencyModel;
import org.apache.avalon.composition.model.impl.DefaultDeploymentModel;
import org.apache.avalon.composition.model.impl.DefaultStageModel;
import org.apache.avalon.composition.model.impl.DefaultState;
import org.apache.avalon.composition.provider.ComponentContext;
import org.apache.avalon.composition.provider.DeploymentContext;
import org.apache.avalon.composition.provider.SecurityModel;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.excalibur.configuration.CascadingConfiguration;

public class DefaultComponentModel
extends DefaultDeploymentModel
implements ComponentModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultComponentModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultComponentModel = DefaultComponentModel.class$("org.apache.avalon.composition.model.impl.DefaultComponentModel")) : class$org$apache$avalon$composition$model$impl$DefaultComponentModel));
    private static final String CONTEXTUALIZABLE = "org.apache.avalon.framework.context.Contextualizable";
    private static final Configuration EMPTY_CONFIGURATION = new DefaultConfiguration("configuration", (class$org$apache$avalon$composition$model$ComponentModel == null ? (class$org$apache$avalon$composition$model$ComponentModel = DefaultComponentModel.class$("org.apache.avalon.composition.model.ComponentModel")) : class$org$apache$avalon$composition$model$ComponentModel).getName());
    private final ComponentContext m_context;
    private final ContextModel m_contextModel;
    private final DependencyModel[] m_dependencies;
    private final StageModel[] m_stages;
    private final DefaultState m_assembly = new DefaultState();
    private Configuration m_config;
    private Parameters m_parameters;
    private boolean m_activation;
    private int m_collection;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultComponentModel;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$ComponentModel;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameters;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configuration;

    public DefaultComponentModel(ComponentContext context, SecurityModel security) throws ModelException {
        super((DeploymentContext)context, security);
        this.m_context = context;
        this.m_activation = this.getDefaultActivationPolicy();
        this.setCollectionPolicy(this.m_context.getComponentProfile().getCollectionPolicy());
        ClassLoader classLoader = this.m_context.getClassLoader();
        if (this.isConfigurable()) {
            Configuration defaults = this.m_context.getType().getConfiguration();
            Configuration explicit = this.m_context.getComponentProfile().getConfiguration();
            Configuration consolidated = this.consolidateConfigurations(explicit, defaults);
            this.m_config = consolidated != null ? consolidated : EMPTY_CONFIGURATION;
        }
        if (this.isParameterizable()) {
            Parameters parameters = this.m_context.getComponentProfile().getParameters();
            this.m_parameters = parameters != null ? parameters : Parameters.EMPTY_PARAMETERS;
        }
        ContextDescriptor contextDescriptor = this.m_context.getType().getContext();
        ContextDirective contextDirective = this.m_context.getComponentProfile().getContext();
        Logger log = this.getLogger().getChildLogger("context");
        this.m_contextModel = new DefaultContextModel(log, contextDescriptor, contextDirective, context);
        DependencyDescriptor[] dependencies = this.m_context.getType().getDependencies();
        this.m_dependencies = new DefaultDependencyModel[dependencies.length];
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyDescriptor descriptor = dependencies[i];
            DependencyDirective directive = context.getComponentProfile().getDependencyDirective(descriptor.getKey());
            this.m_dependencies[i] = new DefaultDependencyModel(context.getLogger().getChildLogger("deps"), context.getPartitionName(), context.getProfile().getName(), descriptor, directive);
        }
        StageDescriptor[] stages = this.m_context.getType().getStages();
        this.m_stages = new DefaultStageModel[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            StageDescriptor descriptor = stages[i];
            StageDirective directive = context.getComponentProfile().getStageDirective(descriptor.getKey());
            this.m_stages[i] = new DefaultStageModel(context.getLogger().getChildLogger("stages"), context.getPartitionName(), descriptor, directive);
        }
    }

    public boolean getDefaultActivationPolicy() {
        int activation = this.m_context.getComponentProfile().getActivationDirective();
        if (activation != -1) {
            return activation == 1;
        }
        if (this.m_context.getProfile().getMode() == Mode.EXPLICIT) {
            Type type = this.m_context.getType();
            return !type.getInfo().getLifestyle().equals("transient");
        }
        return false;
    }

    public boolean isAssembled() {
        return this.isContextAssembled() && this.isStageAssembled() && this.isServiceAssembled();
    }

    private boolean isContextAssembled() {
        DeliveryDescriptor delivery;
        ContextModel model = this.getContextModel();
        if (model.isEnabled() && (delivery = this.getContextModel().getDeliveryDescriptor()) instanceof StagedDeliveryDescriptor) {
            return null != this.getContextModel().getProvider();
        }
        return true;
    }

    private boolean isStageAssembled() {
        StageModel[] stages = this.getStageModels();
        for (int i = 0; i < stages.length; ++i) {
            if (null != stages[i].getProvider()) continue;
            return false;
        }
        return true;
    }

    private boolean isServiceAssembled() {
        DependencyModel[] dependencies = this.getDependencyModels();
        for (int i = 0; i < dependencies.length; ++i) {
            if (null != dependencies[i].getProvider()) continue;
            return false;
        }
        return true;
    }

    public DeploymentModel[] getProviders() {
        DeploymentModel provider;
        if (!this.isAssembled()) {
            String error = "Model is not assembled " + this;
            throw new IllegalStateException(error);
        }
        ArrayList<DeploymentModel> list = new ArrayList<DeploymentModel>();
        if (this.getContextModel().isEnabled() && (provider = this.getContextModel().getProvider()) != null) {
            list.add(provider);
        }
        StageModel[] stages = this.getStageModels();
        for (int i = 0; i < stages.length; ++i) {
            StageModel stage = stages[i];
            list.add(stage.getProvider());
        }
        DependencyModel[] dependencies = this.getDependencyModels();
        for (int i = 0; i < dependencies.length; ++i) {
            DependencyModel dependency = dependencies[i];
            list.add(dependency.getProvider());
        }
        return list.toArray(new DeploymentModel[0]);
    }

    public ServiceDescriptor[] getServices() {
        return this.m_context.getType().getServices();
    }

    public boolean isaCandidate(DependencyDescriptor dependency) {
        return this.isaCandidate(dependency.getReference());
    }

    public boolean isaCandidate(StageDescriptor stage) {
        return this.m_context.getType().getExtension(stage) != null;
    }

    public boolean isaCandidate(ReferenceDescriptor reference) {
        return this.m_context.getType().getService(reference) != null;
    }

    public int getCollectionPolicy() {
        if (this.m_collection == -1) {
            return this.getTypeCollectionPolicy();
        }
        return this.m_collection;
    }

    public void setCollectionPolicy(int policy) {
        if (policy == -1) {
            this.m_collection = -1;
        } else {
            int minimum = this.getTypeCollectionPolicy();
            if (policy >= minimum) {
                this.m_collection = policy;
            } else {
                String warning = "Ignoring collection policy override [" + policy + "] because the value is higher that type threshhold [" + minimum + "].";
                this.getLogger().warn(warning);
            }
        }
    }

    private int getTypeCollectionPolicy() {
        return this.m_context.getType().getInfo().getCollectionPolicy();
    }

    public boolean getActivationPolicy() {
        return this.m_activation;
    }

    public void setActivationPolicy(boolean policy) {
        this.m_activation = policy;
    }

    public Type getType() {
        return this.m_context.getType();
    }

    public Class getDeploymentClass() {
        return this.m_context.getDeploymentClass();
    }

    public boolean isParameterizable() {
        return (class$org$apache$avalon$framework$parameters$Parameterizable == null ? (class$org$apache$avalon$framework$parameters$Parameterizable = DefaultComponentModel.class$("org.apache.avalon.framework.parameters.Parameterizable")) : class$org$apache$avalon$framework$parameters$Parameterizable).isAssignableFrom(this.getDeploymentClass()) || this.isaConstructorArg(class$org$apache$avalon$framework$parameters$Parameters == null ? (class$org$apache$avalon$framework$parameters$Parameters = DefaultComponentModel.class$("org.apache.avalon.framework.parameters.Parameters")) : class$org$apache$avalon$framework$parameters$Parameters);
    }

    public void setParameters(Parameters parameters) {
        this.setParameters(parameters, true);
    }

    public void setParameters(Parameters parameters, boolean policy) throws IllegalStateException {
        if (!this.isParameterizable()) {
            String error = REZ.getString("deployment.parameters.irrational", (Object)this.getDeploymentClass().getName(), (Object)this.toString());
            throw new IllegalStateException(error);
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (policy) {
            Properties props = Parameters.toProperties((Parameters)this.m_parameters);
            Properties suppliment = Parameters.toProperties((Parameters)parameters);
            Enumeration<?> enumeration = suppliment.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = suppliment.getProperty(name);
                if (value == null) {
                    ((Hashtable)props).remove(name);
                    continue;
                }
                props.setProperty(name, value);
            }
            this.m_parameters = Parameters.fromProperties((Properties)props);
        } else {
            this.m_parameters = parameters;
        }
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public boolean isConfigurable() {
        return (class$org$apache$avalon$framework$configuration$Configurable == null ? (class$org$apache$avalon$framework$configuration$Configurable = DefaultComponentModel.class$("org.apache.avalon.framework.configuration.Configurable")) : class$org$apache$avalon$framework$configuration$Configurable).isAssignableFrom(this.getDeploymentClass()) || this.isaConstructorArg(class$org$apache$avalon$framework$configuration$Configuration == null ? (class$org$apache$avalon$framework$configuration$Configuration = DefaultComponentModel.class$("org.apache.avalon.framework.configuration.Configuration")) : class$org$apache$avalon$framework$configuration$Configuration);
    }

    public void setConfiguration(Configuration config) throws IllegalStateException, NullPointerException {
        this.setConfiguration(config, true);
    }

    public void setConfiguration(Configuration config, boolean policy) throws IllegalStateException, NullPointerException {
        if (!this.isConfigurable()) {
            String error = REZ.getString("deployment.configuration.irrational", (Object)this.getDeploymentClass().getName(), (Object)this.toString());
            throw new IllegalStateException(error);
        }
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.m_config = policy ? this.consolidateConfigurations(config, this.m_config) : config;
    }

    public Configuration getConfiguration() {
        return this.m_config;
    }

    public ContextModel getContextModel() {
        return this.m_contextModel;
    }

    public DependencyModel[] getDependencyModels() {
        return this.m_dependencies;
    }

    public DependencyModel getDependencyModel(DependencyDescriptor dependency) {
        DependencyModel[] models = this.getDependencyModels();
        for (int i = 0; i < models.length; ++i) {
            DependencyModel model = models[i];
            if (!dependency.equals((Object)model.getDependency())) continue;
            return model;
        }
        return null;
    }

    public StageModel[] getStageModels() {
        return this.m_stages;
    }

    public StageModel getStageModel(StageDescriptor stage) {
        StageModel[] stages = this.getStageModels();
        for (int i = 0; i < stages.length; ++i) {
            StageModel model = stages[i];
            if (!stage.equals((Object)model.getStage())) continue;
            return model;
        }
        return null;
    }

    public Class[] getInterfaces() {
        ClassLoader classLoader = this.m_context.getClassLoader();
        ArrayList list = new ArrayList();
        ServiceDescriptor[] services = this.getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            String classname = service.getReference().getClassname();
            list.add(this.getComponentClass(classLoader, classname));
        }
        if (this.getType().getExtensions().length > 0) {
            Class<?>[] interfaces = this.getDeploymentClass().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                list.add(interfaces[i]);
            }
        }
        return list.toArray(new Class[0]);
    }

    public long getDeploymentTimeout() {
        String value = this.m_context.getType().getInfo().getAttribute("urn:composition:deployment.timeout", null);
        if (null != value) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                String error = "Invalid timout parameter [" + value + "] in component type [" + this.m_context.getType() + "].";
                throw new ModelRuntimeException(error, (Throwable)nfe);
            }
        }
        return super.getDeploymentTimeout();
    }

    private boolean isaConstructorArg(Class base) {
        if (null == base) {
            return false;
        }
        Class clazz = this.getDeploymentClass();
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] types = constructor.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!base.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    private Class getComponentClass(ClassLoader classLoader, String classname) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        try {
            return classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Configuration consolidateConfigurations(Configuration primary, Configuration defaults) {
        if (primary == null) {
            return defaults;
        }
        if (defaults == null) {
            return primary;
        }
        return new CascadingConfiguration(primary, defaults);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

