/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.model.ClassLoaderModel;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DependencyGraph;
import org.apache.avalon.composition.model.ModelRepository;
import org.apache.avalon.composition.model.impl.DefaultDeploymentContext;
import org.apache.avalon.composition.model.impl.DefaultModelRepository;
import org.apache.avalon.composition.provider.ContainmentContext;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultContainmentContext
extends DefaultDeploymentContext
implements ContainmentContext {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContainmentContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultContainmentContext = DefaultContainmentContext.class$("org.apache.avalon.composition.model.impl.DefaultContainmentContext")) : class$org$apache$avalon$composition$model$impl$DefaultContainmentContext));
    private final File m_home;
    private final File m_temp;
    private final ClassLoaderModel m_classloader;
    private final ContainmentProfile m_profile;
    private final ModelRepository m_repository;
    private final ContainmentModel m_parent;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContainmentContext;

    public DefaultContainmentContext(Logger logger, SystemContext system, ClassLoaderModel model, ModelRepository repository, DependencyGraph graph, ContainmentProfile profile) {
        this(logger, system, model, repository, graph, system.getHomeDirectory(), system.getTempDirectory(), null, profile, null, "");
    }

    public DefaultContainmentContext(Logger logger, SystemContext system, ClassLoaderModel model, ModelRepository repository, DependencyGraph graph, File home, File temp, ContainmentModel parent, ContainmentProfile profile, String partition, String name) {
        super(logger, system, partition, name, profile.getMode(), (DeploymentProfile)profile, graph);
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (home == null) {
            throw new NullPointerException("home");
        }
        if (temp == null) {
            throw new NullPointerException("temp");
        }
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        if (home.exists() && !home.isDirectory()) {
            String error = REZ.getString("containment.context.home.not-a-directory.error", (Object)home.toString());
            throw new IllegalArgumentException(error);
        }
        if (temp.exists() && !temp.isDirectory()) {
            String error = REZ.getString("containment.context.temp.not-a-directory.error", (Object)temp.toString());
            throw new IllegalArgumentException(error);
        }
        this.m_repository = new DefaultModelRepository(repository, logger);
        this.m_classloader = model;
        this.m_home = home;
        this.m_temp = temp;
        this.m_parent = parent;
        this.m_profile = profile;
    }

    public File getHomeDirectory() {
        return this.m_home;
    }

    public File getTempDirectory() {
        return this.m_temp;
    }

    public ContainmentProfile getContainmentProfile() {
        return this.m_profile;
    }

    public ModelRepository getModelRepository() {
        return this.m_repository;
    }

    public ClassLoaderModel getClassLoaderModel() {
        return this.m_classloader;
    }

    public ClassLoader getClassLoader() {
        return this.m_classloader.getClassLoader();
    }

    public ContainmentModel getParentContainmentModel() {
        return this.m_parent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

