/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.composition.data.ConstructorDirective;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.EntryDirective;
import org.apache.avalon.composition.data.ImportDirective;
import org.apache.avalon.composition.info.DeliveryDescriptor;
import org.apache.avalon.composition.info.InjectorDeliveryDescriptor;
import org.apache.avalon.composition.info.NativeDeliveryDescriptor;
import org.apache.avalon.composition.info.NullDeliveryDescriptor;
import org.apache.avalon.composition.info.StagedDeliveryDescriptor;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.EntryModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.impl.DefaultConstructorModel;
import org.apache.avalon.composition.model.impl.DefaultContext;
import org.apache.avalon.composition.model.impl.DefaultDependent;
import org.apache.avalon.composition.model.impl.DefaultImportModel;
import org.apache.avalon.composition.model.impl.OverrideEntryModel;
import org.apache.avalon.composition.provider.ComponentContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultContextModel
extends DefaultDependent
implements ContextModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContextModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultContextModel = DefaultContextModel.class$("org.apache.avalon.composition.model.impl.DefaultContextModel")) : class$org$apache$avalon$composition$model$impl$DefaultContextModel));
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$apache$avalon$composition$model$impl$DefaultContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultContext = DefaultContextModel.class$("org.apache.avalon.composition.model.impl.DefaultContext")) : class$org$apache$avalon$composition$model$impl$DefaultContext;
    private final ContextDescriptor m_descriptor;
    private final ContextDirective m_directive;
    private final ComponentContext m_context;
    private final Class m_strategy;
    private final Map m_models = new Hashtable();
    private final Map m_map = new Hashtable();
    private final Object m_componentContext;
    private final Class m_castingClass;
    private final DeliveryDescriptor m_delivery;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContextModel;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContext;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Context;

    public static boolean isaStandardKey(String key) {
        return key.startsWith("urn:avalon:") || key.startsWith("urn:composition:");
    }

    public DefaultContextModel(Logger logger, ContextDescriptor descriptor, ContextDirective directive, ComponentContext context) throws ModelException {
        super(logger);
        if (null == descriptor) {
            throw new NullPointerException("descriptor");
        }
        if (null == context) {
            throw new NullPointerException("context");
        }
        this.m_descriptor = descriptor;
        this.m_directive = directive;
        this.m_context = context;
        ClassLoader classLoader = context.getClassLoader();
        this.m_strategy = this.loadStrategyClass(descriptor, classLoader);
        Class impl = this.loadContextClass(directive, classLoader);
        this.m_castingClass = this.getContextCastingClass(descriptor, classLoader, impl);
        this.m_delivery = this.createDeliveryDescriptor(descriptor, context, this.m_castingClass);
        EntryDescriptor[] entries = descriptor.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            EntryDescriptor entry = entries[i];
            String alias = entry.getAlias();
            String key = entry.getKey();
            if (DefaultContextModel.isaStandardKey(key)) {
                DefaultImportModel model = new DefaultImportModel(entry, key, this.m_context);
                this.setEntryModel(alias, model);
                continue;
            }
            EntryDirective entryDirective = directive.getEntryDirective(key);
            if (null == entryDirective) {
                if (!entry.isRequired()) continue;
                String error = REZ.getString("context.missing-directive.error", (Object)key);
                throw new ModelException(error);
            }
            if (entryDirective instanceof ImportDirective) {
                ImportDirective importDirective = (ImportDirective)entryDirective;
                String ref = importDirective.getImportKey();
                DefaultImportModel model = new DefaultImportModel(entry, ref, this.m_context);
                this.setEntryModel(alias, model);
                continue;
            }
            if (entryDirective instanceof ConstructorDirective) {
                ConstructorDirective constructor = (ConstructorDirective)entryDirective;
                DefaultConstructorModel model = new DefaultConstructorModel(entry, constructor, context, this.m_map);
                this.setEntryModel(alias, model);
                continue;
            }
            String modelClass = entryDirective.getClass().getName();
            String error = REZ.getString("context.unsupported-directive.error", (Object)key, (Object)modelClass);
            throw new ModelException(error);
        }
        this.m_componentContext = this.createComponentContext(classLoader, impl, descriptor, directive, this.m_map);
    }

    public boolean isEnabled() {
        return this.m_delivery != null;
    }

    private DeliveryDescriptor createDeliveryDescriptor(ContextDescriptor descriptor, ComponentContext context, Class casting) throws ModelException {
        Class base = context.getDeploymentClass();
        ClassLoader classLoader = context.getClassLoader();
        String strategy = context.getType().getContext().getAttribute("urn:avalon:context.strategy", null);
        if ((class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = DefaultContextModel.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable).isAssignableFrom(base)) {
            return new NativeDeliveryDescriptor(casting);
        }
        if (this.isaConstructorArg(casting, base)) {
            return new InjectorDeliveryDescriptor(casting);
        }
        if (null != strategy) {
            Class contextualizable = this.loadClass(classLoader, strategy);
            if (contextualizable == null) {
                String error = REZ.getString("deployment.missing-strategy.error", (Object)strategy, (Object)base.getName());
                throw new IllegalStateException(error);
            }
            if (contextualizable.isAssignableFrom(base)) {
                return new StagedDeliveryDescriptor(casting, contextualizable);
            }
            String error = REZ.getString("deployment.inconsitent-strategy.error", (Object)contextualizable, (Object)base);
            throw new IllegalStateException(error);
        }
        if (context.getType().getStages().length > 0) {
            return new NullDeliveryDescriptor(class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultContextModel.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context);
        }
        return null;
    }

    private Class loadClass(ClassLoader classLoader, String classname) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        try {
            return classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public DeliveryDescriptor getDeliveryDescriptor() {
        return this.m_delivery;
    }

    public EntryModel[] getEntryModels() {
        return this.m_map.values().toArray(new EntryModel[0]);
    }

    public EntryModel getEntryModel(String key) {
        return (EntryModel)this.m_map.get(key);
    }

    public void setEntryModel(String key, EntryModel model) {
        this.m_map.put(key, model);
    }

    public void setEntry(String key, Object value) {
        EntryDescriptor descriptor = this.m_descriptor.getEntry(key);
        OverrideEntryModel model = new OverrideEntryModel(descriptor, value);
        this.setEntryModel(key, model);
    }

    public Class getStrategyClass() {
        return this.m_strategy;
    }

    public Class getCastingClass() {
        return this.m_castingClass;
    }

    public Object getContext() {
        return this.m_componentContext;
    }

    private Class loadStrategyClass(ContextDescriptor descriptor, ClassLoader classloader) throws ModelException {
        String strategy = this.m_descriptor.getAttribute("urn:avalon:context.strategy", null);
        if (strategy != null) {
            try {
                Class<?> clazz = classloader.loadClass(strategy);
                if (this.getLogger().isDebugEnabled()) {
                    String message = REZ.getString("context.strategy.custom", (Object)strategy);
                    this.getLogger().debug(message);
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                String error = REZ.getString("context.strategy.custom.missing.error", (Object)strategy);
                throw new ModelException(error);
            }
            catch (Throwable e) {
                String error = REZ.getString("context.strategy.custom.unexpected.error", (Object)strategy);
                throw new ModelException(error, e);
            }
        }
        try {
            Class<?> clazz = classloader.loadClass("org.apache.avalon.framework.context.Contextualizable");
            if (this.getLogger().isDebugEnabled()) {
                String message = REZ.getString("context.strategy.avalon");
                this.getLogger().debug(message);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            String error = REZ.getString("context.strategy.avalon.missing.error", (Object)"org.apache.avalon.framework.context.Contextualizable");
            throw new ModelException(error);
        }
        catch (Throwable e) {
            String error = REZ.getString("context.strategy.avalon.unexpected.error", (Object)"org.apache.avalon.framework.context.Contextualizable");
            throw new ModelException(error, e);
        }
    }

    private Object createComponentContext(ClassLoader classloader, Class clazz, ContextDescriptor descriptor, ContextDirective directive, Map map) throws ModelException {
        DefaultContext base = new DefaultContext(map);
        if (clazz.equals(class$org$apache$avalon$composition$model$impl$DefaultContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultContext = DefaultContextModel.class$("org.apache.avalon.composition.model.impl.DefaultContext")) : class$org$apache$avalon$composition$model$impl$DefaultContext)) {
            return base;
        }
        try {
            Constructor constructor = clazz.getConstructor(class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultContextModel.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context);
            return constructor.newInstance(base);
        }
        catch (NoSuchMethodException e) {
            String error = REZ.getString("context.non-compliance-constructor.error", (Object)clazz.getName());
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = REZ.getString("context.custom-unexpected.error", (Object)clazz.getName());
            throw new ModelException(error, e);
        }
    }

    private Class loadContextClass(ContextDirective directive, ClassLoader classLoader) throws ModelException {
        if (directive == null) {
            return DEFAULT_CONTEXT_CLASS;
        }
        String classname = directive.getClassname();
        if (classname == null) {
            return DEFAULT_CONTEXT_CLASS;
        }
        try {
            return classLoader.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Cannot load custom context implementation class: " + classname;
            throw new ModelException(error, e);
        }
    }

    private Class getContextCastingClass(ContextDescriptor descriptor, ClassLoader classLoader, Class clazz) throws ModelException {
        Class castingClass = null;
        String castingClassName = descriptor.getContextInterfaceClassname();
        if (castingClassName != null) {
            try {
                castingClass = classLoader.loadClass(castingClassName);
            }
            catch (Throwable e) {
                String error = "Cannot load custom context interface class: " + castingClassName;
                throw new ModelException(error, e);
            }
        } else {
            Class clazz2 = castingClass = class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultContextModel.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context;
        }
        if (!castingClass.isAssignableFrom(clazz)) {
            String error = "Supplied context implementation class: " + clazz.getName() + " does not implement the interface: " + castingClass.getName() + ".";
            throw new ModelException(error);
        }
        return castingClass;
    }

    private boolean isaConstructorArg(Class clazz, Class base) {
        if (null == base) {
            return false;
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] types = constructor.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!base.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

