/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.model.DependencyGraph;
import org.apache.avalon.composition.provider.DeploymentContext;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;

public class DefaultDeploymentContext
extends DefaultContext
implements DeploymentContext {
    private final String m_name;
    private final String m_partition;
    private final Logger m_logger;
    private final Mode m_mode;
    private final DependencyGraph m_graph;
    private final SystemContext m_system;
    private final DeploymentProfile m_profile;

    public DefaultDeploymentContext(Logger logger, SystemContext system, String partition, String name, Mode mode, DeploymentProfile profile, DependencyGraph graph) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (profile == null) {
            throw new NullPointerException("mode");
        }
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.m_profile = profile;
        this.m_graph = new DependencyGraph(graph);
        if (graph != null) {
            graph.addChild(this.m_graph);
        }
        this.m_logger = logger;
        this.m_system = system;
        this.m_partition = partition;
        this.m_name = name;
        this.m_mode = mode;
    }

    public SystemContext getSystemContext() {
        return this.m_system;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPartitionName() {
        return this.m_partition;
    }

    public String getQualifiedName() {
        if (null == this.getPartitionName()) {
            return "/";
        }
        return this.getPartitionName() + this.getName();
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public DeploymentProfile getProfile() {
        return this.m_profile;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public DependencyGraph getDependencyGraph() {
        return this.m_graph;
    }
}

