/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.impl.DefaultContextModel;
import org.apache.avalon.composition.model.impl.DefaultEntryModel;
import org.apache.avalon.composition.provider.ComponentContext;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultImportModel
extends DefaultEntryModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultImportModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultImportModel = DefaultImportModel.class$("org.apache.avalon.composition.model.impl.DefaultImportModel")) : class$org$apache$avalon$composition$model$impl$DefaultImportModel));
    private final EntryDescriptor m_descriptor;
    private final String m_key;
    private final ComponentContext m_context;
    private Object m_value;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultImportModel;

    public DefaultImportModel(EntryDescriptor descriptor, String key, ComponentContext context) throws ModelException {
        super(descriptor);
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.m_key = key;
        this.m_context = context;
        this.m_descriptor = descriptor;
        if (!DefaultContextModel.isaStandardKey(key)) {
            String error = REZ.getString("context.non-standard-key.error", (Object)key);
            throw new ModelException(error);
        }
        if (!descriptor.isVolatile()) {
            this.m_value = this.getValue();
        }
    }

    public Object getValue() throws ModelException {
        if (this.m_value != null) {
            return this.m_value;
        }
        return this.getStandardEntry(this.m_key);
    }

    private Object getStandardEntry(String key) {
        if (key.startsWith("urn:avalon:")) {
            return this.getStandardAvalonEntry(key);
        }
        if (key.startsWith("urn:composition:")) {
            return this.getStandardCompositionEntry(key);
        }
        String error = "Unknown key [" + key + "]";
        throw new IllegalArgumentException(error);
    }

    private Object getStandardAvalonEntry(String key) {
        if (key.equals("urn:avalon:name")) {
            return this.m_context.getName();
        }
        if (key.equals("urn:avalon:partition")) {
            return this.m_context.getPartitionName();
        }
        if (key.equals("urn:avalon:classloader")) {
            return this.m_context.getClassLoader();
        }
        if (key.equals("urn:avalon:home")) {
            return this.m_context.getHomeDirectory();
        }
        if (key.equals("urn:avalon:temp")) {
            return this.m_context.getTempDirectory();
        }
        return null;
    }

    private Object getStandardCompositionEntry(String key) {
        if (key.equals("urn:composition:containment.model")) {
            return this.m_context.getContainmentModel();
        }
        try {
            return this.m_context.getSystemContext().get((Object)key);
        }
        catch (ContextException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

