/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.SecurityProfile;
import org.apache.avalon.composition.data.builder.ContainmentProfileBuilder;
import org.apache.avalon.composition.data.builder.XMLContainmentProfileCreator;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.model.impl.DefaultClassLoaderContext;
import org.apache.avalon.composition.model.impl.DefaultClassLoaderModel;
import org.apache.avalon.composition.model.impl.DefaultComponentModel;
import org.apache.avalon.composition.model.impl.DefaultContainmentContext;
import org.apache.avalon.composition.model.impl.DefaultContainmentModel;
import org.apache.avalon.composition.model.impl.DefaultSecurityModel;
import org.apache.avalon.composition.provider.ComponentContext;
import org.apache.avalon.composition.provider.ContainmentContext;
import org.apache.avalon.composition.provider.ModelFactory;
import org.apache.avalon.composition.provider.SecurityModel;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultModelFactory
implements ModelFactory {
    private static final XMLContainmentProfileCreator CREATOR = new XMLContainmentProfileCreator();
    private static final ContainmentProfileBuilder BUILDER = new ContainmentProfileBuilder();
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultModelFactory == null ? (class$org$apache$avalon$composition$model$impl$DefaultModelFactory = DefaultModelFactory.class$("org.apache.avalon.composition.model.impl.DefaultModelFactory")) : class$org$apache$avalon$composition$model$impl$DefaultModelFactory));
    private static final SecurityModel NULL_SECURITY = new DefaultSecurityModel();
    private static final String DEFAULT_PROFILE_NAME = "default";
    private final SystemContext m_system;
    private final Logger m_logger;
    private final Map m_security = new Hashtable();
    private ContainmentModel m_root;
    private Map m_permissions = new Hashtable();
    private Map m_grants;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultModelFactory;

    DefaultModelFactory(SystemContext system, SecurityProfile[] profiles, Map grants) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (profiles == null) {
            throw new NullPointerException("profiles");
        }
        if (grants == null) {
            throw new NullPointerException("grants");
        }
        this.m_system = system;
        this.m_grants = grants;
        this.m_logger = system.getLogger();
        if (system.isCodeSecurityEnabled()) {
            for (int i = 0; i < profiles.length; ++i) {
                SecurityProfile profile = profiles[i];
                String name = profile.getName();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("adding security profile [" + name + "].");
                }
                try {
                    DefaultSecurityModel model = new DefaultSecurityModel(profile);
                    this.m_security.put(profile.getName(), model);
                    continue;
                }
                catch (Throwable e) {
                    String error = "Cannot include initial security model [" + name + "].";
                    throw new ModelRuntimeException(error, e);
                }
            }
            if (null == this.m_security.get(DEFAULT_PROFILE_NAME)) {
                String error = "Security enabled without a \"default\" profile.";
                throw new IllegalStateException("Security enabled without a \"default\" profile.");
            }
            Set entries = grants.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String profile = (String)entry.getValue();
                this.getNamedSecurityModel(profile);
            }
        }
    }

    public ContainmentModel createRootContainmentModel(URL url) throws ModelException {
        if (url.toString().endsWith(".xml")) {
            try {
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration config = builder.build(url.toString());
                ContainmentProfile profile = CREATOR.createContainmentProfile(config);
                return this.createRootContainmentModel(profile);
            }
            catch (ModelException e) {
                throw e;
            }
            catch (Throwable e) {
                String error = "Could not create model due to a build related error.";
                throw new ModelException("Could not create model due to a build related error.", e);
            }
        }
        try {
            URLConnection connection = url.openConnection();
            InputStream stream = connection.getInputStream();
            ContainmentProfile profile = BUILDER.createContainmentProfile(stream);
            return this.createRootContainmentModel(profile);
        }
        catch (Throwable e) {
            String error = REZ.getString("factory.containment.create-url.error", (Object)url.toString());
            throw new ModelException(error, e);
        }
    }

    public ContainmentModel createRootContainmentModel(ContainmentProfile profile) throws ModelException {
        try {
            ContainmentContext context = this.createRootContainmentContext(profile);
            this.m_root = this.createContainmentModel(context);
            return this.m_root;
        }
        catch (Throwable e) {
            String error = REZ.getString("factory.containment.create.error", (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    public ComponentModel createComponentModel(ComponentContext context) throws ModelException {
        String path = context.getQualifiedName();
        SecurityModel security = this.getAssignedSecurityModel(path);
        return new DefaultComponentModel(context, security);
    }

    public ContainmentModel createContainmentModel(ContainmentContext context) throws ModelException {
        String path = context.getQualifiedName();
        SecurityModel security = this.getAssignedSecurityModel(path);
        return new DefaultContainmentModel(context, security);
    }

    private ContainmentContext createRootContainmentContext(ContainmentProfile profile) throws ModelException {
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        this.m_system.getLoggingManager().addCategories(profile.getCategories());
        Logger logger = this.m_system.getLoggingManager().getLoggerForCategory("");
        try {
            Repository repository = this.m_system.getRepository();
            File base = this.m_system.getAnchorDirectory();
            ClassLoader root = this.m_system.getAPIClassLoader();
            ClassLoaderDirective classLoaderDirective = profile.getClassLoaderDirective();
            DefaultClassLoaderContext classLoaderContext = new DefaultClassLoaderContext(logger, repository, base, root, classLoaderDirective);
            DefaultClassLoaderModel classLoaderModel = new DefaultClassLoaderModel(classLoaderContext);
            return new DefaultContainmentContext(logger, this.m_system, classLoaderModel, null, null, profile);
        }
        catch (Throwable e) {
            String error = REZ.getString("factory.containment.create.error", (Object)profile.getName());
            throw new ModelException(error, e);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private SecurityModel getAssignedSecurityModel(String path) {
        if (this.m_system.isCodeSecurityEnabled()) {
            String profile = this.getAssignedProfileName(path);
            return this.getNamedSecurityModel(profile);
        }
        return NULL_SECURITY;
    }

    private SecurityModel getNamedSecurityModel(String name) {
        SecurityModel model = (SecurityModel)this.m_security.get(name);
        if (null != model) {
            return model;
        }
        String error = "Unknown security profile [" + name + "].";
        throw new IllegalArgumentException(error);
    }

    private String getAssignedProfileName(String path) {
        String profile = (String)this.m_grants.get(path);
        if (null != profile) {
            return profile;
        }
        return DEFAULT_PROFILE_NAME;
    }

    private SecurityModel getDefaultSecurityModel() {
        return (SecurityModel)this.m_security.get(DEFAULT_PROFILE_NAME);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

