/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.avalon.composition.data.SecurityProfile;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.impl.DefaultModelFactory;
import org.apache.avalon.composition.provider.ModelFactory;
import org.apache.avalon.composition.provider.Runtime;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.composition.provider.SystemException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.provider.Builder;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultSystemContext
extends DefaultContext
implements SystemContext {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultSystemContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultSystemContext = DefaultSystemContext.class$("org.apache.avalon.composition.model.impl.DefaultSystemContext")) : class$org$apache$avalon$composition$model$impl$DefaultSystemContext));
    private final File m_base;
    private final File m_home;
    private final File m_temp;
    private final File m_anchor;
    private final Repository m_repository;
    private final ClassLoader m_system;
    private final ClassLoader m_common;
    private final LoggingManager m_logging;
    private final Logger m_logger;
    private final ModelFactory m_factory;
    private final Runtime m_runtime;
    private final long m_timeout;
    private final boolean m_secure;
    private boolean m_trace;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultSystemContext;
    static /* synthetic */ Class class$org$apache$avalon$composition$provider$SystemContext;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$DeploymentModel;
    static /* synthetic */ Class class$org$apache$avalon$composition$provider$Runtime;
    static /* synthetic */ Class class$org$apache$avalon$repository$provider$InitialContext;
    static /* synthetic */ Class class$org$apache$avalon$repository$Artifact;

    DefaultSystemContext(InitialContext context, Context parent, Artifact artifact, Artifact lifestyle, Class runtime, LoggingManager logging, File base, File home, File temp, File anchor, Repository repository, String category, boolean trace, long timeout, boolean secure, SecurityProfile[] security, Map grants) throws SystemException {
        super(parent);
        this.assertNotNull("context", context);
        this.assertNotNull("base", base);
        this.assertNotNull("anchor", anchor);
        this.assertNotNull("repository", repository);
        this.assertNotNull("logging", logging);
        this.assertNotNull("category", category);
        this.assertNotNull("security", security);
        this.assertNotNull("grants", grants);
        if (!base.isDirectory()) {
            String error = REZ.getString("system.error.base-not-a-directory", (Object)base);
            throw new IllegalArgumentException(error);
        }
        this.m_base = base;
        this.m_home = home;
        this.m_temp = temp;
        this.m_anchor = anchor;
        this.m_trace = trace;
        this.m_repository = repository;
        this.m_logging = logging;
        this.m_timeout = timeout;
        this.m_logger = this.m_logging.getLoggerForCategory(category);
        this.m_system = (class$org$apache$avalon$composition$provider$SystemContext == null ? (class$org$apache$avalon$composition$provider$SystemContext = DefaultSystemContext.class$("org.apache.avalon.composition.provider.SystemContext")) : class$org$apache$avalon$composition$provider$SystemContext).getClassLoader();
        this.m_common = (class$org$apache$avalon$composition$model$DeploymentModel == null ? (class$org$apache$avalon$composition$model$DeploymentModel = DefaultSystemContext.class$("org.apache.avalon.composition.model.DeploymentModel")) : class$org$apache$avalon$composition$model$DeploymentModel).getClassLoader();
        this.m_secure = secure;
        if (this.m_secure && System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        this.m_factory = new DefaultModelFactory(this, security, grants);
        if (null != runtime) {
            this.m_runtime = this.buildRuntimeInstance(context, runtime, lifestyle);
        } else if (null != artifact) {
            Class clazz = this.resolveRuntimeClass(context, artifact);
            this.m_runtime = this.buildRuntimeInstance(context, clazz, lifestyle);
        } else {
            this.m_runtime = null;
        }
    }

    public boolean isCodeSecurityEnabled() {
        return this.m_secure;
    }

    public ModelFactory getModelFactory() {
        return this.m_factory;
    }

    public File getBaseDirectory() {
        return this.m_base;
    }

    public File getHomeDirectory() {
        return this.m_home;
    }

    public File getTempDirectory() {
        return this.m_temp;
    }

    public File getAnchorDirectory() {
        return this.m_anchor;
    }

    public Repository getRepository() {
        return this.m_repository;
    }

    public ClassLoader getAPIClassLoader() {
        return this.m_common;
    }

    public ClassLoader getSPIClassLoader() {
        return this.m_system;
    }

    public boolean isTraceEnabled() {
        return this.m_trace;
    }

    public void setTraceEnabled(boolean trace) {
        this.m_trace = trace;
    }

    public LoggingManager getLoggingManager() {
        return this.m_logging;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public long getDefaultDeploymentTimeout() {
        return this.m_timeout;
    }

    public void commission(DeploymentModel model) throws Exception {
        this.getRuntime().commission(model);
    }

    public void decommission(DeploymentModel model) {
        this.getRuntime().decommission(model);
    }

    public Object resolve(DeploymentModel model) throws Exception {
        return this.getRuntime().resolve(model);
    }

    public Object resolve(DeploymentModel model, boolean proxy) throws Exception {
        return this.getRuntime().resolve(model, proxy);
    }

    public void release(DeploymentModel model, Object instance) {
        this.getRuntime().release(model, instance);
    }

    private Runtime getRuntime() {
        if (null == this.m_runtime) {
            throw new IllegalStateException("runtime");
        }
        return this.m_runtime;
    }

    private Class resolveRuntimeClass(InitialContext context, Artifact artifact) throws SystemException {
        if (null != artifact) {
            return this.getRuntimeClass(context, artifact);
        }
        return this.getRuntimeClass(context, this.getDefaultRuntimeArtifact(context));
    }

    private Class getRuntimeClass(InitialContext context, Artifact artifact) throws SystemException {
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        try {
            ClassLoader classloader = (class$org$apache$avalon$composition$model$impl$DefaultSystemContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultSystemContext = DefaultSystemContext.class$("org.apache.avalon.composition.model.impl.DefaultSystemContext")) : class$org$apache$avalon$composition$model$impl$DefaultSystemContext).getClassLoader();
            Builder builder = context.newBuilder(classloader, artifact);
            return builder.getFactoryClass();
        }
        catch (Throwable e) {
            String error = REZ.getString("system.error.load", (Object)artifact.toString());
            throw new SystemException(error, e);
        }
    }

    private Artifact getDefaultRuntimeArtifact(InitialContext context) {
        Artifact[] artifacts = context.getRepository().getCandidates(class$org$apache$avalon$composition$provider$Runtime == null ? (class$org$apache$avalon$composition$provider$Runtime = DefaultSystemContext.class$("org.apache.avalon.composition.provider.Runtime")) : class$org$apache$avalon$composition$provider$Runtime);
        if (artifacts.length > 0) {
            return artifacts[0];
        }
        String error = "Initial context does not declare an artifact for the class: [" + (class$org$apache$avalon$composition$provider$Runtime == null ? (class$org$apache$avalon$composition$provider$Runtime = DefaultSystemContext.class$("org.apache.avalon.composition.provider.Runtime")) : class$org$apache$avalon$composition$provider$Runtime).getName() + "].";
        throw new IllegalStateException(error);
    }

    public Runtime buildRuntimeInstance(InitialContext context, Class clazz, Artifact lifestyle) throws SystemException {
        if (null == clazz) {
            return null;
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length < 1) {
            String error = REZ.getString("system.error.runtime.no-constructor", (Object)clazz.getName());
            throw new SystemException(error);
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] classes = constructor.getParameterTypes();
        Object[] args = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<?> c;
            if ((class$org$apache$avalon$composition$provider$SystemContext == null ? DefaultSystemContext.class$("org.apache.avalon.composition.provider.SystemContext") : class$org$apache$avalon$composition$provider$SystemContext).isAssignableFrom(c = classes[i])) {
                args[i] = this;
                continue;
            }
            if ((class$org$apache$avalon$repository$provider$InitialContext == null ? DefaultSystemContext.class$("org.apache.avalon.repository.provider.InitialContext") : class$org$apache$avalon$repository$provider$InitialContext).isAssignableFrom(c)) {
                args[i] = context;
                continue;
            }
            if ((class$org$apache$avalon$repository$Artifact == null ? DefaultSystemContext.class$("org.apache.avalon.repository.Artifact") : class$org$apache$avalon$repository$Artifact).isAssignableFrom(c)) {
                args[i] = lifestyle;
                continue;
            }
            String error = REZ.getString("system.error.unrecognized-runtime-parameter", (Object)c.getName(), (Object)clazz.getName());
            throw new SystemException(error);
        }
        return this.instantiateRuntime(constructor, args);
    }

    private Runtime instantiateRuntime(Constructor constructor, Object[] args) throws SystemException {
        Class clazz = constructor.getDeclaringClass();
        try {
            return (Runtime)constructor.newInstance(args);
        }
        catch (Throwable e) {
            String error = REZ.getString("system.error.runtime-instantiation", (Object)clazz.getName());
            throw new SystemException(error, e);
        }
    }

    private void assertNotNull(String name, Object object) {
        if (null == object) {
            throw new NullPointerException(name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

