/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.ant;

import com.thoughtworks.qdox.ant.AbstractQdoxTask;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.ant.FormatEnum;
import org.apache.avalon.meta.info.builder.tags.ServiceTag;
import org.apache.avalon.meta.info.builder.tags.TypeTag;
import org.apache.avalon.meta.info.writer.SerializedServiceWriter;
import org.apache.avalon.meta.info.writer.SerializedTypeWriter;
import org.apache.avalon.meta.info.writer.ServiceWriter;
import org.apache.avalon.meta.info.writer.TypeWriter;
import org.apache.avalon.meta.info.writer.XMLServiceWriter;
import org.apache.avalon.meta.info.writer.XMLTypeWriter;
import org.apache.tools.ant.BuildException;

public class MetaTask
extends AbstractQdoxTask {
    public static final int XML_TYPE = 0;
    public static final int SER_TYPE = 1;
    private static final TypeWriter XML_WRITER = new XMLTypeWriter();
    private static final TypeWriter SERIAL_WRITER = new SerializedTypeWriter();
    private static final ServiceWriter XML_SERVICE_WRITER = new XMLServiceWriter();
    private static final ServiceWriter SERIAL_SERVICE_WRITER = new SerializedServiceWriter();
    private File m_destDir;
    private int m_format;
    private String m_postfix = ".xinfo";
    private boolean m_force = true;

    public void setDestDir(File destDir) {
        this.m_destDir = destDir;
    }

    public void setFormat(FormatEnum format) {
        this.m_format = format.getTypeCode();
    }

    public void setForce(boolean force) {
        this.m_force = force;
    }

    public void setPostfix(String postfix) {
        if (!postfix.equalsIgnoreCase("xtype") && !postfix.equalsIgnoreCase("xinfo")) {
            String error = "Illegal postfix value: " + postfix + ". " + "Recognized values include 'xinfo' and 'xtype'.";
            throw new BuildException(error);
        }
        this.m_postfix = "." + postfix;
    }

    public void execute() throws BuildException {
        this.validate();
        String message = "Writing descriptors using '" + this.getOutputDescription() + "' format.";
        this.log(message);
        super.execute();
        this.addInnerClasses();
        try {
            Counter counter = this.writeMetaData();
            String update = "Processed " + counter.getTypes() + " Types and " + counter.getServices() + " Services from a total of " + counter.getCount() + " classes.";
            this.log(update);
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e);
        }
    }

    private void addInnerClasses() {
        ArrayList expList = new ArrayList();
        for (int i = 0; i < this.allClasses.size(); ++i) {
            this.addWithInnerClasses(expList, (JavaClass)this.allClasses.get(i));
        }
        this.allClasses = expList;
    }

    private void addWithInnerClasses(ArrayList list, JavaClass javaClass) {
        list.add(javaClass);
        JavaClass[] innerClasses = javaClass.getInnerClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            this.addWithInnerClasses(list, innerClasses[i]);
        }
    }

    private void validate() {
        if (null == this.m_destDir) {
            String message = "DestDir (" + this.m_destDir + ") not specified";
            throw new BuildException(message);
        }
        if (!this.m_destDir.isDirectory()) {
            String message = "DestDir (" + this.m_destDir + ") is not a directory.";
            throw new BuildException(message);
        }
        if (!this.m_destDir.exists() && !this.m_destDir.mkdirs()) {
            String message = "DestDir (" + this.m_destDir + ") could not be created.";
            throw new BuildException(message);
        }
    }

    private String getOutputDescription() {
        if (1 == this.m_format) {
            return "serial";
        }
        return "xml";
    }

    private Counter writeMetaData() throws IOException {
        int services = 0;
        int types = 0;
        int size = this.allClasses.size();
        for (int i = 0; i < size; ++i) {
            File parent;
            File dest;
            File source;
            String classname;
            JavaClass javaClass = (JavaClass)this.allClasses.get(i);
            if (javaClass.isInterface()) {
                Service service = new ServiceTag(javaClass).getService();
                if (service == null) continue;
                ++services;
                classname = javaClass.getFullyQualifiedName();
                source = javaClass.getParentSource().getFile();
                dest = this.getOutputFileForService(classname);
                if (!this.m_force && dest.exists() && dest.lastModified() >= source.lastModified()) continue;
                parent = dest.getParentFile();
                if (null != parent && !parent.exists() && !parent.mkdirs()) {
                    String message = "Failed to create output directory: " + parent;
                    throw new BuildException(message);
                }
                this.writeService(service);
                continue;
            }
            Type type = new TypeTag(javaClass).getType();
            if (type == null) continue;
            ++types;
            classname = javaClass.getFullyQualifiedName();
            source = javaClass.getParentSource().getFile();
            dest = this.getOutputFileForClass(classname);
            if (!this.m_force && dest.exists() && dest.lastModified() >= source.lastModified()) continue;
            parent = dest.getParentFile();
            if (null != parent && !parent.exists() && !parent.mkdirs()) {
                String message = "Failed to create output directory: " + parent;
                throw new BuildException(message);
            }
            this.writeType(type);
        }
        return new Counter(size, services, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeService(Service service) throws IOException {
        String fqn = service.getReference().getClassname();
        File file = this.getOutputFileForService(fqn);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            this.getServiceWriter().writeService(service, (OutputStream)outputStream);
        }
        catch (Exception e) {
            this.log("Error writing service to " + file + ". Cause: " + e);
        }
        finally {
            this.shutdownStream(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeType(Type type) throws IOException {
        String fqn = type.getInfo().getClassname();
        File file = this.getOutputFileForClass(fqn);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            this.getTypeWriter().writeType(type, (OutputStream)outputStream);
        }
        catch (Exception e) {
            this.log("Error writing " + file + ". Cause: " + e);
        }
        finally {
            this.shutdownStream(outputStream);
        }
    }

    private TypeWriter getTypeWriter() {
        if (1 == this.m_format) {
            return SERIAL_WRITER;
        }
        return XML_WRITER;
    }

    private ServiceWriter getServiceWriter() {
        if (1 == this.m_format) {
            return SERIAL_SERVICE_WRITER;
        }
        return XML_SERVICE_WRITER;
    }

    private File getOutputFileForClass(String classname) throws IOException {
        String filename = classname.replace('.', File.separatorChar);
        filename = 1 == this.m_format ? filename + ".stype" : filename + this.m_postfix;
        return new File(this.m_destDir, filename).getCanonicalFile();
    }

    private File getOutputFileForService(String classname) throws IOException {
        String filename = classname.replace('.', File.separatorChar);
        filename = 1 == this.m_format ? filename + ".sservice" : filename + ".xservice";
        return new File(this.m_destDir, filename).getCanonicalFile();
    }

    private void shutdownStream(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final File getDestDir() {
        return this.m_destDir;
    }

    private class Counter {
        private int m_services;
        private int m_types;
        private int m_count;

        Counter(int count, int services, int types) {
            this.m_count = count;
            this.m_services = services;
            this.m_types = types;
        }

        protected int getServices() {
            return this.m_services;
        }

        protected int getTypes() {
            return this.m_types;
        }

        protected int getCount() {
            return this.m_count;
        }
    }
}

