/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.builder.tags.AbstractTag;

public class ContextTag
extends AbstractTag {
    protected static final String CONTEXT_CLASS = "org.apache.avalon.framework.context.Context";
    public static final String KEY = "context";
    public static final String STRATEGY_PARAM = "strategy";
    public static final String KEY_PARAM = "key";
    public static final String VOLATILE_PARAM = "volatile";
    public static final String ALIAS_PARAM = "alias";
    public static final String OPTIONAL_PARAM = "optional";
    public static final String ENTRY = "entry";

    public ContextTag(JavaClass clazz) {
        super(clazz);
    }

    public ContextDescriptor getContext() {
        JavaMethod[] methods = this.findTaggedMethods(this.getJavaClass(), this.getNS() + "." + ENTRY);
        if (methods.length == 0) {
            return new ContextDescriptor(new EntryDescriptor[0]);
        }
        ArrayList<EntryDescriptor> list = new ArrayList<EntryDescriptor>();
        HashSet<String> marked = new HashSet<String>(10);
        for (int j = 0; j < methods.length; ++j) {
            DocletTag[] tags = methods[j].getTagsByName(this.getNS() + "." + ENTRY);
            for (int i = 0; i < tags.length; ++i) {
                String key = this.getNamedParameter(tags[i], KEY_PARAM);
                if (marked.contains(key)) continue;
                list.add(this.getEntry(tags[i]));
                marked.add(key);
            }
        }
        EntryDescriptor[] entries = list.toArray(new EntryDescriptor[list.size()]);
        String type = null;
        String strategy = null;
        for (int j = 0; j < methods.length; ++j) {
            JavaMethod method = methods[j];
            DocletTag tag = method.getTagByName(this.getNS() + "." + KEY);
            if (tag == null) continue;
            type = this.resolveType(this.getNamedParameter(tag, "type", CONTEXT_CLASS));
            strategy = this.getNamedParameter(tag, STRATEGY_PARAM, null);
            break;
        }
        Properties properties = null;
        if (strategy != null) {
            properties = new Properties();
            properties.setProperty("urn:avalon:context.strategy", strategy);
        }
        return new ContextDescriptor(type, entries, properties);
    }

    private EntryDescriptor getEntry(DocletTag tag) {
        String key = this.getNamedParameter(tag, KEY_PARAM);
        String alias = this.getNamedParameter(tag, ALIAS_PARAM, null);
        String entryType = this.getNamedParameter(tag, "type", "java.lang.String");
        String optional = this.getNamedParameter(tag, OPTIONAL_PARAM, "false");
        boolean isOptional = "true".equals(optional);
        String volatileValue = this.getNamedParameter(tag, VOLATILE_PARAM, "false");
        boolean isVolatile = "true".equals(volatileValue);
        return new EntryDescriptor(key, entryType, isOptional, isVolatile, alias);
    }
}

