/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.impl;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.RepositoryRuntimeException;
import org.apache.avalon.repository.meta.FactoryDescriptor;
import org.apache.avalon.repository.meta.MetaException;
import org.apache.avalon.repository.util.LoaderUtils;
import org.apache.avalon.repository.util.RepositoryUtils;

public class DefaultRepository
implements Repository {
    private final File m_cache;
    private final LoaderUtils m_loader;
    private final List m_descriptors = new ArrayList();
    private URL[] m_hosts;
    private String[] m_roots;
    private boolean m_online;

    DefaultRepository(File cache, String[] hosts, boolean online, Artifact[] candidates) throws RepositoryException {
        if (cache == null) {
            throw new NullPointerException("cache");
        }
        if (hosts == null) {
            throw new NullPointerException("hosts");
        }
        if (candidates == null) {
            throw new NullPointerException("candidates");
        }
        this.m_cache = cache;
        this.m_roots = RepositoryUtils.getCleanPaths((String[])hosts);
        this.m_hosts = this.getHosts(this.m_roots);
        this.m_online = online;
        this.m_loader = new LoaderUtils(online);
        this.setupRegistry(candidates);
    }

    public Attributes getAttributes(Artifact artifact) throws RepositoryException {
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        try {
            return RepositoryUtils.getAsAttributes((Properties)RepositoryUtils.getProperties((URL)this.getResource(artifact, "meta")));
        }
        catch (Throwable e) {
            String error = "Unable to retrieve the metadata for the artifact :" + artifact;
            throw new RepositoryException(error, e);
        }
    }

    public Artifact[] getCandidates(Class service) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        String classname = service.getName();
        FactoryDescriptor[] descriptors = this.getFactoryDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            FactoryDescriptor descriptor = descriptors[i];
            String key = descriptor.getInterface();
            if (!classname.equals(key)) continue;
            list.add(descriptor.getArtifact());
        }
        return list.toArray(new Artifact[0]);
    }

    public URL getResource(Artifact artifact) throws RepositoryException {
        return this.m_loader.getResource(artifact, this.m_roots, this.m_cache, true);
    }

    private URL getResource(Artifact artifact, String mime) throws RepositoryException {
        return this.m_loader.getResource(artifact, mime, this.m_roots, this.m_cache, true);
    }

    public ClassLoader getClassLoader(Artifact artifact) throws RepositoryException {
        return this.getClassLoader(ClassLoader.getSystemClassLoader(), artifact);
    }

    public ClassLoader getClassLoader(ClassLoader parent, Artifact artifact) throws RepositoryException {
        if (null == parent) {
            throw new NullPointerException("parent");
        }
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        Attributes attributes = this.getAttributes(artifact);
        FactoryDescriptor relational = null;
        try {
            relational = new FactoryDescriptor(attributes);
        }
        catch (MetaException me) {
            String error = "Could not create a relational descriptor from the artifact: " + artifact;
            throw new RepositoryException(error, (Throwable)me);
        }
        URL[] apis = this.getURLs(relational.getDependencies("avalon.artifact.dependency.api"));
        ClassLoader api = this.buildClassLoader(apis, parent);
        URL[] spis = this.getURLs(relational.getDependencies("avalon.artifact.dependency.spi"));
        ClassLoader spi = this.buildClassLoader(spis, api);
        URL[] imps = this.getURLs(artifact, relational.getDependencies("avalon.artifact.dependency"));
        return this.buildClassLoader(imps, spi);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.m_cache.toString());
        for (int i = 0; i < this.m_hosts.length; ++i) {
            buffer.append(", ");
            buffer.append(this.m_hosts[i]);
        }
        return buffer.toString();
    }

    private URL[] getHosts(String[] paths) {
        URL[] hosts = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            try {
                hosts[i] = new URL(path);
                continue;
            }
            catch (Throwable e) {
                String error = "Internal error while attempting to construct url for host: " + path;
                throw new RepositoryRuntimeException(error, e);
            }
        }
        return hosts;
    }

    private ClassLoader buildClassLoader(URL[] urls, ClassLoader parent) {
        if (0 == urls.length) {
            return parent;
        }
        return new URLClassLoader(urls, parent);
    }

    private URL[] getURLs(Artifact[] artifacts) throws RepositoryException {
        URL[] urls = new URL[artifacts.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = this.getResource(artifacts[i]);
        }
        return urls;
    }

    private URL[] getURLs(Artifact primary, Artifact[] artifacts) throws RepositoryException {
        URL[] urls = new URL[artifacts.length + 1];
        for (int i = 0; i < artifacts.length; ++i) {
            urls[i] = this.getResource(artifacts[i]);
        }
        urls[artifacts.length] = this.getResource(primary);
        return urls;
    }

    private void setupRegistry(Artifact[] artifacts) throws RepositoryException {
        for (int i = 0; i < artifacts.length; ++i) {
            Artifact artifact = artifacts[i];
            this.registerArtifact(artifact);
        }
    }

    private void registerArtifact(Artifact artifact) throws RepositoryException {
        Attributes attributes = this.getAttributes(artifact);
        FactoryDescriptor descriptor = new FactoryDescriptor(attributes);
        String key = descriptor.getInterface();
        if (null == key) {
            String error = "Artifact [" + artifact + "] does not declare a exported interface.";
            throw new RepositoryException(error);
        }
        if (!this.m_descriptors.contains(descriptor)) {
            this.m_descriptors.add(descriptor);
        }
    }

    private FactoryDescriptor[] getFactoryDescriptors() {
        return this.m_descriptors.toArray(new FactoryDescriptor[0]);
    }
}

