/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.main;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.main.AbstractBuilder;
import org.apache.avalon.repository.main.DefaultAuthenticator;
import org.apache.avalon.repository.main.DefaultBuilder;
import org.apache.avalon.repository.meta.FactoryDescriptor;
import org.apache.avalon.repository.provider.Builder;
import org.apache.avalon.repository.provider.Factory;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.repository.provider.RepositoryCriteria;
import org.apache.avalon.repository.util.LoaderUtils;
import org.apache.avalon.repository.util.RepositoryUtils;

public class DefaultInitialContext
extends AbstractBuilder
implements InitialContext {
    public static final String BLOCK_GROUP_KEY = "Block-Group";
    private final String m_key;
    private final Factory m_factory;
    private final File m_cache;
    private final File m_base;
    private final Repository m_repository;
    private final LoaderUtils m_loader;
    private boolean m_online;
    private String[] m_hosts;

    DefaultInitialContext(String key, ClassLoader parent, Artifact artifact, Artifact[] candidates, File base, File cache, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String[] hosts, boolean online) throws RepositoryException {
        if (null == key) {
            throw new NullPointerException("key");
        }
        if (null == base) {
            throw new NullPointerException("base");
        }
        if (null == parent) {
            throw new NullPointerException("parent");
        }
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        if (null == cache) {
            throw new NullPointerException("cache");
        }
        if (null == hosts) {
            throw new NullPointerException("hosts");
        }
        if (null == candidates) {
            throw new NullPointerException("candidates");
        }
        this.m_key = key;
        this.m_base = base;
        this.m_cache = cache;
        this.m_online = online;
        this.m_hosts = hosts;
        this.m_loader = new LoaderUtils(this.m_online);
        this.setupProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
        Attributes attributes = this.loadAttributes(this.m_cache, this.m_hosts, artifact);
        FactoryDescriptor descriptor = new FactoryDescriptor(attributes);
        String factory = descriptor.getFactory();
        if (null == factory) {
            String error = "Required property 'avalon.artifact.factory' not present in artifact: " + artifact + " under the active cache: [" + this.m_cache + "] using the " + "attribute sequence: " + attributes;
            throw new IllegalArgumentException(error);
        }
        Artifact[] dependencies = descriptor.getDependencies();
        int n = dependencies.length;
        URL[] urls = new URL[n + 1];
        for (int i = 0; i < n; ++i) {
            urls[i] = this.m_loader.getResource(dependencies[i], this.m_hosts, this.m_cache, true);
        }
        urls[n] = this.m_loader.getResource(artifact, this.m_hosts, this.m_cache, true);
        URLClassLoader classloader = new URLClassLoader(urls, parent);
        Class clazz = this.loadFactoryClass(classloader, factory);
        try {
            this.m_factory = this.createDelegate(classloader, clazz, this);
            RepositoryCriteria criteria = (RepositoryCriteria)this.m_factory.createDefaultCriteria();
            criteria.setCacheDirectory(this.m_cache);
            criteria.setHosts(this.m_hosts);
            criteria.setOnlineMode(online);
            criteria.setFactoryArtifacts(candidates);
            this.m_repository = (Repository)this.m_factory.create(criteria);
        }
        catch (Throwable e) {
            String error = "Unable to establish a factory for the supplied artifact:";
            StringBuffer buffer = new StringBuffer("Unable to establish a factory for the supplied artifact:");
            buffer.append("\n artifact: " + artifact);
            buffer.append("\n build: " + descriptor.getBuild());
            buffer.append("\n factory: " + descriptor.getFactory());
            buffer.append("\n source: " + clazz.getProtectionDomain().getCodeSource().getLocation());
            buffer.append("\n cache: " + this.m_cache);
            throw new RepositoryException(buffer.toString(), e);
        }
    }

    private void setupProxy(String host, int port, String username, String password) {
        if (null == host) {
            return;
        }
        Properties system = System.getProperties();
        ((Hashtable)system).put("proxySet", "true");
        ((Hashtable)system).put("proxyHost", host);
        ((Hashtable)system).put("proxyPort", String.valueOf(port));
        if (null != username) {
            DefaultAuthenticator authenticator = new DefaultAuthenticator(username, password);
            Authenticator.setDefault(authenticator);
        }
    }

    public Repository getRepository() {
        return this.m_repository;
    }

    public boolean getOnlineMode() {
        return this.m_online;
    }

    public String getApplicationKey() {
        return this.m_key;
    }

    public File getInitialWorkingDirectory() {
        return this.m_base;
    }

    public File getInitialCacheDirectory() {
        return this.m_cache;
    }

    public String[] getInitialHosts() {
        return this.m_hosts;
    }

    public Factory getInitialFactory() {
        return this.m_factory;
    }

    public Builder newBuilder(Artifact artifact) throws Exception {
        return new DefaultBuilder(this, artifact);
    }

    public Builder newBuilder(ClassLoader classloader, Artifact artifact) throws Exception {
        return new DefaultBuilder(this, classloader, artifact);
    }

    public Manifest install(URL url) throws RepositoryException {
        String path = url.getFile();
        try {
            File temp = File.createTempFile("avalon-", "-bar");
            temp.delete();
            this.m_loader.getResource(url.toString(), temp, true);
            temp.deleteOnExit();
            StringBuffer buffer = new StringBuffer();
            Manifest manifest = this.expand(temp.toURL(), buffer);
            System.out.println(buffer.toString());
            return manifest;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable e) {
            String error = "Cannot install target: " + url;
            throw new RepositoryException(error, e);
        }
    }

    private Manifest expand(URL url, StringBuffer buffer) throws RepositoryException {
        try {
            URL jurl = new URL("jar:" + url.toString() + "!/");
            JarURLConnection connection = (JarURLConnection)jurl.openConnection();
            Manifest manifest = connection.getManifest();
            String group = this.getBlockGroup(manifest);
            buffer.append("\nBlock Group: " + group);
            File root = new File(this.m_cache, group);
            buffer.append("\nLocal target: " + root);
            JarFile jar = connection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().startsWith("META-INF")) continue;
                this.installEntry(buffer, root, jar, entry);
            }
            buffer.append("\nInstall successful.");
            return manifest;
        }
        catch (Throwable e) {
            String error = "Could not install block: " + url;
            throw new RepositoryException(error, e);
        }
    }

    private String getBlockGroup(Manifest manifest) {
        return manifest.getMainAttributes().getValue(BLOCK_GROUP_KEY);
    }

    private void installEntry(StringBuffer buffer, File root, JarFile jar, ZipEntry entry) throws Exception {
        int length;
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        File file = new File(root, name);
        long timestamp = entry.getTime();
        if (file.exists()) {
            if (file.lastModified() == timestamp) {
                buffer.append("\nEntry: " + name + " (already exists)");
                return;
            }
            if (file.lastModified() > timestamp) {
                buffer.append("\nEntry: " + name + " (local version is more recent)");
                return;
            }
            buffer.append("\nEntry: " + name + " (updating local version)");
        } else {
            buffer.append("\nEntry: " + name);
        }
        InputStream is = jar.getInputStream(entry);
        if (is == null) {
            String error = "Entry returned a null input stream: " + name;
            buffer.append("\n  " + error);
            throw new IOException(error);
        }
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buf = new byte[102400];
        while ((length = is.read(buf)) >= 0) {
            fos.write(buf, 0, length);
        }
        fos.close();
        is.close();
        if (timestamp < 0L) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            file.setLastModified(timestamp);
        }
    }

    private Attributes loadAttributes(File cache, String[] hosts, Artifact artifact) throws RepositoryException {
        try {
            return RepositoryUtils.getAttributes(cache, artifact);
        }
        catch (RepositoryException re) {
            return RepositoryUtils.getAttributes(hosts, artifact);
        }
    }
}

