/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.meta;

import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.meta.MetaException;

public class ArtifactDescriptor
implements Serializable {
    public static final String DOMAIN_KEY = "meta.domain";
    public static final String VERSION_KEY = "meta.version";
    public static final String BUILD_KEY = "avalon.artifact.signature";
    private final String c_domain;
    private final String c_version;
    private final String m_group;
    private final String m_name;
    private final String m_version;
    private final String m_build;
    private final Artifact m_artifact;

    public ArtifactDescriptor(Attributes attributes) throws MetaException {
        if (null == attributes) {
            throw new NullPointerException("attributes");
        }
        try {
            this.c_domain = this.getValue(attributes, DOMAIN_KEY);
            if (null == this.c_domain) {
                String error = "Missing attribute: meta.domain";
                throw new MetaException("Missing attribute: meta.domain");
            }
            this.c_version = this.getValue(attributes, VERSION_KEY);
            if (null == this.c_version) {
                String error = "Missing attribute: meta.version";
                throw new MetaException("Missing attribute: meta.version");
            }
            this.m_group = this.getAttribute(attributes, "avalon.artifact.group", "");
            this.m_name = this.getAttribute(attributes, "avalon.artifact.name", "");
            this.m_version = this.getAttribute(attributes, "avalon.artifact.version", "");
            this.m_build = this.getAttribute(attributes, BUILD_KEY, "");
            this.m_artifact = Artifact.createArtifact(this.m_group, this.m_name, this.m_version);
        }
        catch (NamingException e) {
            String error = "Unexpected naming exception during metadata creation.";
            throw new MetaException("Unexpected naming exception during metadata creation.", e);
        }
        catch (NoSuchElementException e) {
            String error = "Unexpected exception during metadata creation.";
            throw new MetaException("Unexpected exception during metadata creation.", e);
        }
    }

    public Artifact getArtifact() {
        return this.m_artifact;
    }

    public String getDomain() {
        return this.c_domain;
    }

    public String getVersion() {
        return this.c_version;
    }

    public String getBuild() {
        return this.m_build;
    }

    public boolean equals(Object other) {
        boolean isEqual = other instanceof ArtifactDescriptor;
        if (isEqual) {
            ArtifactDescriptor meta = (ArtifactDescriptor)other;
            isEqual = isEqual && this.c_domain.equals(meta.c_domain);
            isEqual = isEqual && this.c_version.equals(meta.c_version);
            isEqual = isEqual && this.m_group.equals(meta.m_version);
            isEqual = isEqual && this.m_name.equals(meta.m_name);
            isEqual = isEqual && this.m_version.equals(meta.m_version);
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = 1;
        hash >>>= 13;
        hash ^= this.c_domain.hashCode();
        hash >>>= 13;
        hash ^= this.c_version.hashCode();
        hash >>>= 13;
        hash ^= this.m_group.hashCode();
        hash >>>= 13;
        hash ^= this.m_version.hashCode();
        hash >>>= 13;
        hash ^= this.m_build.hashCode();
        return hash >>>= 13;
    }

    public String toString() {
        return "[artifact: " + this.getDomain() + "::" + this.getVersion() + "]";
    }

    private String getAttribute(Attributes attributes, String key, String def) {
        try {
            return this.getValue(attributes, key);
        }
        catch (Throwable e) {
            return def;
        }
    }

    protected String getValue(Attributes attributes, String key) throws NamingException, NoSuchElementException {
        Attribute attribute = attributes.get(key);
        if (null == attribute) {
            return null;
        }
        Object object = attribute.get();
        if (null == object) {
            return null;
        }
        return object.toString();
    }
}

