/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.extension.manager.impl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.avalon.extension.Extension;
import org.apache.avalon.extension.manager.ExtensionManager;
import org.apache.avalon.extension.manager.OptionalPackage;
import org.apache.avalon.extension.manager.impl.OptionalPackageComparator;

public class DelegatingExtensionManager
implements ExtensionManager {
    private final ArrayList m_extensionManagers = new ArrayList();

    public DelegatingExtensionManager() {
    }

    public DelegatingExtensionManager(ExtensionManager[] extensionManagers) {
        for (int i = 0; i < extensionManagers.length; ++i) {
            this.addExtensionManager(extensionManagers[i]);
        }
    }

    protected synchronized void addExtensionManager(ExtensionManager extensionManager) {
        if (!this.m_extensionManagers.contains(extensionManager)) {
            this.m_extensionManagers.add(extensionManager);
        }
    }

    protected void addPackageRepository(ExtensionManager extensionManager) {
        this.addExtensionManager(extensionManager);
    }

    protected synchronized void removeExtensionManager(ExtensionManager repository) {
        ((AbstractCollection)this.m_extensionManagers).remove(repository);
    }

    protected void removePackageRepository(ExtensionManager extensionManager) {
        this.removeExtensionManager(extensionManager);
    }

    public synchronized OptionalPackage[] getOptionalPackages(Extension extension) {
        ArrayList<OptionalPackage> resultPackages = new ArrayList<OptionalPackage>();
        int size = this.m_extensionManagers.size();
        for (int i = 0; i < size; ++i) {
            ExtensionManager repository = (ExtensionManager)this.m_extensionManagers.get(i);
            OptionalPackage[] packages = repository.getOptionalPackages(extension);
            if (null == packages || 0 == packages.length) continue;
            for (int j = 0; j < packages.length; ++j) {
                resultPackages.add(packages[j]);
            }
        }
        OptionalPackageComparator comparator = new OptionalPackageComparator(extension.getExtensionName());
        Collections.sort(resultPackages, comparator);
        OptionalPackage[] resultData = new OptionalPackage[resultPackages.size()];
        return resultPackages.toArray(resultData);
    }
}

