/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.baseline.plugin;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.header.Parameters;
import aQute.bnd.maven.baseline.plugin.Base;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.diff.Differ;
import aQute.lib.strings.Strings;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="baseline", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class BaselineMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(BaselineMojo.class);
    private static final String PACKAGING_POM = "pom";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(property="bnd.baseline.fail.on.missing", defaultValue="true")
    private boolean failOnMissing;
    @Parameter(property="bnd.baseline.include.distribution.management", defaultValue="true")
    private boolean includeDistributionManagement;
    @Parameter(property="bnd.baseline.full.report", defaultValue="false")
    private boolean fullReport;
    @Parameter(property="bnd.baseline.continue.on.error", defaultValue="false")
    private boolean continueOnError;
    @Parameter
    private Base base;
    @Parameter(required=false)
    private List<String> diffignores;
    @Parameter(required=false, defaultValue="*")
    private List<String> diffpackages;
    @Parameter(property="bnd.baseline.skip", defaultValue="false")
    private boolean skip;
    @Component
    private RepositorySystem system;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        if (PACKAGING_POM.equals(this.project.getPackaging())) {
            logger.info("skip project with packaging=pom");
            return;
        }
        Artifact artifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)this.project.getArtifact());
        List<RemoteRepository> aetherRepos = this.getRepositories(artifact);
        this.setupBase(artifact);
        try (Processor processor = new Processor();){
            this.searchForBaseVersion(aetherRepos);
            if (this.base.getVersion() != null && !this.base.getVersion().isEmpty()) {
                ReporterAdapter reporter;
                ArtifactResult artifactResult = this.locateBaseJar(aetherRepos);
                if (this.fullReport) {
                    reporter = new ReporterAdapter((Appendable)System.out);
                    reporter.setTrace(true);
                } else {
                    reporter = new ReporterAdapter();
                }
                DiffPluginImpl differ = new DiffPluginImpl();
                differ.setIgnore(new Parameters(Strings.join((String)",", this.diffignores), (Reporter)processor));
                Baseline baseline = new Baseline((Reporter)reporter, (Differ)differ);
                if (this.checkFailures(artifact, artifactResult, baseline, new Instructions(new Parameters(Strings.join((String)",", this.diffpackages), (Reporter)processor)))) {
                    if (!this.continueOnError) throw new MojoFailureException("The baselining plugin detected versioning errors");
                    logger.warn("The baselining check failed when checking {} against {} but the bnd-baseline-maven-plugin is configured not to fail the build.", (Object)artifact, (Object)artifactResult.getArtifact());
                    return;
                } else {
                    logger.info("Baselining check succeeded checking {} against {}", (Object)artifact, (Object)artifactResult.getArtifact());
                }
                return;
            } else {
                if (this.failOnMissing) {
                    throw new MojoFailureException("Unable to locate a previous version of the artifact");
                }
                logger.warn("No previous version of {} could be found to baseline against", (Object)artifact);
            }
            return;
        }
        catch (RepositoryException re) {
            throw new MojoFailureException("Unable to locate a previous version of the artifact", (Throwable)re);
        }
        catch (Exception e) {
            throw new MojoExecutionException("An error occurred while calculating the baseline", e);
        }
    }

    private List<RemoteRepository> getRepositories(Artifact artifact) {
        List aetherRepos = RepositoryUtils.toRepos((List)this.project.getRemoteArtifactRepositories());
        if (this.includeDistributionManagement) {
            RemoteRepository releaseDistroRepo;
            if (artifact.isSnapshot()) {
                MavenProject tmpClone = this.project.clone();
                tmpClone.getArtifact().setVersion("1.0.0");
                releaseDistroRepo = RepositoryUtils.toRepo((ArtifactRepository)tmpClone.getDistributionManagementArtifactRepository());
            } else {
                releaseDistroRepo = RepositoryUtils.toRepo((ArtifactRepository)this.project.getDistributionManagementArtifactRepository());
            }
            if (releaseDistroRepo != null) {
                aetherRepos.add(0, releaseDistroRepo);
            }
        }
        return aetherRepos;
    }

    private void setupBase(Artifact artifact) {
        if (this.base == null) {
            this.base = new Base();
        }
        if (this.base.getGroupId() == null || this.base.getGroupId().isEmpty()) {
            this.base.setGroupId(this.project.getGroupId());
        }
        if (this.base.getArtifactId() == null || this.base.getArtifactId().isEmpty()) {
            this.base.setArtifactId(this.project.getArtifactId());
        }
        if (this.base.getClassifier() == null || this.base.getClassifier().isEmpty()) {
            this.base.setClassifier(artifact.getClassifier());
        }
        if (this.base.getExtension() == null || this.base.getExtension().isEmpty()) {
            this.base.setExtension(artifact.getExtension());
        }
        if (this.base.getVersion() == null || this.base.getVersion().isEmpty()) {
            this.base.setVersion("(," + artifact.getVersion() + ")");
        }
        logger.debug("Baselining against {}, fail on missing: {}", (Object)this.base, (Object)this.failOnMissing);
    }

    private void searchForBaseVersion(List<RemoteRepository> aetherRepos) throws VersionRangeResolutionException {
        logger.info("Determining the baseline version for {} using repositories {}", (Object)this.base, aetherRepos);
        DefaultArtifact toFind = new DefaultArtifact(this.base.getGroupId(), this.base.getArtifactId(), this.base.getClassifier(), this.base.getExtension(), this.base.getVersion());
        VersionRangeRequest request = new VersionRangeRequest((Artifact)toFind, aetherRepos, "baseline");
        VersionRangeResult versions = this.system.resolveVersionRange(this.session, request);
        List found = versions.getVersions();
        logger.debug("Found versions {}", (Object)found);
        this.base.setVersion(null);
        ListIterator li = found.listIterator(found.size());
        while (li.hasPrevious()) {
            String highest = ((Version)li.previous()).toString();
            if (toFind.setVersion(highest).isSnapshot()) continue;
            this.base.setVersion(highest);
            break;
        }
        logger.info("The baseline version was found to be {}", (Object)this.base.getVersion());
    }

    private ArtifactResult locateBaseJar(List<RemoteRepository> aetherRepos) throws ArtifactResolutionException {
        DefaultArtifact toFind = new DefaultArtifact(this.base.getGroupId(), this.base.getArtifactId(), this.base.getClassifier(), this.base.getExtension(), this.base.getVersion());
        return this.system.resolveArtifact(this.session, new ArtifactRequest((Artifact)toFind, aetherRepos, "baseline"));
    }

    /*
     * Exception decompiling
     */
    private boolean checkFailures(Artifact artifact, ArtifactResult artifactResult, Baseline baseline, Instructions diffpackages) throws Exception, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

