/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.indexer.plugin;

import aQute.bnd.maven.indexer.plugin.LocalURLs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.indexer.ResourceAnalyzer;
import org.osgi.service.indexer.impl.KnownBundleAnalyzer;
import org.osgi.service.indexer.impl.RepoIndex;
import org.osgi.service.indexer.impl.URLResolver;

@Mojo(name="index", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class IndexerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(property="bnd.indexer.localURLs", defaultValue="FORBIDDEN", readonly=true)
    private LocalURLs localURLs;
    @Parameter(property="bnd.indexer.includeTransitive", defaultValue="true", readonly=true)
    private boolean includeTransitive;
    @Parameter(property="bnd.indexer.add.mvn.urls", defaultValue="false", readonly=true)
    private boolean addMvnURLs;
    @Parameter(property="bnd.indexer.scopes", readonly=true, required=false)
    private List<String> scopes;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private MetadataReader metadataReader;
    @Component
    private MavenProjectHelper projectHelper;
    private boolean fail;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileOutputStream output;
        Filter filter;
        DependencyResolutionResult result;
        if (this.scopes == null || this.scopes.isEmpty()) {
            this.scopes = Arrays.asList("compile", "runtime");
        }
        this.getLog().debug((CharSequence)("Indexing dependencies with scopes: " + this.scopes));
        this.getLog().debug((CharSequence)("Including Transitive dependencies: " + this.includeTransitive));
        this.getLog().debug((CharSequence)("Local file URLs permitted: " + (Object)((Object)this.localURLs)));
        this.getLog().debug((CharSequence)("Adding mvn: URLs as alternative content: " + this.addMvnURLs));
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(this.project, this.session);
        request.setResolutionFilter(new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                if (node.getDependency() != null) {
                    return IndexerMojo.this.scopes.contains(node.getDependency().getScope());
                }
                return false;
            }
        });
        try {
            result = this.resolver.resolve((DependencyResolutionRequest)request);
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        HashMap<File, ArtifactResult> dependencies = new HashMap<File, ArtifactResult>();
        if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
            this.discoverArtifacts(dependencies, result.getDependencyGraph().getChildren(), this.project.getArtifact().getId());
        }
        HashMap<String, ArtifactRepository> repositories = new HashMap<String, ArtifactRepository>();
        for (ArtifactRepository artifactRepository : this.project.getRemoteArtifactRepositories()) {
            repositories.put(artifactRepository.getId(), artifactRepository);
        }
        RepoIndex indexer = new RepoIndex();
        try {
            filter = FrameworkUtil.createFilter((String)"(name=*.jar)");
        }
        catch (InvalidSyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        indexer.addAnalyzer((ResourceAnalyzer)new KnownBundleAnalyzer(), filter);
        indexer.addURLResolver((URLResolver)new RepositoryURLResolver(dependencies, repositories));
        if (this.addMvnURLs) {
            indexer.addURLResolver((URLResolver)new MavenURLResolver(dependencies));
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("pretty", "true");
        File outputFile = new File(this.targetDir, "index.xml");
        try {
            this.targetDir.mkdirs();
            output = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.getLog().debug((CharSequence)("Indexing artifacts: " + dependencies.keySet()));
        try {
            indexer.index(dependencies.keySet(), (OutputStream)output, config);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (this.fail) {
            throw new MojoExecutionException("One or more URI lookups failed");
        }
        File gzipOutputFile = new File(outputFile.getPath() + ".gz");
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(outputFile));
             GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(gzipOutputFile));){
            int read;
            byte[] bytes = new byte[4096];
            while ((read = ((InputStream)is).read(bytes)) != -1) {
                ((OutputStream)gos).write(bytes, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to create the gzipped output file");
        }
        this.attach(outputFile, "osgi-index", "xml");
        this.attach(gzipOutputFile, "osgi-index", "xml.gz");
    }

    private void attach(File file, String type, String extension) {
        DefaultArtifactHandler handler = new DefaultArtifactHandler(type);
        handler.setExtension(extension);
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, type, null, (ArtifactHandler)handler);
        artifact.setFile(file);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    private void discoverArtifacts(Map<File, ArtifactResult> files, List<DependencyNode> nodes, String parent) throws MojoExecutionException {
        for (DependencyNode node : nodes) {
            try {
                ArtifactResult resolvedArtifact = this.postProcessResult(this.system.resolveArtifact(this.session, new ArtifactRequest(node.getArtifact(), this.project.getRemoteProjectRepositories(), parent)));
                this.getLog().debug((CharSequence)("Located file: " + resolvedArtifact.getArtifact().getFile() + " for artifact " + resolvedArtifact));
                files.put(resolvedArtifact.getArtifact().getFile(), resolvedArtifact);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failed to resolve the dependency " + node.getArtifact().toString(), (Exception)((Object)e));
            }
            if (this.includeTransitive) {
                this.discoverArtifacts(files, node.getChildren(), node.getRequestContext());
                continue;
            }
            this.getLog().debug((CharSequence)("Ignoring transitive dependencies of " + node.getDependency()));
        }
    }

    private ArtifactResult postProcessResult(ArtifactResult resolvedArtifact) throws MojoExecutionException {
        if (this.localURLs == LocalURLs.REQUIRED) {
            return resolvedArtifact;
        }
        String repoId = resolvedArtifact.getRepository().getId();
        org.eclipse.aether.artifact.Artifact artifact = resolvedArtifact.getArtifact();
        if ("workspace".equals(repoId) || "local".equals(repoId)) {
            this.getLog().debug((CharSequence)("Post processing " + artifact + " to determine a remote source"));
            ArtifactResult postProcessed = artifact.isSnapshot() ? this.postProcessSnapshot(resolvedArtifact.getRequest(), artifact) : this.postProcessRelease(resolvedArtifact.getRequest(), artifact);
            if (postProcessed != null) {
                return postProcessed;
            }
        }
        return resolvedArtifact;
    }

    private ArtifactResult postProcessSnapshot(ArtifactRequest request, org.eclipse.aether.artifact.Artifact artifact) throws MojoExecutionException {
        for (ArtifactRepository repository : this.project.getRemoteArtifactRepositories()) {
            if (!repository.getSnapshots().isEnabled()) continue;
            RemoteRepository aetherRepo = RepositoryUtils.toRepo((ArtifactRepository)repository);
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(this.session);
            newSession.setWorkspaceReader(null);
            MetadataRequest mr = new MetadataRequest().setRepository(aetherRepo).setMetadata((Metadata)new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "maven-metadata.xml", Metadata.Nature.SNAPSHOT));
            for (MetadataResult metadataResult : this.system.resolveMetadata((RepositorySystemSession)newSession, Collections.singletonList(mr))) {
                String version;
                if (!metadataResult.isResolved()) continue;
                try {
                    org.apache.maven.artifact.repository.metadata.Metadata read = this.metadataReader.read(metadataResult.getMetadata().getFile(), null);
                    Versioning versioning = read.getVersioning();
                    if (versioning == null || versioning.getSnapshotVersions() == null || versioning.getSnapshotVersions().isEmpty()) continue;
                    version = ((SnapshotVersion)versioning.getSnapshotVersions().get(0)).getVersion();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to read project metadata for " + artifact, e);
                }
                DefaultArtifact fullVersionArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), version);
                try {
                    ArtifactResult result = this.system.resolveArtifact((RepositorySystemSession)newSession, new ArtifactRequest().setArtifact((org.eclipse.aether.artifact.Artifact)fullVersionArtifact).addRepository(aetherRepo));
                    if (!result.isResolved()) continue;
                    File toUse = new File(this.session.getLocalRepository().getBasedir(), this.session.getLocalRepositoryManager().getPathForRemoteArtifact((org.eclipse.aether.artifact.Artifact)fullVersionArtifact, aetherRepo, artifact.toString()));
                    if (!toUse.exists()) {
                        this.getLog().warn((CharSequence)("The resolved artifact " + fullVersionArtifact + " does not exist at " + toUse));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Located snapshot file " + toUse + " for artifact " + artifact));
                    result.getArtifact().setFile(toUse);
                    return result;
                }
                catch (ArtifactResolutionException e) {
                    this.getLog().debug((CharSequence)("Unable to locate the artifact " + fullVersionArtifact), (Throwable)e);
                }
            }
        }
        this.getLog().debug((CharSequence)("Unable to resolve a remote repository containing " + artifact));
        return null;
    }

    private ArtifactResult postProcessRelease(ArtifactRequest request, org.eclipse.aether.artifact.Artifact artifact) throws MojoExecutionException {
        for (ArtifactRepository repository : this.project.getRemoteArtifactRepositories()) {
            if (!repository.getReleases().isEnabled()) continue;
            RemoteRepository aetherRepo = RepositoryUtils.toRepo((ArtifactRepository)repository);
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(this.session);
            newSession.setWorkspaceReader(null);
            MetadataRequest mr = new MetadataRequest().setRepository(aetherRepo).setMetadata((Metadata)new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), null, "maven-metadata.xml", Metadata.Nature.RELEASE));
            for (MetadataResult metadataResult : this.system.resolveMetadata((RepositorySystemSession)newSession, Collections.singletonList(mr))) {
                if (!metadataResult.isResolved()) continue;
                try {
                    ArtifactResult result;
                    org.apache.maven.artifact.repository.metadata.Metadata read = this.metadataReader.read(metadataResult.getMetadata().getFile(), null);
                    Versioning versioning = read.getVersioning();
                    if (versioning == null || versioning.getVersions() == null || versioning.getVersions().isEmpty() || !versioning.getVersions().contains(artifact.getVersion()) || !(result = this.system.resolveArtifact((RepositorySystemSession)newSession, new ArtifactRequest().setArtifact(artifact).addRepository(aetherRepo))).isResolved()) continue;
                    File toUse = new File(this.session.getLocalRepository().getBasedir(), this.session.getLocalRepositoryManager().getPathForLocalArtifact(artifact));
                    if (!toUse.exists()) {
                        this.getLog().warn((CharSequence)("The resolved artifact " + artifact + " does not exist at " + toUse));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Located snapshot file " + toUse + " for artifact " + artifact));
                    result.getArtifact().setFile(toUse);
                    return result;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to read project metadata for " + artifact, e);
                }
            }
        }
        this.getLog().debug((CharSequence)("Unable to resolve a remote repository containing " + artifact));
        return null;
    }

    class RepositoryURLResolver
    implements URLResolver {
        private final Map<File, ArtifactResult> dependencies;
        private final Map<String, ArtifactRepository> repositories;

        public RepositoryURLResolver(Map<File, ArtifactResult> dependencies, Map<String, ArtifactRepository> repositories) {
            this.dependencies = dependencies;
            this.repositories = repositories;
        }

        public URI resolver(File file) throws Exception {
            try {
                ArtifactResult artifactResult = this.dependencies.get(file);
                if (artifactResult == null) {
                    throw new FileNotFoundException("The file " + file.getCanonicalPath() + " is not known to this resolver");
                }
                if (IndexerMojo.this.localURLs == LocalURLs.REQUIRED) {
                    return file.toURI();
                }
                org.eclipse.aether.artifact.Artifact artifact = artifactResult.getArtifact();
                ArtifactRepository repo = this.repositories.get(artifactResult.getRepository().getId());
                if (repo == null) {
                    if (IndexerMojo.this.localURLs == LocalURLs.ALLOWED) {
                        IndexerMojo.this.getLog().info((CharSequence)("The Artifact " + artifact.toString() + " could not be found in any repository, returning the local location"));
                        return file.toURI();
                    }
                    throw new FileNotFoundException("The repository " + artifactResult.getRepository().getId() + " is not known to this resolver");
                }
                String baseUrl = repo.getUrl();
                if (baseUrl.startsWith("file:")) {
                    baseUrl = new File(baseUrl.substring(5)).toURI().normalize().toString();
                }
                if (!baseUrl.endsWith("/")) {
                    baseUrl = baseUrl + "/";
                }
                String artifactPath = repo.getLayout().pathOf(RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)artifact));
                while (artifactPath.startsWith("/")) {
                    artifactPath = artifactPath.substring(1);
                }
                return URI.create(baseUrl).resolve(artifactPath).normalize();
            }
            catch (Exception e) {
                IndexerMojo.this.fail = true;
                IndexerMojo.this.getLog().error((CharSequence)"Failed to determine the artifact URI", (Throwable)e);
                throw e;
            }
        }
    }

    class MavenURLResolver
    implements URLResolver {
        private final Map<File, ArtifactResult> dependencies;

        public MavenURLResolver(Map<File, ArtifactResult> dependencies) {
            this.dependencies = dependencies;
        }

        public URI resolver(File file) throws Exception {
            try {
                ArtifactResult artifactResult = this.dependencies.get(file);
                if (artifactResult == null) {
                    throw new FileNotFoundException("The file " + file.getCanonicalPath() + " is not known to this resolver");
                }
                org.eclipse.aether.artifact.Artifact artifact = artifactResult.getArtifact();
                StringBuilder sb = new StringBuilder("mvn://");
                sb.append(artifact.getGroupId()).append("/").append(artifact.getArtifactId()).append("/");
                if (artifact.getVersion() != null) {
                    sb.append(artifact.getVersion());
                }
                sb.append("/");
                String type = artifact.getProperty("type", artifact.getExtension());
                if (type != null) {
                    sb.append(type);
                }
                sb.append("/");
                if (artifact.getClassifier() != null) {
                    sb.append(artifact.getClassifier());
                }
                return URI.create(sb.toString()).normalize();
            }
            catch (Exception e) {
                IndexerMojo.this.fail = true;
                IndexerMojo.this.getLog().error((CharSequence)"Failed to determine the artifact URI", (Throwable)e);
                throw e;
            }
        }
    }
}

